/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.interfaces;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jd.event.JDBroadcaster;
import jd.event.JDEvent;
import jd.gui.swing.jdgui.interfaces.SwitchPanelEvent;
import jd.gui.swing.jdgui.interfaces.SwitchPanelListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SwitchPanel
extends JPanel {
    private static final long serialVersionUID = -7856570342778191232L;
    private boolean currentlyVisible = false;
    private JDBroadcaster<SwitchPanelListener, SwitchPanelEvent> broadcaster;

    public SwitchPanel(LayoutManager layout) {
        super(layout);
        this.initBroadcaster();
    }

    public SwitchPanel() {
        this.initBroadcaster();
    }

    private void initBroadcaster() {
        this.broadcaster = new JDBroadcaster<SwitchPanelListener, SwitchPanelEvent>(){

            protected void fireEvent(SwitchPanelListener listener, SwitchPanelEvent event) {
                listener.onPanelEvent(event);
            }
        };
    }

    public JDBroadcaster<SwitchPanelListener, SwitchPanelEvent> getBroadcaster() {
        return this.broadcaster;
    }

    protected abstract void onShow();

    protected abstract void onHide();

    public void setShown() {
        if (this.currentlyVisible) {
            return;
        }
        this.currentlyVisible = true;
        this.onShow();
        this.broadcaster.fireEvent((JDEvent)new SwitchPanelEvent(this, 0));
        this.distributeView(this);
    }

    private void distributeView(JComponent switchPanel) {
        Component[] componentArray = switchPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof JComponent && comp != switchPanel) {
                if (comp instanceof SwitchPanel) {
                    ((SwitchPanel)comp).setShown();
                } else {
                    this.distributeView((JComponent)comp);
                }
            }
            ++n2;
        }
    }

    private void distributeHide(JComponent switchPanel) {
        Component[] componentArray = switchPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof JComponent && comp != switchPanel) {
                if (comp instanceof SwitchPanel) {
                    ((SwitchPanel)comp).setHidden();
                } else {
                    this.distributeHide((JComponent)comp);
                }
            }
            ++n2;
        }
    }

    public void setHidden() {
        if (!this.currentlyVisible) {
            return;
        }
        this.currentlyVisible = false;
        this.onHide();
        this.broadcaster.fireEvent((JDEvent)new SwitchPanelEvent(this, 1));
        this.distributeHide(this);
    }

    public boolean isShown() {
        return this.currentlyVisible;
    }
}

