/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.settings.panels.premium;

import java.util.ArrayList;
import java.util.TreeMap;
import jd.HostPluginWrapper;
import jd.controlling.AccountController;
import jd.gui.swing.components.table.JDTableModel;
import jd.gui.swing.jdgui.settings.panels.premium.Columns.CashColumn;
import jd.gui.swing.jdgui.settings.panels.premium.Columns.EnabledColumn;
import jd.gui.swing.jdgui.settings.panels.premium.Columns.ExpireDateColumn;
import jd.gui.swing.jdgui.settings.panels.premium.Columns.FilesNumColumn;
import jd.gui.swing.jdgui.settings.panels.premium.Columns.HosterColumn;
import jd.gui.swing.jdgui.settings.panels.premium.Columns.PassColumn;
import jd.gui.swing.jdgui.settings.panels.premium.Columns.PremiumPointsColumn;
import jd.gui.swing.jdgui.settings.panels.premium.Columns.StatusColumn;
import jd.gui.swing.jdgui.settings.panels.premium.Columns.TrafficLeftColumn;
import jd.gui.swing.jdgui.settings.panels.premium.Columns.TrafficShareColumn;
import jd.gui.swing.jdgui.settings.panels.premium.Columns.UsedSpaceColumn;
import jd.gui.swing.jdgui.settings.panels.premium.Columns.UserColumn;
import jd.gui.swing.jdgui.settings.panels.premium.HostAccounts;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.utils.locale.JDL;

public class PremiumJTableModel
extends JDTableModel {
    private static final long serialVersionUID = 896539023856191287L;
    private ArrayList<HostPluginWrapper> plugins = HostPluginWrapper.getHostWrapper();
    private TreeMap<String, HostAccounts> hosts = new TreeMap();
    public static final String IDENT_PREFIX = "jd.gui.swing.jdgui.settings.panels.premium.PremiumJTableModel.";

    public PremiumJTableModel(String configname) {
        super(configname);
    }

    protected void initColumns() {
        this.addColumn(new HosterColumn(JDL.L((String)"jd.gui.swing.jdgui.settings.panels.premium.PremiumJTableModel.hoster", (String)"Hoster"), this));
        this.addColumn(new EnabledColumn(JDL.L((String)"jd.gui.swing.jdgui.settings.panels.premium.PremiumJTableModel.enabled", (String)"Enabled"), this));
        this.addColumn(new UserColumn(JDL.L((String)"jd.gui.swing.jdgui.settings.panels.premium.PremiumJTableModel.user", (String)"User"), this));
        this.addColumn(new PassColumn(JDL.L((String)"jd.gui.swing.jdgui.settings.panels.premium.PremiumJTableModel.pass", (String)"Password"), this));
        this.addColumn(new StatusColumn(JDL.L((String)"jd.gui.swing.jdgui.settings.panels.premium.PremiumJTableModel.status", (String)"Status"), this));
        this.addColumn(new ExpireDateColumn(JDL.L((String)"jd.gui.swing.jdgui.settings.panels.premium.PremiumJTableModel.expiredate", (String)"ExpireDate"), this));
        this.addColumn(new TrafficLeftColumn(JDL.L((String)"jd.gui.swing.jdgui.settings.panels.premium.PremiumJTableModel.trafficleft", (String)"Trafficleft"), this));
        this.addColumn(new TrafficShareColumn(JDL.L((String)"jd.gui.swing.jdgui.settings.panels.premium.PremiumJTableModel.trafficshare", (String)"TrafficShare"), this));
        this.addColumn(new PremiumPointsColumn(JDL.L((String)"jd.gui.swing.jdgui.settings.panels.premium.PremiumJTableModel.premiumpoints", (String)"PremiumPoints"), this));
        this.addColumn(new FilesNumColumn(JDL.L((String)"jd.gui.swing.jdgui.settings.panels.premium.PremiumJTableModel.filesnum", (String)"Number of Files"), this));
        this.addColumn(new CashColumn(JDL.L((String)"jd.gui.swing.jdgui.settings.panels.premium.PremiumJTableModel.cash", (String)"Cash"), this));
        this.addColumn(new UsedSpaceColumn(JDL.L((String)"jd.gui.swing.jdgui.settings.panels.premium.PremiumJTableModel.usedspace", (String)"Used Space"), this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshModel() {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
            long traffic = 0L;
            boolean gotenabled = false;
            for (HostPluginWrapper plugin : this.plugins) {
                ArrayList accs = AccountController.getInstance().getAllAccounts(plugin.getHost());
                if (accs.size() == 0) continue;
                HostAccounts ha = this.hosts.get(plugin.getHost());
                if (ha == null) {
                    ha = new HostAccounts(plugin.getHost());
                    this.hosts.put(plugin.getHost(), ha);
                }
                this.list.add(ha);
                traffic = 0L;
                gotenabled = false;
                ha.hasAccountInfos(false);
                for (Account acc : accs) {
                    AccountInfo ai;
                    this.list.add(acc);
                    if (acc.isEnabled()) {
                        gotenabled = true;
                    }
                    if ((ai = acc.getAccountInfo()) == null) continue;
                    ha.hasAccountInfos(true);
                    if (!acc.isValid()) continue;
                    if (ai.isUnlimitedTraffic()) {
                        traffic = -1L;
                        continue;
                    }
                    if (traffic == -1L) continue;
                    traffic += ai.getTrafficLeft();
                }
                ha.setTraffic(traffic);
                ha.setEnabled(gotenabled);
            }
        }
    }
}

