/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.settings.panels.premium;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jd.controlling.AccountController;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.components.table.JDTable;
import jd.gui.swing.jdgui.actions.ActionController;
import jd.gui.swing.jdgui.settings.panels.premium.HostAccounts;
import jd.gui.swing.jdgui.settings.panels.premium.Premium;
import jd.gui.swing.jdgui.settings.panels.premium.PremiumJTableModel;
import jd.plugins.Account;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PremiumTable
extends JDTable
implements MouseListener,
KeyListener {
    private static final long serialVersionUID = 9049514723238421532L;
    private static final String JDL_PREFIX = "jd.gui.swing.jdgui.settings.panels.premium.PremiumTable.";
    private Premium panel;

    public PremiumTable(Premium panel) {
        super(new PremiumJTableModel("premiumview"));
        this.panel = panel;
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    public ArrayList<Account> getSelectedAccounts() {
        int[] rows = this.getSelectedRows();
        ArrayList<Account> ret = new ArrayList<Account>();
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            Object element = this.getValueAt(row, 0);
            if (element != null && element instanceof Account) {
                ret.add((Account)element);
            }
            ++n2;
        }
        return ret;
    }

    public ArrayList<Account> getAllSelectedAccounts() {
        ArrayList<Account> accs = this.getSelectedAccounts();
        ArrayList<HostAccounts> ha = this.getSelectedHostAccounts();
        for (HostAccounts hostAccount : ha) {
            for (Account acc : AccountController.getInstance().getAllAccounts(hostAccount.getHost())) {
                if (accs.contains(acc)) continue;
                accs.add(acc);
            }
        }
        return accs;
    }

    public ArrayList<HostAccounts> getSelectedHostAccounts() {
        int[] rows = this.getSelectedRows();
        ArrayList<HostAccounts> ret = new ArrayList<HostAccounts>();
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            Object element = this.getModel().getValueAt(row, 0);
            if (element != null && element instanceof HostAccounts) {
                ret.add((HostAccounts)((Object)element));
            }
            ++n2;
        }
        return ret;
    }

    public void fireTableChanged() {
        new GuiRunnable<Object>(){

            @Override
            public Object runSave() {
                final Rectangle viewRect = PremiumTable.this.panel.getScrollPane().getViewport().getViewRect();
                int[] rows = PremiumTable.this.getSelectedRows();
                final ArrayList<Object> selected = new ArrayList<Object>();
                int[] nArray = rows;
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    int row = nArray[n2];
                    Object elem = PremiumTable.this.getValueAt(row, 0);
                    if (elem != null) {
                        selected.add(elem);
                    }
                    ++n2;
                }
                PremiumTable.this.getJDTableModel().refreshModel();
                PremiumTable.this.getJDTableModel().fireTableStructureChanged();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        for (Object obj : selected) {
                            int row = PremiumTable.this.getJDTableModel().getRowforObject(obj);
                            if (row == -1) continue;
                            PremiumTable.this.addRowSelectionInterval(row, row);
                        }
                        PremiumTable.this.scrollRectToVisible(viewRect);
                    }
                });
                return null;
            }
        }.start();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() != this) {
            return;
        }
        Point point = e.getPoint();
        int row = this.rowAtPoint(point);
        if (this.getValueAt(row, 0) == null) {
            this.clearSelection();
        }
        if (!this.isRowSelected(row) && e.getButton() == 3) {
            this.clearSelection();
            if (this.getValueAt(row, 0) != null) {
                this.addRowSelectionInterval(row, row);
            }
        }
        if (e.isPopupTrigger() || e.getButton() == 3) {
            final ArrayList<Account> accs = this.getAllSelectedAccounts();
            JPopupMenu popup = new JPopupMenu();
            JMenuItem tmp = new JMenuItem(JDL.LF((String)"jd.gui.swing.jdgui.settings.panels.premium.PremiumTable.refresh", (String)"Refresh Account(s) (%s)", (Object[])new Object[]{accs.size()}));
            popup.add(tmp);
            tmp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new Thread(new Runnable(){

                        public void run() {
                            for (Account acc : accs) {
                                AccountController.getInstance().updateAccountInfo(acc.getHoster(), acc, true);
                            }
                        }
                    }).start();
                }
            });
            popup.show((Component)((Object)this), point.x, point.y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            ActionController.getToolBarAction("action.premiumview.removeacc").actionPerformed(null);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

