/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.downloadview.Columns;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import jd.controlling.DownloadController;
import jd.controlling.DownloadWatchDog;
import jd.gui.swing.components.table.JDRowHighlighter;
import jd.gui.swing.components.table.JDTableColumn;
import jd.gui.swing.components.table.JDTableModel;
import jd.gui.swing.jdgui.components.JDProgressBarRender;
import jd.nutils.Formatter;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.utils.locale.JDL;
import org.jdesktop.swingx.renderer.JRendererLabel;

public class ProgressColumn
extends JDTableColumn {
    private static final long serialVersionUID = 2228210790952050305L;
    private DownloadLink dLink;
    private JDProgressBarRender progress;
    private final String strPluginDisabled;
    private final String strPluginError;
    private final String strUnknownFilesize;
    private final Color COL_PROGRESS_ERROR = new Color(0xCC3300);
    private final Color COL_PROGRESS_NORMAL;
    private StringBuilder sb = new StringBuilder();
    private Color COL_PROGRESS = null;
    private FilePackage fp;
    private JRendererLabel jlr;

    public ProgressColumn(String name, JDTableModel table) {
        super(name, table);
        this.progress = new JDProgressBarRender();
        this.progress.setStringPainted(true);
        this.progress.setOpaque(true);
        this.progress.setBorder(null);
        this.COL_PROGRESS_NORMAL = this.progress.getForeground();
        this.strPluginDisabled = JDL.L((String)"gui.downloadlink.plugindisabled", (String)"[Plugin disabled]");
        this.strPluginError = JDL.L((String)"gui.treetable.error.plugin", (String)"Plugin error");
        this.strUnknownFilesize = JDL.L((String)"jd.gui.swing.jdgui.views.downloadview.Columns.ProgressColumn.unknownFilesize", (String)"Unknown FileSize");
        this.jlr = new JRendererLabel();
        this.jlr.setBorder(null);
    }

    public boolean isEditable(Object obj) {
        return false;
    }

    public Component myTableCellEditorComponent(JDTableModel table, Object value, boolean isSelected, int row, int column) {
        return null;
    }

    public Component myTableCellRendererComponent(JDTableModel table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof FilePackage) {
            this.fp = (FilePackage)value;
            if (this.fp.isFinished()) {
                this.progress.setMaximum(100);
                this.progress.setValue(100);
            } else {
                this.progress.setMaximum(Math.max(1L, this.fp.getTotalEstimatedPackageSize()));
                this.progress.setValue(this.fp.getTotalKBLoaded());
            }
            this.clearSB();
            this.sb.append(Formatter.formatReadable((long)this.fp.getTotalKBLoaded())).append('/').append(Formatter.formatReadable((long)Math.max(0L, this.fp.getTotalEstimatedPackageSize())));
            this.progress.setString(this.sb.toString());
            this.COL_PROGRESS = this.COL_PROGRESS_NORMAL;
            return this.progress;
        }
        this.dLink = (DownloadLink)value;
        if (this.dLink.getPlugin() == null) {
            this.jlr.setText(this.strPluginError);
            return this.jlr;
        }
        if (!this.dLink.getPlugin().getWrapper().isEnabled() && !this.dLink.getLinkStatus().isPluginActive()) {
            this.jlr.setText(this.strPluginDisabled);
            return this.jlr;
        }
        if (this.dLink.getPluginProgress() != null) {
            this.progress.setString("");
            this.progress.setMaximum(this.dLink.getPluginProgress().getTotal());
            this.progress.setValue(this.dLink.getPluginProgress().getCurrent());
            this.COL_PROGRESS = this.COL_PROGRESS_NORMAL;
            return this.progress;
        }
        if (this.dLink.getLinkStatus().hasStatus(16) && DownloadWatchDog.getInstance().getRemainingIPBlockWaittime(this.dLink.getHost()) > 0L) {
            this.progress.setMaximum(this.dLink.getLinkStatus().getTotalWaitTime());
            this.COL_PROGRESS = this.COL_PROGRESS_ERROR;
            this.progress.setString(Formatter.formatSeconds((long)(this.dLink.getLinkStatus().getRemainingWaittime() / 1000L)));
            this.progress.setValue(this.dLink.getLinkStatus().getRemainingWaittime());
            return this.progress;
        }
        if (this.dLink.getLinkStatus().hasStatus(4096) && DownloadWatchDog.getInstance().getRemainingTempUnavailWaittime(this.dLink.getHost()) > 0L) {
            this.progress.setMaximum(this.dLink.getLinkStatus().getTotalWaitTime());
            this.COL_PROGRESS = this.COL_PROGRESS_ERROR;
            this.progress.setString(Formatter.formatSeconds((long)(this.dLink.getLinkStatus().getRemainingWaittime() / 1000L)));
            this.progress.setValue(this.dLink.getLinkStatus().getRemainingWaittime());
            return this.progress;
        }
        if (this.dLink.getLinkStatus().isFinished()) {
            this.progress.setMaximum(100);
            this.progress.setString(Formatter.formatReadable((long)Math.max(0L, this.dLink.getDownloadSize())));
            this.progress.setValue(100);
            this.COL_PROGRESS = this.COL_PROGRESS_NORMAL;
            return this.progress;
        }
        if (this.dLink.getDownloadCurrent() > 0L || this.dLink.getDownloadSize() > 0L) {
            this.clearSB();
            this.sb.append(Formatter.formatReadable((long)this.dLink.getDownloadCurrent())).append('/').append(Formatter.formatReadable((long)Math.max(0L, this.dLink.getDownloadSize())));
            this.progress.setMaximum(this.dLink.getDownloadSize());
            this.progress.setString(this.sb.toString());
            this.progress.setValue(this.dLink.getDownloadCurrent());
            this.COL_PROGRESS = this.COL_PROGRESS_NORMAL;
            return this.progress;
        }
        this.jlr.setText(this.strUnknownFilesize);
        return this.jlr;
    }

    public void handleSelected(Component c, JDTableModel table, Object value, boolean isSelected, int row, int column) {
        if (c instanceof JDProgressBarRender) {
            ((JDProgressBarRender)c).setForeground(this.COL_PROGRESS);
            if (isSelected) {
                ((JDProgressBarRender)c).setBackground(JDTableColumn.background);
                return;
            }
            ((JDProgressBarRender)c).setBackground(JDTableColumn.background);
            for (JDRowHighlighter high : table.getJDRowHighlighter()) {
                if (!high.doHighlight(value)) continue;
                ((JDProgressBarRender)c).setBackground(high.getColor());
                return;
            }
        } else {
            super.handleSelected(c, table, value, isSelected, row, column);
        }
    }

    public void setValue(Object value, Object object) {
    }

    public Object getCellEditorValue() {
        return null;
    }

    public boolean isSortable(Object obj) {
        return obj == null || obj instanceof ArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(Object obj, final boolean sortingToggle) {
        ArrayList packages = null;
        Object object = DownloadController.ControllerLock;
        synchronized (object) {
            ArrayList arrayList = DownloadController.getInstance().getPackages();
            synchronized (arrayList) {
                packages = DownloadController.getInstance().getPackages();
                if (obj == null && packages.size() > 1) {
                    Collections.sort(packages, new Comparator<FilePackage>(){

                        @Override
                        public int compare(FilePackage a, FilePackage b) {
                            FilePackage aa = a;
                            FilePackage bb = b;
                            if (sortingToggle) {
                                aa = b;
                                bb = a;
                            }
                            if (aa.getTotalKBLoaded() == bb.getTotalKBLoaded()) {
                                return 0;
                            }
                            return aa.getTotalKBLoaded() < bb.getTotalKBLoaded() ? -1 : 1;
                        }
                    });
                } else {
                    if (obj != null) {
                        packages = (ArrayList)obj;
                    }
                    for (FilePackage fp : packages) {
                        Collections.sort(fp.getDownloadLinkList(), new Comparator<DownloadLink>(){

                            @Override
                            public int compare(DownloadLink a, DownloadLink b) {
                                DownloadLink aa = b;
                                DownloadLink bb = a;
                                if (sortingToggle) {
                                    aa = a;
                                    bb = b;
                                }
                                if (aa.getDownloadCurrent() == bb.getDownloadCurrent()) {
                                    return 0;
                                }
                                return aa.getDownloadCurrent() < bb.getDownloadCurrent() ? -1 : 1;
                            }
                        });
                    }
                }
            }
        }
        DownloadController.getInstance().fireStructureUpdate();
    }

    public boolean isEnabled(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DownloadLink) {
            return ((DownloadLink)obj).isEnabled();
        }
        if (obj instanceof FilePackage) {
            return ((FilePackage)obj).isEnabled();
        }
        return true;
    }

    private void clearSB() {
        this.sb.delete(0, this.sb.capacity());
    }
}

