/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.downloadview.Columns;

import java.awt.Component;
import javax.swing.ImageIcon;
import jd.controlling.DownloadWatchDog;
import jd.gui.swing.components.table.JDTableColumn;
import jd.gui.swing.components.table.JDTableModel;
import jd.gui.swing.jdgui.components.StatusLabel;
import jd.nutils.Formatter;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.utils.JDTheme;
import jd.utils.locale.JDL;

public class StatusColumn
extends JDTableColumn {
    private static final String JDL_PREFIX = "jd.gui.swing.jdgui.views.downloadview.TableRenderer.";
    private static final long serialVersionUID = 2228210790952050305L;
    private DownloadLink dLink;
    private StatusLabel statuspanel;
    private int counter = 0;
    private ImageIcon imgFinished;
    private ImageIcon imgFailed;
    private ImageIcon imgExtract;
    private ImageIcon imgPriorityS;
    private ImageIcon imgPriority2;
    private ImageIcon imgPriority1;
    private ImageIcon imgStopMark;
    private ImageIcon imgPriority3;
    private String strStopMark;
    private String strFinished;
    private String strFailed;
    private String strPriorityS;
    private String strPriority1;
    private String strPriority2;
    private String strPriority3;
    private String strExtract;
    private FilePackage fp;
    private StringBuilder sb = new StringBuilder();
    private String strDownloadLinkActive;
    private String strETA;

    public StatusColumn(String name, JDTableModel table) {
        super(name, table);
        this.statuspanel = new StatusLabel();
        this.statuspanel.setBorder(null);
        this.imgFinished = JDTheme.II((String)"gui.images.ok", (int)16, (int)16);
        this.imgFailed = JDTheme.II((String)"gui.images.bad", (int)16, (int)16);
        this.imgExtract = JDTheme.II((String)"gui.images.update_manager", (int)16, (int)16);
        this.imgStopMark = JDTheme.II((String)"gui.images.stopmark", (int)16, (int)16);
        this.imgPriorityS = JDTheme.II((String)"gui.images.priority-1", (int)16, (int)16);
        this.imgPriority1 = JDTheme.II((String)"gui.images.priority1", (int)16, (int)16);
        this.imgPriority2 = JDTheme.II((String)"gui.images.priority2", (int)16, (int)16);
        this.imgPriority3 = JDTheme.II((String)"gui.images.priority3", (int)16, (int)16);
        this.strStopMark = JDL.L((String)"jd.gui.swing.jdgui.views.downloadview.TableRenderer.stopmark", (String)"Stopmark is set");
        this.strFinished = JDL.L((String)"jd.gui.swing.jdgui.views.downloadview.TableRenderer.finished", (String)"Download finished");
        this.strFailed = JDL.L((String)"jd.gui.swing.jdgui.views.downloadview.TableRenderer.failed", (String)"Download failed");
        this.strExtract = JDL.L((String)"jd.gui.swing.jdgui.views.downloadview.TableRenderer.extract", (String)"Extracting");
        this.strPriorityS = JDL.L((String)"gui.treetable.tooltip.priority-1", (String)"Low Priority");
        this.strPriority1 = JDL.L((String)"gui.treetable.tooltip.priority1", (String)"High Priority");
        this.strPriority2 = JDL.L((String)"gui.treetable.tooltip.priority2", (String)"Higher Priority");
        this.strPriority3 = JDL.L((String)"gui.treetable.tooltip.priority3", (String)"Highest Priority");
        this.strDownloadLinkActive = JDL.L((String)"gui.treetable.packagestatus.links_active", (String)"aktiv");
        this.strETA = JDL.L((String)"gui.eta", (String)"ETA");
    }

    public boolean isEditable(Object obj) {
        return false;
    }

    public Component myTableCellEditorComponent(JDTableModel table, Object value, boolean isSelected, int row, int column) {
        return null;
    }

    public Component myTableCellRendererComponent(JDTableModel table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof FilePackage) {
            this.fp = (FilePackage)value;
            if (this.fp.isFinished()) {
                this.statuspanel.setText("");
            } else if (this.fp.getTotalDownloadSpeed() > 0L) {
                this.clearSB();
                this.sb.append('[').append(this.fp.getLinksInProgress()).append('/').append(this.fp.size()).append("] ");
                this.sb.append(this.strETA).append(' ').append(Formatter.formatSeconds((long)this.fp.getETA())).append(" @ ").append(Formatter.formatReadable((long)this.fp.getTotalDownloadSpeed())).append("/s");
                this.statuspanel.setText(this.sb.toString());
            } else if (this.fp.getLinksInProgress() > 0) {
                this.clearSB();
                this.sb.append(this.fp.getLinksInProgress()).append('/').append(this.fp.size()).append(' ').append(this.strDownloadLinkActive);
                this.statuspanel.setText(this.sb.toString());
            } else {
                this.statuspanel.setText("");
            }
            this.counter = 0;
            if (this.fp.isFinished()) {
                this.statuspanel.setIcon(this.counter, this.imgFinished, this.strFinished);
                ++this.counter;
            } else if (DownloadWatchDog.getInstance().isStopMark(value)) {
                this.statuspanel.setIcon(this.counter, this.imgStopMark, this.strStopMark);
                ++this.counter;
            }
            this.statuspanel.clearIcons(this.counter);
        } else {
            this.dLink = (DownloadLink)value;
            this.statuspanel.setText(this.dLink.getLinkStatus().getStatusString());
            this.counter = 0;
            if (DownloadWatchDog.getInstance().isStopMark(value)) {
                this.statuspanel.setIcon(this.counter, this.imgStopMark, this.strStopMark);
                ++this.counter;
            }
            if (this.dLink.getLinkStatus().getStatusIcon() != null) {
                this.statuspanel.setIcon(this.counter, this.dLink.getLinkStatus().getStatusIcon(), this.dLink.getLinkStatus().getStatusText());
                ++this.counter;
            } else if (this.dLink.getLinkStatus().isFinished()) {
                this.statuspanel.setIcon(this.counter, this.imgFinished, this.strFinished);
                ++this.counter;
            } else if (this.dLink.getLinkStatus().isFailed() || this.dLink.isAvailabilityStatusChecked() && !this.dLink.isAvailable()) {
                this.statuspanel.setIcon(this.counter, this.imgFailed, this.strFailed);
                ++this.counter;
            }
            if (this.counter <= 5 && this.dLink.getPluginProgress() != null && this.dLink.getPluginProgress().getPercent() > 0.0 && this.dLink.getPluginProgress().getPercent() < 100.0) {
                this.statuspanel.setIcon(this.counter, this.imgExtract, this.strExtract);
                ++this.counter;
            }
            if (this.counter <= 5) {
                switch (this.dLink.getPriority()) {
                    default: {
                        break;
                    }
                    case -1: {
                        this.statuspanel.setIcon(this.counter, this.imgPriorityS, this.strPriorityS);
                        ++this.counter;
                        break;
                    }
                    case 1: {
                        this.statuspanel.setIcon(this.counter, this.imgPriority1, this.strPriority1);
                        ++this.counter;
                        break;
                    }
                    case 2: {
                        this.statuspanel.setIcon(this.counter, this.imgPriority2, this.strPriority2);
                        ++this.counter;
                        break;
                    }
                    case 3: {
                        this.statuspanel.setIcon(this.counter, this.imgPriority3, this.strPriority3);
                        ++this.counter;
                    }
                }
            }
            if (this.counter <= 5 && this.dLink.hasCustomIcon()) {
                this.statuspanel.setIcon(this.counter, this.dLink.getCustomIcon(), this.dLink.getCustomIconText());
                ++this.counter;
            }
            this.statuspanel.clearIcons(this.counter);
        }
        return this.statuspanel;
    }

    public void setValue(Object value, Object object) {
    }

    public Object getCellEditorValue() {
        return null;
    }

    public boolean isSortable(Object obj) {
        return false;
    }

    public void sort(Object obj, boolean sortingToggle) {
    }

    private void clearSB() {
        this.sb.delete(0, this.sb.capacity());
    }

    public boolean isEnabled(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DownloadLink) {
            return ((DownloadLink)obj).isEnabled();
        }
        if (obj instanceof FilePackage) {
            return ((FilePackage)obj).isEnabled();
        }
        return true;
    }
}

