/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.downloadview;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.DropMode;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jd.config.Property;
import jd.controlling.DownloadController;
import jd.controlling.DownloadWatchDog;
import jd.event.ControlEvent;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.components.table.JDRowHighlighter;
import jd.gui.swing.components.table.JDTable;
import jd.gui.swing.jdgui.menu.MenuAction;
import jd.gui.swing.jdgui.views.downloadview.DownloadJTableModel;
import jd.gui.swing.jdgui.views.downloadview.DownloadLinksPanel;
import jd.gui.swing.jdgui.views.downloadview.PropMenuItem;
import jd.gui.swing.jdgui.views.downloadview.TableAction;
import jd.gui.swing.jdgui.views.downloadview.TableTransferHandler;
import jd.gui.swing.menu.Menu;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadTable
extends JDTable
implements MouseListener,
KeyListener {
    public static final String PROPERTY_EXPANDED = "expanded";
    public static final byte EXPCOL_TOP = 0;
    public static final byte EXPCOL_CUR = 1;
    public static final byte EXPCOL_BOT = 2;
    private static final long serialVersionUID = 1L;
    private DownloadLinksPanel panel;
    public static String[] prioDescs;
    private PropMenuItem propItem;

    public DownloadTable(DownloadLinksPanel panel) {
        super(new DownloadJTableModel("gui2"));
        this.panel = panel;
        this.addMouseListener(this);
        this.addKeyListener(this);
        if (JDUtilities.getJavaVersion() >= 1.6) {
            this.setDropMode(DropMode.USE_SELECTION);
        }
        this.setDragEnabled(true);
        this.setTransferHandler(new TableTransferHandler(this));
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.addDisabledHighlighter();
        this.addPostErrorHighlighter();
        this.addWaitHighlighter();
        this.addPackageHighlighter();
        prioDescs = new String[]{JDL.L((String)"gui.treetable.tooltip.priority-1", (String)"Low Priority"), JDL.L((String)"gui.treetable.tooltip.priority0", (String)"No Priority"), JDL.L((String)"gui.treetable.tooltip.priority1", (String)"High Priority"), JDL.L((String)"gui.treetable.tooltip.priority2", (String)"Higher Priority"), JDL.L((String)"gui.treetable.tooltip.priority3", (String)"Highest Priority")};
        this.propItem = new PropMenuItem(panel);
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        boolean ret = super.processKeyBinding(ks, e, condition, pressed);
        if (this.getRootPane().getInputMap(2).get(ks) != null) {
            return false;
        }
        if (this.getRootPane().getInputMap(1).get(ks) != null) {
            return false;
        }
        return ret;
    }

    private void addPackageHighlighter() {
        this.addJDRowHighlighter(new JDRowHighlighter(UIManager.getColor("TableHeader.background")){

            public boolean doHighlight(Object o) {
                return o != null && o instanceof FilePackage;
            }
        });
    }

    private void addWaitHighlighter() {
        this.addJDRowHighlighter(new JDRowHighlighter(JDTheme.C((String)"gui.color.downloadlist.error_post", (String)"ff9936", (int)100)){

            public boolean doHighlight(Object o) {
                if (o == null || !(o instanceof DownloadLink)) {
                    return false;
                }
                DownloadLink dl = (DownloadLink)o;
                if (dl.getLinkStatus().hasStatus(2) || !dl.isEnabled() || dl.getLinkStatus().isPluginActive()) {
                    return false;
                }
                return DownloadWatchDog.getInstance().getRemainingIPBlockWaittime(dl.getHost()) > 0L || DownloadWatchDog.getInstance().getRemainingTempUnavailWaittime(dl.getHost()) > 0L;
            }
        });
    }

    private void addPostErrorHighlighter() {
        this.addJDRowHighlighter(new JDRowHighlighter(JDTheme.C((String)"gui.color.downloadlist.error_post", (String)"ff9936", (int)120)){

            public boolean doHighlight(Object o) {
                return o != null && o instanceof DownloadLink && ((DownloadLink)o).getLinkStatus().hasStatus(0x1000000);
            }
        });
    }

    private void addDisabledHighlighter() {
        this.addJDRowHighlighter(new JDRowHighlighter(JDTheme.C((String)"gui.color.downloadlist.row_link_disabled", (String)"adadad", (int)100)){

            public boolean doHighlight(Object o) {
                return o != null && o instanceof DownloadLink && !((DownloadLink)o).isEnabled();
            }
        });
    }

    public void fireTableChanged(final int id, final ArrayList<Object> objs) {
        new GuiRunnable<Object>(){

            @Override
            public Object runSave() {
                final Rectangle viewRect = DownloadTable.this.panel.getScrollPane().getViewport().getViewRect();
                int first = DownloadTable.this.rowAtPoint(new Point(0, viewRect.y));
                int last = DownloadTable.this.rowAtPoint(new Point(0, viewRect.y + viewRect.height - 1));
                switch (id) {
                    case 2: {
                        for (Object obj : objs) {
                            int row = DownloadTable.this.getJDTableModel().getRowforObject(obj);
                            if (row == -1) continue;
                            if (last == -1) {
                                DownloadTable.this.getJDTableModel().fireTableRowsUpdated(row, row);
                                continue;
                            }
                            if (row < first || row > last) continue;
                            DownloadTable.this.getJDTableModel().fireTableRowsUpdated(row, row);
                        }
                        return null;
                    }
                    case 1: {
                        DownloadTable.this.getJDTableModel().fireTableDataChanged();
                        return null;
                    }
                    case 0: 
                    case 10: {
                        int[] rows = DownloadTable.this.getSelectedRows();
                        final ArrayList<Object> selected = new ArrayList<Object>();
                        int[] nArray = rows;
                        int n = rows.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int row = nArray[n2];
                            Object elem = DownloadTable.this.getValueAt(row, 0);
                            if (elem != null) {
                                selected.add(elem);
                            }
                            ++n2;
                        }
                        DownloadTable.this.getJDTableModel().refreshModel();
                        DownloadTable.this.getJDTableModel().fireTableStructureChanged();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                for (Object obj : selected) {
                                    int row = DownloadTable.this.getJDTableModel().getRowforObject(obj);
                                    if (row == -1) continue;
                                    DownloadTable.this.addRowSelectionInterval(row, row);
                                }
                                DownloadTable.this.scrollRectToVisible(viewRect);
                            }
                        });
                        return null;
                    }
                }
                return null;
            }
        }.start();
    }

    public ArrayList<DownloadLink> getSelectedDownloadLinks() {
        int[] rows = this.getSelectedRows();
        ArrayList<DownloadLink> ret = new ArrayList<DownloadLink>();
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            Object element = this.getModel().getValueAt(row, 0);
            if (element != null && element instanceof DownloadLink) {
                ret.add((DownloadLink)element);
            }
            ++n2;
        }
        return ret;
    }

    public ArrayList<DownloadLink> getAllSelectedDownloadLinks() {
        ArrayList<DownloadLink> links = this.getSelectedDownloadLinks();
        ArrayList<FilePackage> fps = this.getSelectedFilePackages();
        for (FilePackage filePackage : fps) {
            for (DownloadLink dl : filePackage.getDownloadLinkList()) {
                if (links.contains(dl)) continue;
                links.add(dl);
            }
        }
        return links;
    }

    public ArrayList<FilePackage> getSelectedFilePackages() {
        int[] rows = this.getSelectedRows();
        ArrayList<FilePackage> ret = new ArrayList<FilePackage>();
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            Object element = this.getModel().getValueAt(row, 0);
            if (element != null && element instanceof FilePackage) {
                ret.add((FilePackage)element);
            }
            ++n2;
        }
        return ret;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            ArrayList<DownloadLink> alllinks = this.getAllSelectedDownloadLinks();
            TableAction test = new TableAction(this.panel, JDTheme.II((String)"gui.images.delete", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.delete", (String)"entfernen")) + " (" + alllinks.size() + ")", 999, new Property("links", alllinks));
            test.actionPerformed(new ActionEvent(test, 0, ""));
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() != this) {
            return;
        }
        Point point = e.getPoint();
        int row = this.rowAtPoint(point);
        int col = this.realColumnAtPoint(point);
        if (this.getValueAt(row, 0) == null) {
            this.clearSelection();
        }
        if (!this.isRowSelected(row) && e.getButton() == 3) {
            this.clearSelection();
            if (this.getValueAt(row, 0) != null) {
                this.addRowSelectionInterval(row, row);
            }
        }
        if (e.isPopupTrigger() || e.getButton() == 3) {
            JMenuItem tmp;
            if (this.getValueAt(row, 0) == null) {
                return;
            }
            ArrayList<DownloadLink> alllinks = this.getAllSelectedDownloadLinks();
            ArrayList<DownloadLink> resumlinks = new ArrayList<DownloadLink>();
            ArrayList<DownloadLink> allnoncon = new ArrayList<DownloadLink>();
            ArrayList<DownloadLink> notrunning = new ArrayList<DownloadLink>();
            int links_enabled = 0;
            for (DownloadLink next : alllinks) {
                if (!next.getLinkStatus().isPluginActive()) {
                    notrunning.add(next);
                }
                if (next.getLinkType() == 0) {
                    allnoncon.add(next);
                }
                if (next.isEnabled()) {
                    ++links_enabled;
                }
                if (next.getLinkStatus().isPluginActive() || !next.getLinkStatus().isFailed()) continue;
                resumlinks.add(next);
            }
            int links_disabled = alllinks.size() - links_enabled;
            ArrayList<FilePackage> sfp = this.getSelectedFilePackages();
            Object obj = this.getModel().getValueAt(row, 0);
            JPopupMenu popup = new JPopupMenu();
            if (obj instanceof FilePackage || obj instanceof DownloadLink) {
                tmp = new JMenuItem(new TableAction(this.panel, JDTheme.II((String)"gui.images.stopsign", (int)16, (int)16), JDL.L((String)"gui.table.contextmenu.stopmark", (String)"Stop sign"), 600, new Property("item", obj)));
                popup.add(tmp);
                if (DownloadWatchDog.getInstance().isStopMark(obj)) {
                    tmp.setIcon(tmp.getDisabledIcon());
                }
                popup.add(this.builddeletemenu(alllinks));
                popup.addSeparator();
            }
            popup.add(this.createExtrasMenu(obj));
            if (obj instanceof FilePackage) {
                popup.add(new JMenuItem(new TableAction(this.panel, JDTheme.II((String)"gui.images.package_opened", (int)16, (int)16), JDL.L((String)"gui.table.contextmenu.downloadDir", (String)"Zielordner \u00f6ffnen"), 1, new Property("folder", (Object)new File(((FilePackage)obj).getDownloadDirectory())))));
                this.addSortItem(popup, col, sfp, String.valueOf(JDL.L((String)"gui.table.contextmenu.packagesort", (String)"Paket sortieren")) + " (" + sfp.size() + "), (" + this.getJDTableModel().getColumnName(col) + ")");
                popup.add(new JMenuItem(new TableAction(this.panel, JDTheme.II((String)"gui.images.edit", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.editpackagename", (String)"Paketname \u00e4ndern")) + " (" + sfp.size() + ")", 11, new Property("packages", sfp))));
                tmp = new JMenuItem(new TableAction(this.panel, JDTheme.II((String)"gui.images.save", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.editdownloadDir", (String)"Zielordner \u00e4ndern")) + " (" + sfp.size() + ")", 101, new Property("packages", sfp)));
                popup.add(tmp);
                popup.addSeparator();
            }
            if (obj instanceof DownloadLink) {
                popup.add(new JMenuItem(new TableAction(this.panel, JDTheme.II((String)"gui.images.package_opened", (int)16, (int)16), JDL.L((String)"gui.table.contextmenu.downloadDir", (String)"Zielordner \u00f6ffnen"), 1, new Property("folder", (Object)new File(((DownloadLink)obj).getFileOutput()).getParentFile()))));
                tmp = new JMenuItem(new TableAction(this.panel, JDTheme.II((String)"gui.images.browse", (int)16, (int)16), JDL.L((String)"gui.table.contextmenu.browseLink", (String)"im Browser \u00f6ffnen"), 7, new Property("downloadlink", obj)));
                popup.add(tmp);
                if (((DownloadLink)obj).getLinkType() != 0) {
                    tmp.setEnabled(false);
                }
            }
            if (obj instanceof FilePackage || obj instanceof DownloadLink) {
                popup.add(new JMenuItem(new TableAction(this.panel, JDTheme.II((String)"gui.images.dlc", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.dlc", (String)"DLC erstellen")) + " (" + alllinks.size() + ")", 20, new Property("links", alllinks))));
                popup.add(this.buildpriomenu(alllinks));
                tmp = new JMenuItem(new TableAction(this.panel, JDTheme.II((String)"gui.icons.copy", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.copyPassword", (String)"Copy Password")) + " (" + alllinks.size() + ")", 3, new Property("links", alllinks)));
                popup.add(tmp);
                if (DownloadLinksPanel.getPasswordSelectedLinks(alllinks).length() == 0) {
                    tmp.setEnabled(false);
                }
                tmp = new JMenuItem(new TableAction(this.panel, JDTheme.II((String)"gui.icons.cut", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.copyLink", (String)"Copy URL")) + " (" + allnoncon.size() + ")", 301, new Property("links", allnoncon)));
                popup.add(tmp);
                if (allnoncon.size() == 0) {
                    tmp.setEnabled(false);
                }
                popup.add(new JMenuItem(new TableAction(this.panel, JDTheme.II((String)"gui.images.config.network_local", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.check", (String)"Check OnlineStatus")) + " (" + alllinks.size() + ")", 500, new Property("links", alllinks))));
                popup.add(new JMenuItem(new TableAction(this.panel, JDTheme.II((String)"gui.images.newpackage", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.newpackage", (String)"In neues Paket verschieben")) + " (" + alllinks.size() + ")", 100, new Property("links", alllinks))));
                popup.add(new JMenuItem(new TableAction(this.panel, JDTheme.II((String)"gui.images.password", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.setdlpw", (String)"Set download password")) + " (" + alllinks.size() + ")", 201, new Property("links", alllinks))));
                popup.addSeparator();
                HashMap<String, Serializable> prop = new HashMap<String, Serializable>();
                prop.put("links", alllinks);
                prop.put("boolean", Boolean.valueOf(true));
                tmp = new JMenuItem(new TableAction(this.panel, JDTheme.II((String)"gui.images.ok", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.enable", (String)"aktivieren")) + " (" + links_disabled + ")", 400, new Property("infos", prop)));
                popup.add(tmp);
                if (links_disabled == 0) {
                    tmp.setEnabled(false);
                }
                prop = new HashMap();
                prop.put("links", alllinks);
                prop.put("boolean", Boolean.valueOf(false));
                tmp = new JMenuItem(new TableAction(this.panel, JDTheme.II((String)"gui.images.bad", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.disable", (String)"deaktivieren")) + " (" + links_enabled + ")", 400, new Property("infos", prop)));
                popup.add(tmp);
                if (links_enabled == 0) {
                    tmp.setEnabled(false);
                }
                tmp = new JMenuItem(new TableAction(this.panel, JDTheme.II((String)"gui.images.resume", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.resume", (String)"fortsetzen")) + " (" + resumlinks.size() + ")", 22, new Property("links", resumlinks)));
                popup.add(tmp);
                if (resumlinks.size() == 0) {
                    tmp.setEnabled(false);
                }
                if (notrunning.size() > 0 && DownloadWatchDog.getInstance().getDownloadStatus() == DownloadWatchDog.STATE.RUNNING) {
                    popup.add(new JMenuItem(new TableAction(this.panel, JDTheme.II((String)"gui.images.next", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.tryforce", (String)"Force download")) + " (" + notrunning.size() + ")", 401, new Property("links", notrunning))));
                }
                popup.add(new JMenuItem(new TableAction(this.panel, JDTheme.II((String)"gui.images.undo", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.reset", (String)"zur\u00fccksetzen")) + " (" + alllinks.size() + ")", 4, new Property("links", alllinks))));
                popup.addSeparator();
                this.propItem.setObject(obj);
                popup.add(this.propItem);
            }
            if (popup.getComponentCount() != 0) {
                popup.show((Component)((Object)this), point.x, point.y);
            }
        }
    }

    private JMenu builddeletemenu(ArrayList<DownloadLink> alllinks) {
        int counter = 0;
        for (DownloadLink link : alllinks) {
            if (!link.existsFile() || !link.getLinkStatus().hasStatus(8192)) continue;
            ++counter;
        }
        JMenu pop = new JMenu(JDL.L((String)"gui.table.contextmenu.delete", (String)"entfernen"));
        pop.setIcon(JDTheme.II((String)"gui.images.delete", (int)16, (int)16));
        pop.add(new JMenuItem(new TableAction(this.panel, JDTheme.II((String)"gui.images.delete", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.deletelist", (String)"from list")) + " (" + alllinks.size() + ")", 999, new Property("links", alllinks))));
        pop.add(new JMenuItem(new TableAction(this.panel, JDTheme.II((String)"gui.images.delete", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.deletelistdisk", (String)"from list and disk")) + " (" + alllinks.size() + "/" + counter + ")", 9991, new Property("links", alllinks))));
        return pop;
    }

    private JMenu buildpriomenu(ArrayList<DownloadLink> links) {
        JMenu prioPopup = new JMenu(String.valueOf(JDL.L((String)"gui.table.contextmenu.priority", (String)"Priority")) + " (" + links.size() + ")");
        Integer prio = null;
        if (links.size() == 1) {
            prio = links.get(0).getPriority();
        }
        prioPopup.setIcon(JDTheme.II((String)"gui.images.priority0", (int)16, (int)16));
        HashMap<String, Serializable> prop = null;
        int i = 3;
        while (i >= -1) {
            prop = new HashMap<String, Serializable>();
            prop.put("links", links);
            prop.put("prio", Integer.valueOf(i));
            JMenuItem tmp = new JMenuItem(new TableAction(this.panel, JDTheme.II((String)("gui.images.priority" + i), (int)16, (int)16), prioDescs[i + 1], 200, new Property("infos", prop)));
            prioPopup.add(tmp);
            if (prio != null && i == prio) {
                tmp.setEnabled(false);
                tmp.setIcon(JDTheme.II((String)("gui.images.priority" + i), (int)16, (int)16));
            } else {
                tmp.setEnabled(true);
            }
            --i;
        }
        return prioPopup;
    }

    private JMenu createExtrasMenu(Object obj) {
        if (!(obj instanceof FilePackage) && !(obj instanceof DownloadLink)) {
            return null;
        }
        JMenu pluginPopup = new JMenu(JDL.L((String)"gui.table.contextmenu.extrasSubmenu", (String)"Extras"));
        pluginPopup.setIcon(JDTheme.II((String)"gui.images.config.packagemanager", (int)16, (int)16));
        ArrayList entries = new ArrayList();
        JDUtilities.getController().fireControlEventDirect(new ControlEvent(obj, 22, entries));
        if (entries != null && entries.size() > 0) {
            for (MenuAction next : entries) {
                JMenuItem mi = Menu.getJMenuItem(next);
                if (mi == null) {
                    pluginPopup.addSeparator();
                    continue;
                }
                pluginPopup.add(mi);
            }
        } else {
            pluginPopup.setEnabled(false);
        }
        return pluginPopup;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Object element;
        Point p;
        int column;
        Object obj;
        if (e.getSource() != this) {
            return;
        }
        int row = this.rowAtPoint(e.getPoint());
        if (row == -1) {
            return;
        }
        if (row >= 0 && !this.isRowSelected(row) && (obj = this.getValueAt(row, 0)) != null && obj instanceof DownloadLink) {
            int row2 = this.getJDTableModel().getRowforObject(((DownloadLink)obj).getFilePackage());
            if (row >= 0 && this.isRowSelected(row2)) {
                this.removeRowSelectionInterval(row2, row2);
            }
        }
        if ((column = this.realColumnAtPoint(e.getPoint())) == 0 && e.getButton() == 1 && e.getClickCount() == 1 && (p = this.getPointinCell(e.getPoint())) != null && p.getX() < 30.0 && (element = this.getValueAt(row, 0)) != null && element instanceof FilePackage) {
            if (e.isControlDown() && !e.isShiftDown()) {
                this.toggleFilePackageExpand((FilePackage)element, (byte)2);
            } else if (e.isControlDown() && e.isShiftDown()) {
                this.toggleFilePackageExpand((FilePackage)element, (byte)0);
            } else {
                this.toggleFilePackageExpand((FilePackage)element, (byte)1);
            }
            return;
        }
        if (e.getButton() == 1) {
            if (column == 0 && (p = this.getPointinCell(e.getPoint())) != null && p.getX() < 30.0) {
                return;
            }
            if (e.getClickCount() == 1 && this.panel.isFilePackageInfoVisible(null) || e.getClickCount() == 2) {
                Object element2 = this.getValueAt(row, 0);
                if (this.panel.isFilePackageInfoVisible(element2) && e.getClickCount() == 2) {
                    this.panel.hideFilePackageInfo();
                } else if (element2 instanceof FilePackage) {
                    this.panel.showFilePackageInfo((FilePackage)element2);
                } else {
                    this.panel.showDownloadLinkInfo((DownloadLink)element2);
                }
            }
        }
    }

    public void toggleFilePackageExpand(FilePackage fp, byte mode) {
        boolean cur = fp.getBooleanProperty(PROPERTY_EXPANDED, false) == false;
        switch (mode) {
            case 1: {
                fp.setProperty(PROPERTY_EXPANDED, (Object)cur);
                break;
            }
            case 0: {
                ArrayList packages = new ArrayList(DownloadController.getInstance().getPackages());
                int indexfp = DownloadController.getInstance().indexOf(fp);
                int index = 0;
                while (index <= indexfp) {
                    FilePackage fp2 = (FilePackage)packages.get(index);
                    fp2.setProperty(PROPERTY_EXPANDED, (Object)cur);
                    ++index;
                }
                break;
            }
            case 2: {
                int indexfp;
                ArrayList packages = new ArrayList(DownloadController.getInstance().getPackages());
                int index = indexfp = DownloadController.getInstance().indexOf(fp);
                while (index < packages.size()) {
                    FilePackage fp2 = (FilePackage)packages.get(index);
                    fp2.setProperty(PROPERTY_EXPANDED, (Object)cur);
                    ++index;
                }
                break;
            }
            default: {
                return;
            }
        }
        this.panel.updateTableTask(10, null);
    }
}

