/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.downloadview;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jd.controlling.DownloadController;
import jd.gui.swing.components.ComboBrowseFile;
import jd.gui.swing.components.JDCollapser;
import jd.gui.swing.components.JDTextField;
import jd.gui.swing.components.MultiProgressBar;
import jd.gui.swing.jdgui.views.DownloadView;
import jd.nutils.Formatter;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class FilePackageInfo
extends JDCollapser
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 5410296068527460629L;
    private ComboBrowseFile brwSaveTo;
    private JDTextField txtComment;
    private JDTextField txtCommentDl;
    private JDTextField txtName;
    private JDTextField txtNameDl;
    private JDTextField txtPasswordDl;
    private JDTextField txtPassword;
    private JDTextField txtStatusDl;
    private JDTextField txtSize;
    private JDTextField txtSizeDl;
    private JDTextField txtURL;
    private JDTextField txtPathLabel;
    private JCheckBox chbExtract;
    private JTabbedPane tabbedPane;
    private FilePackage fp = null;
    private boolean hidden = false;
    private JPanel panel;
    private MultiProgressBar progressBarFilePackage;
    private JLabel hosterlabel;
    private DownloadLink downloadLink;
    private transient Thread updater;
    private MultiProgressBar progressBarDownloadLink;
    private JLabel typeicon;
    private JLabel eta;
    private JLabel speed;
    private JDTextField txtPassword2;

    public FilePackageInfo() {
        this.buildGui();
        this.fp = null;
        this.menutitle.setText(JDL.L((String)"gui.linkgrabber.packagetab.title", (String)"FilePackage"));
    }

    public void setPackage(FilePackage fp) {
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.setEnabledAt(1, false);
        if (this.fp != null && this.fp == fp) {
            this.update();
            return;
        }
        this.fp = fp;
        if (this.fp != null) {
            this.update();
        }
    }

    public void update() {
        if (this.fp == null) {
            return;
        }
        this.txtSize.setText(Formatter.formatReadable((long)this.fp.getTotalEstimatedPackageSize()));
        this.txtName.setText(this.fp.getName());
        this.txtComment.setText(this.fp.getComment());
        this.txtPassword.setText(this.fp.getPassword());
        this.txtPassword2.setText(this.fp.getPasswordAuto().toString());
        this.brwSaveTo.setText(this.fp.getDownloadDirectory());
        this.chbExtract.setSelected(this.fp.isExtractAfterDownload());
        this.revalidate();
    }

    public FilePackage getPackage() {
        return this.fp;
    }

    private void buildGui() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add((Component)this.createFilePackageInfo(), JDL.L((String)"gui.fileinfopanel.packagetab", (String)"Package"));
        this.tabbedPane.add((Component)this.createLinkInfo(), JDL.L((String)"gui.fileinfopanel.link", (String)"Downloadlink"));
        this.content.setLayout((LayoutManager)new MigLayout("", "[grow]", "[]"));
        this.content.add((Component)this.tabbedPane, "grow");
    }

    private JPanel createFilePackageInfo() {
        this.txtName = new JDTextField(true);
        this.txtName.addActionListener(this);
        this.txtName.addFocusListener(this);
        this.brwSaveTo = new ComboBrowseFile("DownloadSaveTo");
        this.brwSaveTo.setEditable(true);
        this.brwSaveTo.setFileSelectionMode(1);
        this.brwSaveTo.setText(JDUtilities.getDefaultDownloadDirectory());
        this.brwSaveTo.addActionListener(this);
        this.brwSaveTo.addFocusListener(this);
        this.txtPassword = new JDTextField(true);
        this.txtPassword.addActionListener(this);
        this.txtPassword.addFocusListener(this);
        this.txtPassword2 = new JDTextField(true);
        this.txtPassword2.setEditable(false);
        this.txtComment = new JDTextField(true);
        this.txtComment.addActionListener(this);
        this.txtComment.addFocusListener(this);
        this.chbExtract = new JCheckBox(JDL.L((String)"gui.fileinfopanel.packagetab.chb.extractAfterdownload", (String)"Extract"));
        this.chbExtract.setSelected(true);
        this.chbExtract.setHorizontalTextPosition(2);
        this.chbExtract.addActionListener(this);
        this.chbExtract.addFocusListener(this);
        this.progressBarFilePackage = new MultiProgressBar();
        this.panel = new JPanel();
        this.panel.setLayout((LayoutManager)new MigLayout("ins 10, wrap 3", "[]10[grow,fill][]", "[]5[]5[]5[]"));
        this.panel.add((Component)this.progressBarFilePackage, "spanx,growx,pushx,split 2,height 18!");
        this.txtSize = new JDTextField(true);
        this.panel.add((Component)this.txtSize, "alignx right");
        this.txtSize.setEditable(false);
        this.txtSize.setBorder(null);
        this.txtSize.setOpaque(false);
        this.txtSize.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        this.panel.add(new JLabel(JDL.L((String)"gui.fileinfopanel.packagetab.lbl.name", (String)"Paketname")));
        this.panel.add((Component)this.txtName, "growx, span 2");
        this.panel.add(new JLabel(JDL.L((String)"gui.fileinfopanel.packagetab.lbl.saveto", (String)"Speichern unter")));
        this.panel.add((Component)this.brwSaveTo.getInput(), "gapright 10, shrinkx");
        this.panel.add((Component)this.brwSaveTo.getButton(), "pushx, growx");
        this.panel.add(new JLabel(JDL.L((String)"gui.fileinfopanel.packagetab.lbl.password", (String)"Archivpasswort")));
        this.panel.add((Component)this.txtPassword, "gapright 10, growx");
        this.panel.add((Component)this.chbExtract, "alignx right");
        this.panel.add(new JLabel(JDL.L((String)"gui.fileinfopanel.packagetab.lbl.password2", (String)"Archive Password(auto)")));
        this.panel.add((Component)this.txtPassword2, "growx, span 2");
        this.panel.add(new JLabel(JDL.L((String)"gui.fileinfopanel.packagetab.lbl.comment", (String)"Kommentar")));
        this.panel.add((Component)this.txtComment, "growx, span 2");
        return this.panel;
    }

    private JPanel createLinkInfo() {
        this.progressBarDownloadLink = new MultiProgressBar();
        this.panel = new JPanel();
        this.panel.setLayout((LayoutManager)new MigLayout("ins 10, wrap 3", "[]10[grow,fill][]", "[]5[]5[]5[]"));
        this.hosterlabel = new JLabel(JDTheme.II((String)"gui.images.sort", (int)16, (int)16));
        this.panel.add((Component)this.hosterlabel, "split 2");
        this.typeicon = new JLabel(JDTheme.II((String)"gui.images.sort", (int)16, (int)16));
        this.panel.add((Component)this.typeicon, "");
        this.typeicon.setText(JDL.L((String)"gui.fileinfopanel.linktab.chunks", (String)"Chunks"));
        this.panel.add((Component)this.progressBarDownloadLink, "spanx,growx,pushx,split 2,height 18!");
        this.txtSizeDl = new JDTextField(true);
        this.panel.add((Component)this.txtSizeDl, "alignx right");
        this.txtSizeDl.setOpaque(false);
        this.txtSizeDl.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        this.txtSizeDl.setEditable(false);
        this.txtSizeDl.setBorder(null);
        this.eta = new JLabel(JDL.LF((String)"gui.fileinfopanel.linktab.eta", (String)"ETA: %s mm:ss", (Object[])new Object[]{"0"}));
        this.panel.add(this.eta);
        this.speed = new JLabel(JDL.LF((String)"gui.fileinfopanel.linktab.speed", (String)"Speed: %s/s", (Object[])new Object[]{"0 kb"}));
        this.panel.add((Component)this.speed, "skip,alignx right");
        this.panel.add(new JLabel(JDL.L((String)"gui.fileinfopanel.linktab.name", (String)"Linkname")));
        this.txtNameDl = new JDTextField(true);
        this.panel.add((Component)this.txtNameDl, "growx, span 2");
        this.txtNameDl.setEditable(false);
        this.panel.add(new JLabel(JDL.L((String)"gui.fileinfopanel.linktab.saveto", (String)"Save to")));
        this.txtPathLabel = new JDTextField(true);
        this.panel.add((Component)this.txtPathLabel, "growx, span 2");
        this.txtPathLabel.setEditable(false);
        this.panel.add(new JLabel(JDL.L((String)"gui.fileinfopanel.linktab.url", (String)"URL")));
        this.txtURL = new JDTextField(true);
        this.panel.add((Component)this.txtURL, "growx, span 2");
        this.txtURL.setEditable(false);
        this.panel.add(new JLabel(JDL.L((String)"gui.fileinfopanel.linktab.comment", (String)"Comment")));
        this.txtCommentDl = new JDTextField(true);
        this.panel.add((Component)this.txtCommentDl, "growx, span 2");
        this.txtCommentDl.setEditable(false);
        this.panel.add(new JLabel(JDL.L((String)"gui.fileinfopanel.linktab.password", (String)"Password")));
        this.txtPasswordDl = new JDTextField(true);
        this.panel.add((Component)this.txtPasswordDl, "growx, span 2");
        this.txtPasswordDl.setEditable(false);
        this.panel.add(new JLabel(JDL.L((String)"gui.fileinfopanel.linktab.status", (String)"Status")));
        this.txtStatusDl = new JDTextField(true);
        this.panel.add((Component)this.txtStatusDl, "growx, span 2");
        this.txtStatusDl.setEditable(false);
        return this.panel;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.fp == null) {
            return;
        }
        if (e.getSource() == this.txtName) {
            this.fp.setName(this.txtName.getText());
        } else if (e.getSource() == this.brwSaveTo) {
            this.fp.setDownloadDirectory(this.brwSaveTo.getText());
        } else if (e.getSource() == this.txtComment) {
            this.fp.setComment(this.txtComment.getText());
        } else if (e.getSource() == this.txtPassword) {
            this.fp.setPassword(this.txtPassword.getText());
        } else if (e.getSource() == this.chbExtract) {
            this.fp.setExtractAfterDownload(this.chbExtract.isSelected());
        }
        DownloadController.getInstance().fireDownloadLinkUpdate((Object)this.fp.get(0));
    }

    public void onShow() {
        this.update();
        this.hidden = false;
        if (this.updater != null && this.updater.isAlive()) {
            return;
        }
        this.updater = new Thread(){

            public void run() {
                try {
                    while (!FilePackageInfo.this.hidden) {
                        FilePackageInfo.this.progressBarFilePackage.setMaximums(null);
                        FilePackageInfo.this.progressBarDownloadLink.setMaximums(null);
                        if (FilePackageInfo.this.fp != null) {
                            long[] max = new long[FilePackageInfo.this.fp.getDownloadLinkList().size()];
                            long[] values = new long[FilePackageInfo.this.fp.getDownloadLinkList().size()];
                            int i = 0;
                            for (DownloadLink dl : FilePackageInfo.this.fp.getDownloadLinkList()) {
                                max[i] = Math.max(1L, dl.getDownloadSize());
                                values[i] = dl.getLinkStatus().hasStatus(32) ? -1L : Math.max(0L, dl.getDownloadCurrent());
                                ++i;
                            }
                            FilePackageInfo.this.progressBarFilePackage.setMaximums(max);
                            FilePackageInfo.this.progressBarFilePackage.setValues(values);
                            FilePackageInfo.this.txtSize.setText(String.valueOf(Formatter.formatReadable((long)FilePackageInfo.this.fp.getTotalKBLoaded())) + "/" + Formatter.formatReadable((long)FilePackageInfo.this.fp.getTotalEstimatedPackageSize()));
                        }
                        if (FilePackageInfo.this.downloadLink != null) {
                            if (FilePackageInfo.this.downloadLink.getChunksProgress() != null && !FilePackageInfo.this.downloadLink.getLinkStatus().hasStatus(32)) {
                                long fileSize = FilePackageInfo.this.downloadLink.getDownloadSize();
                                int chunks = FilePackageInfo.this.downloadLink.getChunksProgress().length;
                                FilePackageInfo.this.typeicon.setText(String.valueOf(chunks) + " " + JDL.L((String)"gui.fileinfopanel.linktab.chunks", (String)"Chunks"));
                                long part = fileSize / (long)chunks;
                                long[] max = new long[chunks];
                                long[] values = new long[chunks];
                                int i = 0;
                                while (i < chunks) {
                                    max[i] = part;
                                    values[i] = FilePackageInfo.this.downloadLink.getChunksProgress()[i] + 1L - (long)i * part;
                                    ++i;
                                }
                                max[chunks - 1] = fileSize - part * (long)(chunks - 1);
                                values[chunks - 1] = FilePackageInfo.this.downloadLink.getChunksProgress()[chunks - 1] + 1L - part * (long)(chunks - 1);
                                FilePackageInfo.this.progressBarDownloadLink.setMaximums(max);
                                FilePackageInfo.this.progressBarDownloadLink.setValues(values);
                            } else {
                                FilePackageInfo.this.progressBarDownloadLink.setMaximums(10L);
                                if (FilePackageInfo.this.downloadLink.getLinkStatus().hasStatus(32)) {
                                    FilePackageInfo.this.progressBarDownloadLink.setValues(-1L);
                                } else {
                                    FilePackageInfo.this.progressBarDownloadLink.setValues(new long[1]);
                                }
                            }
                            FilePackageInfo.this.txtNameDl.setText(FilePackageInfo.this.downloadLink.getName());
                            if (FilePackageInfo.this.downloadLink.getSourcePluginComment() != null && FilePackageInfo.this.downloadLink.getSourcePluginComment().trim().length() > 0) {
                                FilePackageInfo.this.txtCommentDl.setText(FilePackageInfo.this.downloadLink.getSourcePluginComment());
                            } else {
                                FilePackageInfo.this.txtCommentDl.setText(FilePackageInfo.this.downloadLink.getFilePackage().getComment());
                            }
                            if (FilePackageInfo.this.downloadLink.getSourcePluginPasswordList() != null && FilePackageInfo.this.downloadLink.getSourcePluginPasswordList().size() > 0) {
                                FilePackageInfo.this.txtPasswordDl.setText(FilePackageInfo.this.downloadLink.getSourcePluginPasswordList().toString());
                            } else {
                                FilePackageInfo.this.txtPasswordDl.setText(FilePackageInfo.this.downloadLink.getFilePackage().getPassword());
                            }
                            FilePackageInfo.this.txtStatusDl.setText(FilePackageInfo.this.downloadLink.getLinkStatus().getStatusString());
                            FilePackageInfo.this.txtSizeDl.setText(String.valueOf(Formatter.formatReadable((long)FilePackageInfo.this.downloadLink.getDownloadCurrent())) + "/" + Formatter.formatReadable((long)FilePackageInfo.this.downloadLink.getDownloadSize()));
                            if (FilePackageInfo.this.downloadLink.getDownloadSpeed() <= 0) {
                                FilePackageInfo.this.eta.setVisible(false);
                                FilePackageInfo.this.speed.setVisible(false);
                            } else {
                                FilePackageInfo.this.eta.setText(JDL.LF((String)"gui.fileinfopanel.linktab.eta2", (String)"ETA: %s", (Object[])new Object[]{Formatter.formatSeconds((long)((FilePackageInfo.this.downloadLink.getDownloadSize() - FilePackageInfo.this.downloadLink.getDownloadCurrent()) / (long)FilePackageInfo.this.downloadLink.getDownloadSpeed()))}));
                                FilePackageInfo.this.speed.setText(JDL.LF((String)"gui.fileinfopanel.linktab.speed", (String)"Speed: %s/s", (Object[])new Object[]{Formatter.formatReadable((long)Math.max(0, FilePackageInfo.this.downloadLink.getDownloadSpeed()))}));
                                FilePackageInfo.this.speed.setVisible(true);
                                FilePackageInfo.this.eta.setVisible(true);
                            }
                        }
                        FilePackageInfo.this.revalidate();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.updater.start();
    }

    public void onHideSave() {
        if (this.fp == null) {
            return;
        }
        this.fp.setName(this.txtName.getText());
        this.fp.setComment(this.txtComment.getText());
        this.fp.setPassword(this.txtPassword.getText());
        this.fp.setDownloadDirectory(this.brwSaveTo.getText());
        this.fp.setExtractAfterDownload(this.chbExtract.isSelected());
    }

    public void onHide() {
        if (this.fp == null && this.downloadLink == null) {
            return;
        }
        this.onHideSave();
        this.hidden = true;
        if (this.updater != null) {
            this.updater.interrupt();
            this.updater = null;
        }
        this.progressBarFilePackage.setMaximums(null);
        this.progressBarDownloadLink.setMaximums(null);
    }

    public DownloadLink getDownloadLink() {
        return this.downloadLink;
    }

    public void setDownloadLink(DownloadLink downloadLink) {
        this.tabbedPane.setEnabledAt(1, true);
        this.tabbedPane.setSelectedIndex(1);
        if (this.downloadLink != null && this.downloadLink == downloadLink) {
            return;
        }
        this.downloadLink = downloadLink;
        if (downloadLink != null) {
            this.fp = downloadLink.getFilePackage();
            this.txtPathLabel.setText(downloadLink.getFileOutput());
            this.typeicon.setIcon(downloadLink.getIcon());
            if (downloadLink.getPlugin() != null) {
                this.hosterlabel.setIcon(downloadLink.getPlugin().getHosterIcon());
            } else {
                this.hosterlabel.setIcon(null);
            }
            this.hosterlabel.setToolTipText(downloadLink.getHost());
            this.typeicon.setToolTipText(downloadLink.getHost());
            this.txtSizeDl.setText(String.valueOf(Formatter.formatReadable((long)downloadLink.getDownloadCurrent())) + "/" + Formatter.formatReadable((long)downloadLink.getDownloadSize()));
            if (downloadLink.getLinkType() == 0) {
                this.txtURL.setText(downloadLink.getBrowserUrl());
            } else {
                this.txtURL.setText("**************");
            }
        }
        if (this.fp != null) {
            this.update();
        }
    }

    public void onClosed() {
        DownloadView.getInstance().setInfoPanel(null);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (this.fp == null) {
            return;
        }
        if (e.getSource() == this.txtName) {
            this.fp.setName(this.txtName.getText());
        } else if (e.getSource() == this.brwSaveTo) {
            this.fp.setDownloadDirectory(this.brwSaveTo.getText());
        } else if (e.getSource() == this.txtComment) {
            this.fp.setComment(this.txtComment.getText());
        } else if (e.getSource() == this.txtPassword) {
            this.fp.setPassword(this.txtPassword.getText());
        } else if (e.getSource() == this.chbExtract) {
            this.fp.setExtractAfterDownload(this.chbExtract.isSelected());
        }
        DownloadController.getInstance().fireDownloadLinkUpdate((Object)this.fp.get(0));
    }
}

