/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.linkgrabberview;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DropMode;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jd.config.Property;
import jd.controlling.LinkGrabberController;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.components.JExtCheckBoxMenuItem;
import jd.gui.swing.components.table.JDRowHighlighter;
import jd.gui.swing.components.table.JDTable;
import jd.gui.swing.jdgui.actions.ActionController;
import jd.gui.swing.jdgui.views.linkgrabberview.LinkGrabberJTableModel;
import jd.gui.swing.jdgui.views.linkgrabberview.LinkGrabberPanel;
import jd.gui.swing.jdgui.views.linkgrabberview.LinkGrabberTableAction;
import jd.gui.swing.jdgui.views.linkgrabberview.LinkGrabberTableTransferHandler;
import jd.gui.swing.jdgui.views.linkgrabberview.PropMenuItem;
import jd.plugins.DownloadLink;
import jd.plugins.LinkGrabberFilePackage;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkGrabberTable
extends JDTable
implements MouseListener,
KeyListener {
    public static final byte EXPCOL_TOP = 0;
    public static final byte EXPCOL_CUR = 1;
    public static final byte EXPCOL_BOT = 2;
    private static final long serialVersionUID = 1L;
    protected LinkGrabberPanel linkgrabber;
    private String[] prioDescs;
    private PropMenuItem propItem;
    public static final String PROPERTY_EXPANDED = "lg_expanded";
    public static final String PROPERTY_USEREXPAND = "lg_userexpand";

    public LinkGrabberPanel getLinkGrabber() {
        return this.linkgrabber;
    }

    public LinkGrabberTable(LinkGrabberPanel linkgrabber) {
        super(new LinkGrabberJTableModel("linkgrabber"));
        this.linkgrabber = linkgrabber;
        this.addMouseListener(this);
        this.addKeyListener(this);
        if (JDUtilities.getJavaVersion() >= 1.6) {
            this.setDropMode(DropMode.USE_SELECTION);
        }
        this.setDragEnabled(true);
        this.setTransferHandler(new LinkGrabberTableTransferHandler(this));
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.addPackageHighlighter();
        this.addDisabledHighlighter();
        this.addExistsHighlighter();
        this.prioDescs = new String[]{JDL.L((String)"gui.treetable.tooltip.priority-1", (String)"Low Priority"), JDL.L((String)"gui.treetable.tooltip.priority0", (String)"No Priority"), JDL.L((String)"gui.treetable.tooltip.priority1", (String)"High Priority"), JDL.L((String)"gui.treetable.tooltip.priority2", (String)"Higher Priority"), JDL.L((String)"gui.treetable.tooltip.priority3", (String)"Highest Priority")};
        this.propItem = new PropMenuItem(linkgrabber);
    }

    public void fireTableChanged() {
        new GuiRunnable<Object>(){

            @Override
            public Object runSave() {
                final Rectangle viewRect = LinkGrabberTable.this.linkgrabber.getScrollPane().getViewport().getViewRect();
                int[] rows = LinkGrabberTable.this.getSelectedRows();
                final ArrayList<Object> selected = new ArrayList<Object>();
                int[] nArray = rows;
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    int row = nArray[n2];
                    Object elem = LinkGrabberTable.this.getValueAt(row, 0);
                    if (elem != null) {
                        selected.add(elem);
                    }
                    ++n2;
                }
                LinkGrabberTable.this.getJDTableModel().refreshModel();
                LinkGrabberTable.this.getJDTableModel().fireTableStructureChanged();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        for (Object obj : selected) {
                            int row = LinkGrabberTable.this.getJDTableModel().getRowforObject(obj);
                            if (row == -1) continue;
                            LinkGrabberTable.this.addRowSelectionInterval(row, row);
                        }
                        LinkGrabberTable.this.scrollRectToVisible(viewRect);
                    }
                });
                return null;
            }
        }.start();
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        boolean ret = super.processKeyBinding(ks, e, condition, pressed);
        if (ks.getKeyCode() == 10 && !ks.isOnKeyRelease()) {
            ActionController.getToolBarAction("action.linkgrabber.addall").actionPerformed(null);
        }
        return ret;
    }

    public ArrayList<DownloadLink> getSelectedDownloadLinks() {
        int[] rows = this.getSelectedRows();
        ArrayList<DownloadLink> ret = new ArrayList<DownloadLink>();
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            Object element = this.getModel().getValueAt(row, 0);
            if (element != null && element instanceof DownloadLink) {
                ret.add((DownloadLink)element);
            }
            ++n2;
        }
        return ret;
    }

    public ArrayList<DownloadLink> getAllSelectedDownloadLinks() {
        ArrayList<DownloadLink> links = this.getSelectedDownloadLinks();
        ArrayList<LinkGrabberFilePackage> fps = this.getSelectedFilePackages();
        for (LinkGrabberFilePackage filePackage : fps) {
            for (DownloadLink dl : filePackage.getDownloadLinks()) {
                if (links.contains(dl)) continue;
                links.add(dl);
            }
        }
        return links;
    }

    public ArrayList<LinkGrabberFilePackage> getSelectedFilePackages() {
        int[] rows = this.getSelectedRows();
        ArrayList<LinkGrabberFilePackage> ret = new ArrayList<LinkGrabberFilePackage>();
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            Object element = this.getModel().getValueAt(row, 0);
            if (element != null && element instanceof LinkGrabberFilePackage) {
                ret.add((LinkGrabberFilePackage)element);
            }
            ++n2;
        }
        return ret;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Object element;
        Point p;
        int column;
        Object obj;
        if (e.getSource() != this) {
            return;
        }
        int row = this.rowAtPoint(e.getPoint());
        if (row == -1) {
            return;
        }
        if (row >= 0 && !this.isRowSelected(row) && (obj = this.getValueAt(row, 0)) != null && obj instanceof DownloadLink) {
            int row2 = this.getJDTableModel().getRowforObject(LinkGrabberController.getInstance().getFPwithLink((DownloadLink)obj));
            if (row >= 0 && this.isRowSelected(row2)) {
                this.removeRowSelectionInterval(row2, row2);
            }
        }
        if ((column = this.realColumnAtPoint(e.getPoint())) == 0 && e.getButton() == 1 && e.getClickCount() == 1 && (p = this.getPointinCell(e.getPoint())) != null && p.getX() < 30.0 && (element = this.getValueAt(row, 0)) != null && element instanceof LinkGrabberFilePackage) {
            if (e.isControlDown() && !e.isShiftDown()) {
                this.toggleFilePackageExpand((LinkGrabberFilePackage)element, (byte)2);
            } else if (e.isControlDown() && e.isShiftDown()) {
                this.toggleFilePackageExpand((LinkGrabberFilePackage)element, (byte)0);
            } else {
                this.toggleFilePackageExpand((LinkGrabberFilePackage)element, (byte)1);
            }
            return;
        }
        if (e.getButton() == 1) {
            if (column == 0 && (p = this.getPointinCell(e.getPoint())) != null && p.getX() < 30.0) {
                return;
            }
            if (e.getClickCount() == 1 && this.linkgrabber.isFilePackageInfoVisible(null) || e.getClickCount() == 2) {
                Object element2 = this.getValueAt(row, 0);
                if (this.linkgrabber.isFilePackageInfoVisible(element2) && e.getClickCount() == 2) {
                    this.linkgrabber.hideFilePackageInfo();
                } else if (element2 != null && element2 instanceof LinkGrabberFilePackage) {
                    this.linkgrabber.showFilePackageInfo((LinkGrabberFilePackage)element2);
                } else {
                    this.linkgrabber.showFilePackageInfo(LinkGrabberController.getInstance().getFPwithLink((DownloadLink)element2));
                }
            }
        }
    }

    public void toggleFilePackageExpand(LinkGrabberFilePackage fp, byte mode) {
        boolean cur = fp.getBooleanProperty(PROPERTY_EXPANDED, false) == false;
        switch (mode) {
            case 1: {
                fp.setProperty(PROPERTY_EXPANDED, (Object)cur);
                fp.setProperty(PROPERTY_USEREXPAND, (Object)true);
                break;
            }
            case 0: {
                ArrayList packages = new ArrayList(LinkGrabberController.getInstance().getPackages());
                int indexfp = LinkGrabberController.getInstance().indexOf(fp);
                int index = 0;
                while (index <= indexfp) {
                    LinkGrabberFilePackage fp2 = (LinkGrabberFilePackage)packages.get(index);
                    fp2.setProperty(PROPERTY_EXPANDED, (Object)cur);
                    fp2.setProperty(PROPERTY_USEREXPAND, (Object)true);
                    ++index;
                }
                break;
            }
            case 2: {
                int indexfp;
                ArrayList packages = new ArrayList(LinkGrabberController.getInstance().getPackages());
                int index = indexfp = LinkGrabberController.getInstance().indexOf(fp);
                while (index < packages.size()) {
                    LinkGrabberFilePackage fp2 = (LinkGrabberFilePackage)packages.get(index);
                    fp2.setProperty(PROPERTY_EXPANDED, (Object)cur);
                    fp2.setProperty(PROPERTY_USEREXPAND, (Object)true);
                    ++index;
                }
                break;
            }
            default: {
                return;
            }
        }
        this.linkgrabber.fireTableChanged();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() != this) {
            return;
        }
        Point point = e.getPoint();
        int row = this.rowAtPoint(point);
        int col = this.realColumnAtPoint(point);
        if (this.getValueAt(row, 0) == null) {
            this.clearSelection();
            if (e.getButton() == 3 && (LinkGrabberController.getInstance().getFilterPackage().size() > 0 || LinkGrabberController.getInstance().size() > 0)) {
                JPopupMenu popup = new JPopupMenu();
                popup.add(new JMenuItem(ActionController.getToolBarAction("action.linkgrabber.addall")));
                popup.add(this.builddeletemenu(null));
                this.addExtMenu(popup);
                if (popup.getComponentCount() != 0) {
                    popup.show((Component)((Object)this), point.x, point.y);
                }
            }
            return;
        }
        if (!this.isRowSelected(row) && e.getButton() == 3) {
            this.clearSelection();
            if (this.getValueAt(row, 0) != null) {
                this.addRowSelectionInterval(row, row);
            }
        }
        if (e.isPopupTrigger() || e.getButton() == 3) {
            if (this.getValueAt(row, 0) == null) {
                return;
            }
            ArrayList<DownloadLink> alllinks = this.getAllSelectedDownloadLinks();
            int links_enabled = 0;
            for (DownloadLink next : alllinks) {
                if (!next.isEnabled()) continue;
                ++links_enabled;
            }
            int links_disabled = alllinks.size() - links_enabled;
            ArrayList<LinkGrabberFilePackage> sfp = this.getSelectedFilePackages();
            Object obj = this.getModel().getValueAt(row, 0);
            JPopupMenu popup = new JPopupMenu();
            if (obj instanceof LinkGrabberFilePackage || obj instanceof DownloadLink) {
                popup.add(new JMenuItem(ActionController.getToolBarAction("action.linkgrabber.addall")));
                if (sfp.size() > 0) {
                    popup.add(new JMenuItem(new LinkGrabberTableAction(this.linkgrabber, JDTheme.II((String)"gui.images.taskpanes.linkgrabber", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.linkgrabberv2.lg.continueselected", (String)"Continue with selected package(s)")) + " (" + sfp.size() + ")", 301)));
                } else {
                    popup.add(new JMenuItem(new LinkGrabberTableAction(this.linkgrabber, JDTheme.II((String)"gui.images.taskpanes.linkgrabber", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.linkgrabberv2.lg.continueselectedlinks", (String)"Continue with selected link(s)")) + " (" + alllinks.size() + ")", 302, new Property("links", alllinks))));
                }
                popup.add(this.builddeletemenu(alllinks));
                popup.addSeparator();
            }
            if (obj instanceof LinkGrabberFilePackage) {
                popup.add(new JMenuItem(new LinkGrabberTableAction(this.linkgrabber, JDTheme.II((String)"gui.images.newpackage", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.linkgrabberv2.splithoster", (String)"Split by hoster")) + " (" + sfp.size() + ")", 501)));
                popup.add(new JMenuItem(new LinkGrabberTableAction(this.linkgrabber, JDTheme.II((String)"gui.images.add_package", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.editdownloadDir", (String)"Zielordner \u00e4ndern")) + " (" + sfp.size() + ")", 101)));
            }
            if (obj instanceof LinkGrabberFilePackage || obj instanceof DownloadLink) {
                this.addSortItem(popup, col, sfp, String.valueOf(JDL.L((String)"gui.table.contextmenu.packagesort", (String)"Paket sortieren")) + " (" + sfp.size() + "), (" + this.getJDTableModel().getColumnName(col) + ")");
                popup.addSeparator();
                if (obj instanceof DownloadLink) {
                    popup.add(new JMenuItem(new LinkGrabberTableAction(this.linkgrabber, JDTheme.II((String)"gui.icons.cut", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.copyLink", (String)"Copy URL")) + " (" + alllinks.size() + ")", 8, new Property("links", alllinks))));
                    JMenuItem tmp = new JMenuItem(new LinkGrabberTableAction(this.linkgrabber, JDTheme.II((String)"gui.images.browse", (int)16, (int)16), JDL.L((String)"gui.table.contextmenu.browseLink", (String)"im Browser \u00f6ffnen"), 7, new Property("link", obj)));
                    popup.add(tmp);
                    if (((DownloadLink)obj).getLinkType() != 0) {
                        tmp.setEnabled(false);
                    }
                }
                popup.add(new JMenuItem(new LinkGrabberTableAction(this.linkgrabber, JDTheme.II((String)"gui.images.config.network_local", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.check", (String)"Check OnlineStatus")) + " (" + alllinks.size() + ")", 120, new Property("links", alllinks))));
                popup.add(new JMenuItem(new LinkGrabberTableAction(this.linkgrabber, JDTheme.II((String)"gui.images.dlc", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.dlc", (String)"DLC erstellen")) + " (" + alllinks.size() + ")", 20, new Property("links", alllinks))));
                popup.add(this.buildpriomenu(alllinks));
                this.addExtMenu(popup);
                Set hoster = DownloadLink.getHosterList(alllinks);
                popup.add(new JMenuItem(new LinkGrabberTableAction(this.linkgrabber, JDTheme.II((String)"gui.images.addselected", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.linkgrabberv2.onlyselectedhoster", (String)"Keep only selected Hoster")) + " (" + hoster.size() + ")", 500, new Property("hoster", (Object)hoster))));
                popup.add(new JMenuItem(new LinkGrabberTableAction(this.linkgrabber, JDTheme.II((String)"gui.images.newpackage", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.newpackage2", (String)"Move to new package")) + " (" + alllinks.size() + ")", 100, new Property("links", alllinks))));
                popup.add(new JMenuItem(new LinkGrabberTableAction(this.linkgrabber, JDTheme.II((String)"gui.images.newpackage", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.mergepackage2", (String)"Merge to one package")) + " (" + alllinks.size() + ")", 110, new Property("links", alllinks))));
                popup.add(new JMenuItem(new LinkGrabberTableAction(this.linkgrabber, JDTheme.II((String)"gui.images.password", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.setdlpw", (String)"Set download password")) + " (" + alllinks.size() + ")", 201, new Property("links", alllinks))));
                popup.addSeparator();
                HashMap<String, Serializable> prop = new HashMap<String, Serializable>();
                prop.put("links", alllinks);
                prop.put("boolean", Boolean.valueOf(true));
                if (links_disabled > 0) {
                    popup.add(new JMenuItem(new LinkGrabberTableAction(this.linkgrabber, JDTheme.II((String)"gui.images.ok", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.enable", (String)"aktivieren")) + " (" + links_disabled + ")", 400, new Property("infos", prop))));
                }
                prop = new HashMap();
                prop.put("links", alllinks);
                prop.put("boolean", Boolean.valueOf(false));
                if (links_enabled > 0) {
                    popup.add(new JMenuItem(new LinkGrabberTableAction(this.linkgrabber, JDTheme.II((String)"gui.images.bad", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.disable", (String)"deaktivieren")) + " (" + links_enabled + ")", 400, new Property("infos", prop))));
                }
            }
            if (obj instanceof LinkGrabberFilePackage) {
                popup.addSeparator();
                this.propItem.setObject(obj);
                popup.add(this.propItem);
            }
            if (popup.getComponentCount() != 0) {
                popup.show((Component)((Object)this), point.x, point.y);
            }
        }
    }

    private JMenu builddeletemenu(ArrayList<DownloadLink> alllinks) {
        JMenu popup = new JMenu(JDL.L((String)"gui.table.contextmenu.remove", (String)"Remove"));
        popup.setIcon(JDTheme.II((String)"gui.images.delete", (int)16, (int)16));
        popup.add(new JMenuItem(new LinkGrabberTableAction(this.linkgrabber, JDTheme.II((String)"gui.images.removefailed", (int)16, (int)16), JDL.L((String)"gui.linkgrabberv2.lg.rmoffline", (String)"Remove all Offline"), 9991)));
        popup.add(new JMenuItem(new LinkGrabberTableAction(this.linkgrabber, JDTheme.II((String)"gui.images.delete", (int)16, (int)16), JDL.L((String)"gui.linkgrabberv2.lg.rmdups", (String)"Remove all Duplicates"), 9992)));
        if (alllinks != null && alllinks.size() > 0) {
            popup.add(new JMenuItem(new LinkGrabberTableAction(this.linkgrabber, JDTheme.II((String)"gui.images.delete", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.remove", (String)"Remove")) + " (" + alllinks.size() + ")", 999, new Property("links", alllinks))));
        }
        popup.add(new JMenuItem(ActionController.getToolBarAction("action.linkgrabber.clearlist")));
        return popup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExtMenu(JPopupMenu popup) {
        JMenu men = new JMenu(JDL.L((String)"gui.table.contextmenu.filetype", (String)"Filter"));
        ArrayList<String> extensions = this.linkgrabber.getExtensions();
        if (extensions.size() == 0) {
            return;
        }
        HashSet fl = LinkGrabberController.getInstance().getExtensionFilter();
        men.setIcon(JDTheme.II((String)"gui.images.filter", (int)16, (int)16));
        HashSet hashSet = fl;
        synchronized (hashSet) {
            for (String e : extensions) {
                JExtCheckBoxMenuItem tmp = new JExtCheckBoxMenuItem(new LinkGrabberTableAction(this.linkgrabber, null, "*." + e, 99999, new Property("extension", (Object)e)));
                men.add(tmp);
                tmp.setHideOnClick(false);
                tmp.setSelected(!fl.contains(e));
            }
        }
        popup.add(men);
    }

    private JMenu buildpriomenu(ArrayList<DownloadLink> links) {
        JMenu prioPopup = new JMenu(String.valueOf(JDL.L((String)"gui.table.contextmenu.priority", (String)"Priority")) + " (" + links.size() + ")");
        Integer prio = null;
        if (links.size() == 1) {
            prio = links.get(0).getPriority();
        }
        prioPopup.setIcon(JDTheme.II((String)"gui.images.priority0", (int)16, (int)16));
        HashMap<String, Serializable> prop = null;
        int i = 3;
        while (i >= -1) {
            prop = new HashMap<String, Serializable>();
            prop.put("links", links);
            prop.put("prio", Integer.valueOf(i));
            JMenuItem tmp = new JMenuItem(new LinkGrabberTableAction(this.linkgrabber, JDTheme.II((String)("gui.images.priority" + i), (int)16, (int)16), this.prioDescs[i + 1], 200, new Property("infos", prop)));
            prioPopup.add(tmp);
            if (prio != null && i == prio) {
                tmp.setEnabled(false);
                tmp.setIcon(JDTheme.II((String)("gui.images.priority" + i), (int)16, (int)16));
            } else {
                tmp.setEnabled(true);
            }
            --i;
        }
        return prioPopup;
    }

    private void addDisabledHighlighter() {
        this.addJDRowHighlighter(new JDRowHighlighter(JDTheme.C((String)"gui.color.downloadlist.row_link_disabled", (String)"adadad", (int)100)){

            public boolean doHighlight(Object o) {
                return o != null && o instanceof DownloadLink && !((DownloadLink)o).isEnabled();
            }
        });
    }

    private void addPackageHighlighter() {
        this.addJDRowHighlighter(new JDRowHighlighter(UIManager.getColor("TableHeader.background")){

            public boolean doHighlight(Object o) {
                return o != null && o instanceof LinkGrabberFilePackage;
            }
        });
    }

    private void addExistsHighlighter() {
        this.addJDRowHighlighter(new JDRowHighlighter(JDTheme.C((String)"gui.color.linkgrabber.error_exists", (String)"ff7f00", (int)120)){

            public boolean doHighlight(Object o) {
                return o != null && o instanceof DownloadLink && ((DownloadLink)o).getLinkStatus().hasStatus(8192);
            }
        });
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            ArrayList<DownloadLink> alllinks = this.getAllSelectedDownloadLinks();
            LinkGrabberTableAction test = new LinkGrabberTableAction(this.linkgrabber, JDTheme.II((String)"gui.images.delete", (int)16, (int)16), String.valueOf(JDL.L((String)"gui.table.contextmenu.delete", (String)"entfernen")) + " (" + alllinks.size() + ")", 999, new Property("links", alllinks));
            test.actionPerformed(new ActionEvent(test, 0, ""));
        }
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }
}

