/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.logview;

import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import jd.controlling.JDLogHandler;
import jd.controlling.JDLogger;
import jd.controlling.LogFormatter;
import jd.event.ControlEvent;
import jd.event.ControlListener;
import jd.gui.UserIO;
import jd.gui.swing.components.JDFileChooser;
import jd.gui.swing.components.linkbutton.JLink;
import jd.gui.swing.jdgui.interfaces.SwitchPanel;
import jd.nutils.JDFlags;
import jd.nutils.encoding.Encoding;
import jd.nutils.io.JDIO;
import jd.utils.JDUtilities;
import jd.utils.Upload;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class LogPane
extends SwitchPanel
implements ActionListener,
ControlListener {
    private static final long serialVersionUID = -5753733398829409112L;
    private static final Object LOCK = new Object();
    private JTextPane logField;

    public LogPane() {
        this.setName("LOGDIALOG");
        this.setLayout((LayoutManager)new MigLayout("ins 3", "[fill,grow]", "[fill,grow]"));
        this.logField = new JTextPane();
        this.logField.setEditable(true);
        this.logField.setAutoscrolls(true);
        this.add(new JScrollPane(this.logField));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        switch (e.getID()) {
            case 1: {
                File ret;
                JDFileChooser fc = new JDFileChooser();
                fc.setApproveButtonText(JDL.L((String)"gui.btn_save", (String)"Save"));
                fc.setFileSelectionMode(0);
                if (fc.showOpenDialog(this) != 0 || (ret = fc.getSelectedFile()) == null) break;
                String content = this.toString();
                JDIO.writeLocalFile((File)ret, (String)content);
                JDLogger.getLogger().info("Log saved to file: " + ret.getAbsolutePath());
                break;
            }
            case 2: {
                String question;
                int status;
                Level level = JDLogger.getLogger().getLevel();
                if (!level.equals(Level.ALL) && JDFlags.hasSomeFlags((int)(status = UserIO.getInstance().requestHelpDialog(4, JDL.L((String)"gui.logdialog.loglevelwarning.title", (String)"Wrong Loglevel for Uploading selected!"), JDL.LF((String)"gui.logdialog.loglevelwarning", (String)"The selected loglevel (%s) isn't preferred to upload a log! Please change it to ALL and create a new log!", (Object[])new Object[]{level.getName()}), null, "http://jdownloader.org/knowledge/wiki/support/create-a-jd-log")), (int[])new int[]{4, 32})) {
                    return;
                }
                String content = null;
                Object object = LOCK;
                synchronized (object) {
                    content = this.logField.getSelectedText();
                    if (content == null || content.length() == 0) {
                        content = Encoding.UTF8Encode((String)this.logField.getText());
                    }
                }
                if (content == null || content.length() == 0) {
                    return;
                }
                String name = UserIO.getInstance().requestInputDialog(4, JDL.L((String)"userio.input.title", (String)"Please enter!"), JDL.L((String)"gui.askName", (String)"Your name?"), null, null, null, null);
                if (name == null) {
                    name = "";
                }
                if ((question = UserIO.getInstance().requestInputDialog(4, JDL.L((String)"userio.input.title", (String)"Please enter!"), JDL.L((String)"gui.logger.askQuestion", (String)"Please describe your Problem/Bug/Question!"), null, null, null, null)) == null) {
                    question = "";
                }
                this.append("\r\n\r\n-------------------------------------------------------------\r\n\r\n");
                String url = Upload.toJDownloader((String)content, (String)(String.valueOf(name) + "\r\n\r\n" + question));
                if (url != null) {
                    try {
                        JLink.openURL(url);
                        this.append(String.valueOf(JDL.L((String)"gui.logupload.message", (String)"Please send this loglink to your supporter")) + "\r\n");
                        this.append(url);
                    }
                    catch (Exception e1) {
                        JDLogger.exception((Throwable)e1);
                    }
                } else {
                    UserIO.getInstance().requestConfirmDialog(48, JDL.L((String)"sys.warning.loguploadfailed", (String)"Upload of logfile failed!"));
                    this.append(JDL.L((String)"gui.logDialog.warning.uploadFailed", (String)"Upload failed"));
                }
                this.append("\r\n\r\n-------------------------------------------------------------\r\n\r\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = LOCK;
        synchronized (object) {
            String content = this.logField.getSelectedText();
            if (content == null || content.length() == 0) {
                content = this.logField.getText();
            }
            return content;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onShow() {
        try {
            JDUtilities.getController().addControlListener((ControlListener)this);
            ArrayList buff = new ArrayList();
            buff.addAll(JDLogHandler.getHandler().getBuffer());
            LogFormatter formater = (LogFormatter)JDLogHandler.getHandler().getFormatter();
            StringBuilder sb = new StringBuilder();
            for (LogRecord lr : buff) {
                sb.append(this.format(lr, formater));
            }
            Object object = LOCK;
            synchronized (object) {
                this.logField.setText(sb.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String format(LogRecord lr, LogFormatter formater) {
        if (lr.getThrown() != null) {
            return "EXCEPTION   " + formater.format(lr);
        }
        return formater.format(lr);
    }

    public void onHide() {
        JDUtilities.getController().removeControlListener((ControlListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String sb) {
        Object object = LOCK;
        synchronized (object) {
            Document doc = this.logField.getDocument();
            EditorKit editorkit = this.logField.getEditorKit();
            StringReader r = new StringReader(sb);
            try {
                editorkit.read(r, doc, doc.getEndPosition().getOffset() - 1);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void controlEvent(ControlEvent event) {
        if (event.getID() == 29) {
            this.append(this.format((LogRecord)event.getParameter(), (LogFormatter)JDLogHandler.getHandler().getFormatter()));
        }
    }
}

