/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.sidebars.configuration;

import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.jdgui.GUIUtils;
import jd.gui.swing.jdgui.interfaces.SideBarPanel;
import jd.gui.swing.jdgui.views.ConfigurationView;
import jd.gui.swing.jdgui.views.sidebars.configuration.ConfigTreeModel;
import jd.gui.swing.jdgui.views.sidebars.configuration.TreeRenderer;
import jd.gui.swing.laf.LookAndFeelController;
import net.miginfocom.swing.MigLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigSidebar
extends SideBarPanel {
    private static final long serialVersionUID = 6456662020047832983L;
    private static final String PROPERTY_LAST_PANEL = "LAST_PANEL";
    private static ConfigSidebar INSTANCE = null;
    private JTree tree;
    private ConfigurationView view;

    public static ConfigSidebar getInstance(ConfigurationView configurationView) {
        if (INSTANCE == null && configurationView != null) {
            INSTANCE = new ConfigSidebar(configurationView);
        }
        return INSTANCE;
    }

    private ConfigSidebar(ConfigurationView configurationView) {
        this.view = configurationView;
        this.setLayout((LayoutManager)new MigLayout("ins 0", "[grow,fill]", "[grow,fill]"));
        this.tree = new JTree(new ConfigTreeModel()){
            private static final long serialVersionUID = -5018817191000357595L;

            public void processMouseEvent(MouseEvent m) {
                if (m.getClickCount() > 1) {
                    return;
                }
                super.processMouseEvent(m);
            }

            public void processKeyEvent(KeyEvent m) {
                if (LookAndFeelController.isSynthetica()) {
                    return;
                }
                super.processKeyEvent(m);
            }
        };
        this.add(this.tree);
        this.tree.setCellRenderer(new TreeRenderer());
        this.tree.setOpaque(false);
        this.tree.setRootVisible(false);
        this.tree.setRowHeight(24);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.setBackground(null);
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                if (ConfigSidebar.this.tree.getSelectionPath() == null) {
                    return;
                }
                ConfigTreeModel.TreeEntry entry = (ConfigTreeModel.TreeEntry)event.getPath().getLastPathComponent();
                ConfigSidebar.this.tree.setSelectionPath(event.getPath());
                if (entry.getPanel() != null) {
                    ConfigSidebar.this.view.setContent(entry.getPanel().getPanel());
                }
            }
        });
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){
            private ConfigTreeModel.TreeEntry entry;

            public void valueChanged(TreeSelectionEvent e) {
                new GuiRunnable<Object>(){

                    @Override
                    public Object runSave() {
                        if (ConfigSidebar.this.tree.getSelectionPath() == null) {
                            return null;
                        }
                        entry = (ConfigTreeModel.TreeEntry)ConfigSidebar.this.tree.getSelectionPath().getLastPathComponent();
                        ConfigSidebar.this.tree.expandPath(ConfigSidebar.this.tree.getSelectionPath());
                        if (entry.getPanel() != null) {
                            ConfigSidebar.this.view.setContent(entry.getPanel().getPanel());
                        }
                        return null;
                    }
                }.start();
            }
        });
        TreePath rootPath = new TreePath(this.tree.getModel().getRoot());
        this.tree.expandPath(rootPath);
        ConfigTreeModel.TreeEntry node = (ConfigTreeModel.TreeEntry)rootPath.getLastPathComponent();
        for (ConfigTreeModel.TreeEntry n : node.getEntries()) {
            TreePath path = rootPath.pathByAddingChild(n);
            this.tree.expandPath(path);
        }
        this.tree.setSelectionRow(1);
        String lastPanel = GUIUtils.getConfig().getStringProperty(PROPERTY_LAST_PANEL, null);
        if (lastPanel != null) {
            try {
                Class<?> lastPanelClass = Class.forName(lastPanel);
                this.setSelectedTreeEntry(lastPanelClass);
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void expandAll(JTree tree, boolean expand) {
        ConfigTreeModel.TreeEntry root = (ConfigTreeModel.TreeEntry)tree.getModel().getRoot();
        this.expandAll(tree, new TreePath(root), expand);
    }

    public void expandAll(JTree tree, TreePath parent, boolean expand) {
        ConfigTreeModel.TreeEntry node = (ConfigTreeModel.TreeEntry)parent.getLastPathComponent();
        if (node.size() >= 0) {
            for (ConfigTreeModel.TreeEntry n : node.getEntries()) {
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    @Override
    protected void onHide() {
        if (((ConfigTreeModel.TreeEntry)this.tree.getLastSelectedPathComponent()).getPanel() == null) {
            return;
        }
        if (((ConfigTreeModel.TreeEntry)this.tree.getLastSelectedPathComponent()).getPanel().getPanel() == null) {
            return;
        }
        GUIUtils.getConfig().setProperty(PROPERTY_LAST_PANEL, (Object)((ConfigTreeModel.TreeEntry)this.tree.getLastSelectedPathComponent()).getPanel().getPanel().getClass().getName());
        GUIUtils.getConfig().save();
    }

    @Override
    protected void onShow() {
    }

    public void setSelectedTreeEntry(Class<?> class1) {
        ConfigTreeModel.TreeEntry root = (ConfigTreeModel.TreeEntry)this.tree.getModel().getRoot();
        ConfigTreeModel.TreeEntry child = ConfigTreeModel.TreeEntry.getTreeByClass(class1);
        if (child == null) {
            return;
        }
        TreePath path = this.getEntry(new TreePath(root), child);
        if (path != null) {
            this.tree.setSelectionPath(path);
            this.tree.setSelectionPath(path);
        }
    }

    private TreePath getEntry(TreePath parent, ConfigTreeModel.TreeEntry treeEntry) {
        ConfigTreeModel.TreeEntry node = (ConfigTreeModel.TreeEntry)parent.getLastPathComponent();
        if (node == treeEntry) {
            return parent;
        }
        if (node.size() >= 0) {
            for (ConfigTreeModel.TreeEntry n : node.getEntries()) {
                TreePath path = parent.pathByAddingChild(n);
                TreePath res = this.getEntry(path, treeEntry);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    public void updateAddons() {
        TreePath path = ((ConfigTreeModel)this.tree.getModel()).updateAddons();
        this.expandAll(this.tree, path, true);
    }
}

