/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.laf;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import jd.JDInitFlags;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.crypt.JDCrypt;
import jd.gui.swing.jdgui.GUIUtils;
import jd.gui.swing.laf.LookAndFeelWrapper;
import jd.nutils.OSDetector;
import jd.utils.JDHexUtils;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import jd.utils.locale.JDLEvent;
import jd.utils.locale.JDLListener;

public class LookAndFeelController {
    public static final String PARAM_PLAF = "PLAF5";
    public static final String DEFAULT_PREFIX = "LAF_CFG";
    private static boolean uiInitated = false;

    public static LookAndFeelWrapper[] getSupportedLookAndFeels() {
        UIManager.LookAndFeelInfo[] lafis = UIManager.getInstalledLookAndFeels();
        ArrayList<LookAndFeelWrapper> ret = new ArrayList<LookAndFeelWrapper>();
        int i = 0;
        while (i < lafis.length) {
            LookAndFeelWrapper lafm;
            String clname = lafis[i].getClassName();
            if (clname.contains("Substance") && JDUtilities.getJavaVersion() >= 1.6) {
                ret.add(new LookAndFeelWrapper(lafis[i]).setName(lafis[i].getName().replaceAll("([A-Z0-9]\\d*)", " $0").trim()));
            } else if (clname.contains("Synthetica")) {
                ret.add(new LookAndFeelWrapper(lafis[i]).setName(lafis[i].getName().replaceAll("([A-Z0-9]\\d*)", " $0").trim()));
            } else if (clname.contains("goodie")) {
                lafm = new LookAndFeelWrapper(lafis[i]);
                lafm.setName(lafis[i].getName());
                ret.add(lafm);
            } else if (clname.startsWith("apple.laf")) {
                lafm = new LookAndFeelWrapper(lafis[i]);
                lafm.setName("Apple Aqua");
                ret.add(lafm);
            } else if (clname.endsWith("WindowsLookAndFeel")) {
                lafm = new LookAndFeelWrapper(lafis[i]);
                lafm.setName("Windows Style");
                ret.add(lafm);
            } else if (clname.endsWith("MetalLookAndFeel") && OSDetector.isLinux()) {
                lafm = new LookAndFeelWrapper(lafis[i]);
                lafm.setName("Light(Metal)");
                ret.add(lafm);
            } else if (clname.endsWith("GTKLookAndFeel") && OSDetector.isLinux()) {
                lafm = new LookAndFeelWrapper(lafis[i]);
                lafm.setName("Light(GTK)");
                ret.add(lafm);
            } else if (clname.startsWith("com.jtattoo")) {
                lafm = new LookAndFeelWrapper(lafis[i]);
                lafm.setName(lafis[i].getName());
                ret.add(lafm);
            } else if (JDInitFlags.SWITCH_DEBUG) {
                lafm = new LookAndFeelWrapper(lafis[i]);
                lafm.setName(String.valueOf(lafis[i].getName()) + " [Debug]");
                ret.add(lafm);
            }
            ++i;
        }
        return ret.toArray(new LookAndFeelWrapper[0]);
    }

    public static LookAndFeelWrapper getPlaf() {
        LookAndFeelWrapper ret = LookAndFeelController.getPlaf0();
        LookAndFeelWrapper[] lookAndFeelWrapperArray = LookAndFeelController.getSupportedLookAndFeels();
        int n = lookAndFeelWrapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            LookAndFeelWrapper laf = lookAndFeelWrapperArray[n2];
            if (ret.getClassName().equals(laf.getClassName())) {
                return ret;
            }
            ++n2;
        }
        return LookAndFeelController.getDefaultLAFM();
    }

    public static LookAndFeelWrapper getPlaf0() {
        SubConfiguration config = GUIUtils.getConfig();
        Object plaf = config.getProperty(PARAM_PLAF, null);
        if (plaf == null) {
            return LookAndFeelController.getDefaultLAFM();
        }
        if (plaf instanceof LookAndFeelWrapper) {
            if (((LookAndFeelWrapper)plaf).getName() != null) {
                return (LookAndFeelWrapper)plaf;
            }
            plaf = LookAndFeelController.getDefaultLAFM();
            config.setProperty(PARAM_PLAF, plaf);
            config.save();
            return (LookAndFeelWrapper)plaf;
        }
        if (plaf instanceof String) {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo lafi = lookAndFeelInfoArray[n2];
                if (lafi.getName().equals(plaf) || lafi.getName().equals("Substance" + plaf)) {
                    plaf = new LookAndFeelWrapper(lafi);
                    config.setProperty(PARAM_PLAF, plaf);
                    config.save();
                    return (LookAndFeelWrapper)plaf;
                }
                ++n2;
            }
        }
        return LookAndFeelController.getDefaultLAFM();
    }

    private static LookAndFeelWrapper getDefaultLAFM() {
        return new LookAndFeelWrapper("de.javasoft.plaf.synthetica.SyntheticaSimple2DLookAndFeel");
    }

    public static void setUIManager() {
        if (uiInitated) {
            return;
        }
        uiInitated = true;
        LookAndFeelController.install();
        try {
            String laf = LookAndFeelController.getPlaf().getClassName();
            JDLogger.getLogger().info("Use Look & Feel: " + laf);
            LookAndFeelController.preSetup(laf);
            UIManager.put("ClassLoader", JDUtilities.getJDClassLoader());
            if (laf.contains("Synthetica")) {
                try {
                    Class<?> slaf = Class.forName("de.javasoft.plaf.synthetica.SyntheticaLookAndFeel");
                    Method method = slaf.getMethod("setLookAndFeel", String.class, Boolean.TYPE, Boolean.TYPE);
                    method.invoke(null, laf, false, false);
                    slaf.getMethod("setExtendedFileChooserEnabled", Boolean.TYPE).invoke(null, false);
                }
                catch (InvocationTargetException e) {
                    JDLogger.exception((Throwable)e);
                    try {
                        UIManager.setLookAndFeel(laf);
                    }
                    catch (Exception e2) {
                        GUIUtils.getConfig().setProperty("SHOW_SPLASH", (Object)false);
                        GUIUtils.getConfig().save();
                        JDLogger.warning((Object)"Disabled Splashscreen cause it cases LAF errors");
                        JDLogger.exception((Throwable)e2);
                        uiInitated = false;
                        return;
                    }
                }
            } else {
                UIManager.setLookAndFeel(laf);
            }
            UIManager.put("ClassLoader", JDUtilities.getJDClassLoader());
            SubConfiguration cfg = SubConfiguration.getConfig((String)("LAF_CFG." + laf));
            LookAndFeelController.postSetup(laf);
            for (Map.Entry next : cfg.getProperties().entrySet()) {
                JDLogger.getLogger().info("Use special LAF Property: " + (String)next.getKey() + " = " + next.getValue());
                UIManager.put(next.getKey(), next.getValue());
            }
        }
        catch (Throwable e) {
            JDLogger.exception((Throwable)e);
        }
        JDL.getBroadcaster().addListener((EventListener)new JDLListener(){

            public void onJDLEvent(JDLEvent event) {
                if (event.getID() == 1 && JDL.getSettings().get("font") != null && LookAndFeelController.isSynthetica()) {
                    String font = (String)JDL.getSettings().get("font");
                    int fontsize = 12;
                    try {
                        fontsize = Integer.parseInt((String)JDL.getSettings().get("fontsize"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        Class.forName("de.javasoft.plaf.synthetica.SyntheticaLookAndFeel").getMethod("setFont", String.class, Integer.TYPE).invoke(null, font, fontsize);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private static void install() {
        for (File file : JDUtilities.getJDClassLoader().getLafs()) {
            try {
                JarEntry e;
                JarInputStream jarFile = new JarInputStream(new FileInputStream(file));
                ArrayList<String> names = new ArrayList<String>();
                ArrayList<String> classes = new ArrayList<String>();
                while ((e = jarFile.getNextJarEntry()) != null) {
                    if (!e.getName().endsWith(".class") || e.getName().contains("$")) continue;
                    String cl = e.getName().replace("/", ".");
                    if (!(cl = cl.substring(0, cl.length() - 6)).toLowerCase().endsWith("lookandfeel")) continue;
                    Class clazz = JDUtilities.getJDClassLoader().loadClass(cl);
                    try {
                        if (!LookAndFeel.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers())) continue;
                        String name = clazz.getSimpleName().replace("LookAndFeel", "");
                        names.add(name);
                        classes.add(cl);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                int i = 0;
                while (i < names.size()) {
                    UIManager.installLookAndFeel((String)names.get(i), (String)classes.get(i));
                    ++i;
                }
            }
            catch (Throwable e) {
                JDLogger.exception((Throwable)e);
            }
        }
    }

    private static void postSetup(String className) {
        int fontsize = GUIUtils.getConfig().getIntegerProperty("PARAM_GENERAL_FONT_SIZE3", 100);
        if (LookAndFeelController.isSynthetica()) {
            try {
                String font = "" + Class.forName("de.javasoft.plaf.synthetica.SyntheticaLookAndFeel").getMethod("getFontName", new Class[0]).invoke(null, new Object[0]);
                int fonts = (Integer)Class.forName("de.javasoft.plaf.synthetica.SyntheticaLookAndFeel").getMethod("getFontSize", new Class[0]).invoke(null, new Object[0]);
                Class.forName("de.javasoft.plaf.synthetica.SyntheticaLookAndFeel").getMethod("setFont", String.class, Integer.TYPE).invoke(null, font, fonts * fontsize / 100);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Enumeration e = UIManager.getDefaults().keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value = UIManager.get(key);
                if (!(value instanceof Font)) continue;
                Font f = (Font)value;
                UIManager.put(key, new FontUIResource(f.getName(), f.getStyle(), f.getSize() * fontsize / 100));
            }
        }
    }

    private static void preSetup(String className) {
        Boolean windowDeco = GUIUtils.getConfig().getBooleanProperty("DECORATION_ENABLED2", true);
        UIManager.put("Synthetica.window.decoration", windowDeco);
        JFrame.setDefaultLookAndFeelDecorated(windowDeco);
        JDialog.setDefaultLookAndFeelDecorated(windowDeco);
        String[] li = new String[]{"Licensee=AppWork UG", "LicenseRegistrationNumber=289416475", "Product=Synthetica", "LicenseType=Small Business License", "ExpireDate=--.--.----", "MaxVersion=2.999.999"};
        UIManager.put("Synthetica.license.info", li);
        byte[] byArray = new byte[16];
        byArray[0] = 1;
        byArray[1] = 2;
        byArray[2] = 3;
        byArray[3] = 4;
        byArray[4] = 5;
        byArray[5] = 6;
        byArray[6] = 7;
        byArray[7] = 8;
        byArray[8] = 9;
        byArray[10] = 11;
        byArray[11] = 12;
        byArray[12] = 13;
        byArray[13] = 14;
        byArray[14] = 15;
        byArray[15] = 16;
        UIManager.put("Synthetica.license.key", JDCrypt.decrypt((byte[])JDHexUtils.getByteArray((String)"4a94286634a203ada63b87c54662227252490d6f10e421b7239c610138c53e4c51fc7c0a2a8a18a0a2c0a40191b1186f"), (byte[])byArray));
    }

    public static boolean isSubstance() {
        return UIManager.getLookAndFeel().getName().toLowerCase().contains("substance");
    }

    public static boolean isSynthetica() {
        return UIManager.getLookAndFeel().getName().toLowerCase().contains("synthetica");
    }
}

