/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import jd.OptionalPluginWrapper;
import jd.PluginWrapper;
import jd.config.ConfigEntry;
import jd.config.Property;
import jd.config.SubConfiguration;
import jd.controlling.DownloadWatchDog;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.event.ControlEvent;
import jd.event.ControlListener;
import jd.gui.UserIO;
import jd.gui.swing.jdgui.actions.ToolBarAction;
import jd.gui.swing.jdgui.menu.MenuAction;
import jd.nutils.JDFlags;
import jd.nutils.OSDetector;
import jd.plugins.OptionalPlugin;
import jd.plugins.PluginOptional;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionalPlugin(rev="$Revision: 9563 $", id="shutdown", interfaceversion=5)
public class JDShutdown
extends PluginOptional {
    private static final int count = 60;
    private static final String CONFIG_ENABLEDONSTART = "ENABLEDONSTART";
    private static final String CONFIG_MODE = "CONFIG_MODE";
    private static final String CONFIG_FORCESHUTDOWN = "FORCE";
    private static Thread shutdown = null;
    private static boolean shutdownEnabled;
    private static MenuAction menuAction;
    private static String[] MODES_AVAIL;

    static {
        menuAction = null;
        MODES_AVAIL = null;
    }

    public JDShutdown(PluginWrapper wrapper) {
        super(wrapper);
        MODES_AVAIL = new String[]{JDL.L((String)"gui.config.jdshutdown.shutdown", (String)"Shutdown"), JDL.L((String)"gui.config.jdshutdown.standby", (String)"Standby (Nur einige OS)"), JDL.L((String)"gui.config.jdshutdown.hibernate", (String)"Ruhezustand/Hibernate (Nur einige OS)"), JDL.L((String)"gui.config.jdshutdown.close", (String)"Close JD")};
        shutdownEnabled = this.getPluginConfig().getBooleanProperty(CONFIG_ENABLEDONSTART, false);
        this.initConfig();
    }

    public void controlEvent(ControlEvent event) {
        super.controlEvent(event);
        if (shutdownEnabled && event.getID() == 1 && DownloadWatchDog.getInstance().getDownloadssincelastStart() > 0) {
            if (shutdown != null) {
                if (!shutdown.isAlive()) {
                    shutdown = new ShutDown();
                    shutdown.start();
                }
            } else {
                shutdown = new ShutDown();
                shutdown.start();
            }
        }
    }

    public ArrayList<MenuAction> createMenuitems() {
        ArrayList<MenuAction> menu = new ArrayList<MenuAction>();
        menu.add(menuAction);
        return menu;
    }

    public boolean initAddon() {
        if (menuAction == null) {
            menuAction = new MenuAction("gui.jdshutdown.toggle", "gui.images.logout"){
                private static final long serialVersionUID = 4359802245569811800L;

                public void initDefaults() {
                    this.setPriority(800);
                    this.setToolTipText(JDL.L((String)"gui.jdshutdown.toggle.tooltip", (String)"Enable/Disable Shutdown after Downloads"));
                    this.setEnabled(true);
                    this.setType(ToolBarAction.Types.TOGGLE);
                    this.setIcon("gui.images.logout");
                    this.addPropertyChangeListener(new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent evt) {
                            if (evt.getPropertyName() == "SwingSelectedKey") {
                                shutdownEnabled = this.isSelected();
                                if (shutdownEnabled) {
                                    UserIO.getInstance().requestMessageDialog(32, JDL.L((String)"addons.jdshutdown.statusmessage.enabled", (String)"Das System wird nach dem Download heruntergefahren."));
                                } else {
                                    UserIO.getInstance().requestMessageDialog(32, JDL.L((String)"addons.jdshutdown.statusmessage.disabled", (String)"Das System wird nach dem Download NICHT heruntergefahren."));
                                }
                            }
                        }
                    });
                }
            };
        }
        menuAction.setSelected(shutdownEnabled);
        JDUtilities.getController().addControlListener((ControlListener)this);
        logger.info("Shutdown OK");
        return true;
    }

    public void onExit() {
        JDUtilities.getController().removeControlListener((ControlListener)this);
    }

    private void closejd() {
        logger.info("close jd");
        JDUtilities.getController().exit();
    }

    private void shutdown() {
        logger.info("shutdown");
        JDController.getInstance().prepareShutdown(false);
        byte id = 0;
        id = OSDetector.getOSID();
        switch (id) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                if (this.getPluginConfig().getBooleanProperty(CONFIG_FORCESHUTDOWN, false).booleanValue()) {
                    try {
                        JDUtilities.runCommand((String)"shutdown.exe", (String[])new String[]{"-s", "-f", "-t", "01"}, null, (int)0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        JDUtilities.runCommand((String)"%windir%\\system32\\shutdown.exe", (String[])new String[]{"-s", "-f", "-t", "01"}, null, (int)0);
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        JDUtilities.runCommand((String)"shutdown.exe", (String[])new String[]{"-s", "-t", "01"}, null, (int)0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        JDUtilities.runCommand((String)"%windir%\\system32\\shutdown.exe", (String[])new String[]{"-s", "-t", "01"}, null, (int)0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (id != 2 && id != 3) break;
                try {
                    FileWriter fw = null;
                    BufferedWriter bw = null;
                    try {
                        fw = new FileWriter(JDUtilities.getResourceFile((String)"jd/shutdown.vbs"));
                        bw = new BufferedWriter(fw);
                        bw.write("set WshShell = CreateObject(\"WScript.Shell\")\r\nWshShell.SendKeys \"^{ESC}^{ESC}^{ESC}{UP}{ENTER}{ENTER}\"\r\n");
                        bw.flush();
                        bw.close();
                        JDUtilities.runCommand((String)"cmd", (String[])new String[]{"/c", "start", "/min", "cscript", JDUtilities.getResourceFile((String)"jd/shutdown.vbs").getAbsolutePath()}, null, (int)0);
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (Exception exception) {}
                break;
            }
            case 4: {
                try {
                    JDUtilities.runCommand((String)"RUNDLL32.EXE", (String[])new String[]{"user,ExitWindows"}, null, (int)0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    JDUtilities.runCommand((String)"RUNDLL32.EXE", (String[])new String[]{"Shell32,SHExitWindowsEx", "1"}, null, (int)0);
                }
                catch (Exception exception) {}
                break;
            }
            case 5: {
                try {
                    JDUtilities.runCommand((String)"/usr/bin/osascript", (String[])new String[]{JDUtilities.getResourceFile((String)"jd/osx/osxshutdown.scpt").getAbsolutePath()}, null, (int)0);
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                try {
                    this.dbusPowerState("Shutdown");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    JDUtilities.runCommand((String)"dcop", (String[])new String[]{"--all-sessions", "--all-users", "ksmserver", "ksmserver", "logout", "0", "2", "0"}, null, (int)0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    JDUtilities.runCommand((String)"sudo", (String[])new String[]{"shutdown", "-h", "now"}, null, (int)0);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            Thread.sleep(8000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(0);
    }

    private void prepareHibernateOrStandby() {
        logger.info("Stop all running downloads");
        DownloadWatchDog.getInstance().stopDownloads();
        JDController.getInstance().syncDatabase();
    }

    private void hibernate() {
        switch (OSDetector.getOSID()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                this.prepareHibernateOrStandby();
                try {
                    JDUtilities.runCommand((String)"powercfg.exe", (String[])new String[]{"hibernate on"}, null, (int)0);
                }
                catch (Exception e) {
                    try {
                        JDUtilities.runCommand((String)"%windir%\\system32\\powercfg.exe", (String[])new String[]{"hibernate on"}, null, (int)0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    JDUtilities.runCommand((String)"RUNDLL32.EXE", (String[])new String[]{"powrprof.dll,SetSuspendState"}, null, (int)0);
                }
                catch (Exception e) {
                    try {
                        JDUtilities.runCommand((String)"%windir%\\system32\\RUNDLL32.EXE", (String[])new String[]{"powrprof.dll,SetSuspendState"}, null, (int)0);
                    }
                    catch (Exception exception) {}
                }
                break;
            }
            case 4: {
                logger.info("no hibernate support, use shutdown");
                this.shutdown();
                break;
            }
            case 5: {
                this.prepareHibernateOrStandby();
                try {
                    JDUtilities.runCommand((String)"/usr/bin/osascript", (String[])new String[]{JDUtilities.getResourceFile((String)"jd/osx/osxhibernate.scpt").getAbsolutePath()}, null, (int)0);
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                this.prepareHibernateOrStandby();
                try {
                    this.dbusPowerState("Hibernate");
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void standby() {
        switch (OSDetector.getOSID()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                this.prepareHibernateOrStandby();
                try {
                    JDUtilities.runCommand((String)"powercfg.exe", (String[])new String[]{"hibernate off"}, null, (int)0);
                }
                catch (Exception e) {
                    try {
                        JDUtilities.runCommand((String)"%windir%\\system32\\powercfg.exe", (String[])new String[]{"hibernate off"}, null, (int)0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    JDUtilities.runCommand((String)"RUNDLL32.EXE", (String[])new String[]{"powrprof.dll,SetSuspendState"}, null, (int)0);
                }
                catch (Exception e) {
                    try {
                        JDUtilities.runCommand((String)"%windir%\\system32\\RUNDLL32.EXE", (String[])new String[]{"powrprof.dll,SetSuspendState"}, null, (int)0);
                    }
                    catch (Exception exception) {}
                }
                break;
            }
            case 4: {
                logger.info("no standby support, use shutdown");
                this.shutdown();
                break;
            }
            case 5: {
                logger.info("no standby support, use shutdown");
                this.shutdown();
                break;
            }
            default: {
                this.prepareHibernateOrStandby();
                try {
                    this.dbusPowerState("Suspend");
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void dbusPowerState(String command) {
        JDUtilities.runCommand((String)"dbus-send", (String[])new String[]{"--session", "--dest=org.freedesktop.PowerManagement", "--type=method_call", "--print-reply", "--reply-timeout=2000", "/org/freedesktop/PowerManagement", "org.freedesktop.PowerManagement." + command}, null, (int)0);
    }

    public String getIconKey() {
        return "gui.images.logout";
    }

    private void initConfig() {
        SubConfiguration subConfig = this.getPluginConfig();
        this.config.addEntry(new ConfigEntry(3, (Property)subConfig, CONFIG_ENABLEDONSTART, JDL.L((String)"gui.config.jdshutdown.enabledOnStart", (String)"Enabled on Start")).setDefaultValue((Object)false));
        this.config.addEntry(new ConfigEntry(15, (Property)subConfig, CONFIG_MODE, (Object[])MODES_AVAIL, JDL.L((String)"gui.config.jdshutdown.mode", (String)"Mode:")).setDefaultValue((Object)0));
        this.config.addEntry(new ConfigEntry(3, (Property)subConfig, CONFIG_FORCESHUTDOWN, JDL.L((String)"gui.config.jdshutdown.forceshutdown", (String)"Herunterfahren erzwingen (Nur einige OS)")).setDefaultValue((Object)false));
    }

    private class ShutDown
    extends Thread {
        private ShutDown() {
        }

        public void run() {
            OptionalPluginWrapper addon = JDUtilities.getOptionalPlugin((String)"unrar");
            if (addon != null && addon.isEnabled()) {
                Object obj;
                while (!((obj = addon.getPlugin().interact("isWorking", null)) == null || obj instanceof Boolean && obj.equals(false))) {
                    logger.info("JD-Unrar is working - wait before shutting down");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        JDLogger.exception((Throwable)e);
                    }
                }
            }
            int ret = JDShutdown.this.getPluginConfig().getIntegerProperty(JDShutdown.CONFIG_MODE, 0);
            switch (ret) {
                case 0: {
                    logger.info("ask user about shutdown");
                    String message = JDL.L((String)"interaction.shutdown.dialog.msg.shutdown", (String)"<h2><font color=\"red\">System will be shut down!</font></h2>");
                    UserIO.setCountdownTime((int)60);
                    int ret2 = UserIO.getInstance().requestConfirmDialog(128, JDL.L((String)"interaction.shutdown.dialog.title.shutdown", (String)"Shutdown?"), message, UserIO.getInstance().getIcon(1), null, null);
                    UserIO.setCountdownTime((int)-1);
                    logger.info("Return code: " + ret2);
                    if (!JDFlags.hasSomeFlags((int)ret2, (int[])new int[]{2, 32})) break;
                    JDShutdown.this.shutdown();
                    break;
                }
                case 1: {
                    logger.info("ask user about standby");
                    String message = JDL.L((String)"interaction.shutdown.dialog.msg.standby", (String)"<h2><font color=\"red\">System will be put into standby mode!</font></h2>");
                    UserIO.setCountdownTime((int)60);
                    int ret2 = UserIO.getInstance().requestConfirmDialog(128, JDL.L((String)"interaction.shutdown.dialog.title.standby", (String)"Standby?"), message, UserIO.getInstance().getIcon(1), null, null);
                    UserIO.setCountdownTime((int)-1);
                    logger.info("Return code: " + ret2);
                    if (!JDFlags.hasSomeFlags((int)ret2, (int[])new int[]{2, 32})) break;
                    JDShutdown.this.standby();
                    break;
                }
                case 2: {
                    logger.info("ask user about hibernate");
                    String message = JDL.L((String)"interaction.shutdown.dialog.msg.hibernate", (String)"<h2><font color=\"red\">System will be put into hibernate mode!</font></h2>");
                    UserIO.setCountdownTime((int)60);
                    int ret2 = UserIO.getInstance().requestConfirmDialog(128, JDL.L((String)"interaction.shutdown.dialog.title.hibernate", (String)"Hibernate?"), message, UserIO.getInstance().getIcon(1), null, null);
                    UserIO.setCountdownTime((int)-1);
                    logger.info("Return code: " + ret2);
                    if (!JDFlags.hasSomeFlags((int)ret2, (int[])new int[]{2, 32})) break;
                    JDShutdown.this.hibernate();
                    break;
                }
                case 3: {
                    logger.info("ask user about closing");
                    String message = JDL.L((String)"interaction.shutdown.dialog.msg.closejd", (String)"<h2><font color=\"red\">JDownloader will be closed!</font></h2>");
                    UserIO.setCountdownTime((int)60);
                    int ret2 = UserIO.getInstance().requestConfirmDialog(128, JDL.L((String)"interaction.shutdown.dialog.title.closejd", (String)"Close JD?"), message, UserIO.getInstance().getIcon(1), null, null);
                    UserIO.setCountdownTime((int)-1);
                    logger.info("Return code: " + ret2);
                    if (!JDFlags.hasSomeFlags((int)ret2, (int[])new int[]{2, 32})) break;
                    JDShutdown.this.closejd();
                    break;
                }
            }
        }
    }
}

