/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.action;

import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import jd.config.Property;
import jd.controlling.JDLogger;
import jd.utils.JDTheme;

public abstract class JDAction
extends AbstractAction {
    private static final long serialVersionUID = -2332356042161170120L;
    public static final String IMAGE_KEY = "IMAGE_KEY";
    private ActionListener actionListener;
    private int actionID = -1;
    private Property properties;

    public void setActionID(int actionID) {
        this.actionID = actionID;
    }

    public JDAction(String title, int actionID) {
        super(title);
        this.actionID = actionID;
    }

    public JDAction(String l, ImageIcon ii) {
        super(l, ii);
    }

    public JDAction(String l) {
        this(l, -1);
    }

    public void setIcon(String key) {
        if (key.length() < 3) {
            return;
        }
        this.putValue("SmallIcon", JDTheme.II((String)key, (int)16, (int)16));
        this.putValue("SwingLargeIconKey", JDTheme.II((String)key, (int)24, (int)24));
        this.putValue(IMAGE_KEY, key);
    }

    public void setMnemonic(String key) {
        char mnemonic = key.charAt(0);
        if (mnemonic != '\u0000' && !key.contentEquals("-")) {
            Class<KeyEvent> b = KeyEvent.class;
            try {
                Field f = b.getField("VK_" + Character.toUpperCase(mnemonic));
                int m = (Integer)f.get(null);
                this.putValue("MnemonicKey", m);
                this.putValue("SwingDisplayedMnemonicIndexKey", this.getTitle().indexOf(m));
            }
            catch (Exception e) {
                JDLogger.exception((Throwable)e);
            }
        }
    }

    public String getTooltipText() {
        try {
            return this.getValue("ShortDescription").toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public KeyStroke getKeyStroke() {
        Object ret = this.getValue("AcceleratorKey");
        if (ret != null) {
            return (KeyStroke)ret;
        }
        return null;
    }

    public void setAccelerator(String accelerator) {
        String org = accelerator;
        if (accelerator != null && accelerator.length() > 0 && !accelerator.equals("-")) {
            Class<KeyEvent> b = KeyEvent.class;
            if (accelerator.contains("+")) {
                accelerator = accelerator.substring(accelerator.lastIndexOf("+") + 1);
            }
            try {
                Field f = b.getField("VK_" + accelerator.toUpperCase());
                int m = (Integer)f.get(null);
                KeyStroke ks = KeyStroke.getKeyStroke(m, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
                this.putValue("AcceleratorKey", ks);
                JDLogger.getLogger().finest(String.valueOf(this.getTitle()) + " Shortcuts: mapped " + org + " to " + ks);
            }
            catch (Exception e) {
                KeyStroke ks = KeyStroke.getKeyStroke((int)accelerator.charAt(accelerator.length() - 1), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
                this.putValue("AcceleratorKey", ks);
                JDLogger.getLogger().finest(String.valueOf(this.getTitle()) + "Shortcuts: mapped " + org + " to " + ks);
            }
        }
    }

    public int getActionID() {
        return this.actionID;
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public String getTitle() {
        return (String)this.getValue("Name");
    }

    public boolean isSelected() {
        Object value = this.getValue("SwingSelectedKey");
        if (value == null) {
            return false;
        }
        return (Boolean)value;
    }

    public JDAction setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
        return this;
    }

    public void setSelected(boolean selected) {
        this.putValue("SwingSelectedKey", selected);
    }

    public JDAction setTitle(String title) {
        this.putValue("Name", title);
        return this;
    }

    public JDAction setIcon(ImageIcon ii) {
        this.putValue("SmallIcon", ii);
        return this;
    }

    public ImageIcon getIcon() {
        return (ImageIcon)this.getValue("SmallIcon");
    }

    public void setProperty(String string, Object value) {
        if (this.properties == null) {
            this.properties = new Property();
        }
        this.firePropertyChange(string, this.getProperty(string), value);
        this.properties.setProperty(string, value);
    }

    public Object getProperty(String string) {
        if (this.properties == null) {
            this.properties = new Property();
        }
        return this.properties.getProperty(string);
    }
}

