/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing;

import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.HashMap;
import javax.swing.KeyStroke;
import jd.utils.locale.JDL;

public class ShortCuts {
    private static final String JDL_PREFIX = "jd.gui.swing.ShortCuts.";

    public static String getAcceleratorString(KeyStroke ks) {
        if (ks == null) {
            return null;
        }
        if (ks.getKeyCode() == 0) {
            return String.valueOf(ShortCuts.getModifiersText(ks.getModifiers())) + "+" + ks.getKeyChar();
        }
        return String.valueOf(ShortCuts.getModifiersText(ks.getModifiers())) + "+" + ShortCuts.getVKText(ks.getKeyCode());
    }

    public static String getModifiersText(int modifiers) {
        StringBuffer buf = new StringBuffer();
        if ((modifiers & 0x40) != 0) {
            buf.append(String.valueOf(JDL.L((String)"jd.gui.swing.ShortCuts.key.shift", (String)"shift")));
        }
        if ((modifiers & 0x80) != 0) {
            buf.append(String.valueOf(JDL.L((String)"jd.gui.swing.ShortCuts.key.ctrl", (String)"ctrl")));
        }
        if ((modifiers & 0x100) != 0) {
            buf.append(String.valueOf(JDL.L((String)"jd.gui.swing.ShortCuts.key.meta", (String)"meta")));
        }
        if ((modifiers & 0x200) != 0) {
            buf.append(String.valueOf(JDL.L((String)"jd.gui.swing.ShortCuts.key.alt", (String)"alt")));
        }
        if ((modifiers & 0x2000) != 0) {
            buf.append(String.valueOf(JDL.L((String)"jd.gui.swing.ShortCuts.key.altGr", (String)"alt Gr")));
        }
        if ((modifiers & 0x400) != 0) {
            buf.append(String.valueOf(JDL.L((String)"jd.gui.swing.ShortCuts.key.button1", (String)"button1")));
        }
        if ((modifiers & 0x800) != 0) {
            buf.append(String.valueOf(JDL.L((String)"jd.gui.swing.ShortCuts.key.button2", (String)"button2")));
        }
        if ((modifiers & 0x1000) != 0) {
            buf.append(String.valueOf(JDL.L((String)"jd.gui.swing.ShortCuts.key.button3", (String)"button3")));
        }
        return buf.toString();
    }

    private static String getVKText(int keyCode) {
        int expected_modifiers = 25;
        Field[] fields = KeyEvent.class.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            block4: {
                try {
                    if (fields[i].getModifiers() == expected_modifiers && fields[i].getType() == Integer.TYPE && fields[i].getName().startsWith("VK_") && fields[i].getInt(KeyEvent.class) == keyCode) {
                        return JDL.L((String)(JDL_PREFIX + fields[i].getName()), (String)fields[i].getName().substring(3));
                    }
                }
                catch (IllegalAccessException e) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
            ++i;
        }
        return "UNKNOWN";
    }

    static class VKCollection {
        HashMap<Integer, String> code2name = new HashMap();
        HashMap<String, Integer> name2code = new HashMap();

        public synchronized void put(String name, Integer code) {
            assert (name != null && code != null);
            assert (this.findName(code) == null);
            assert (this.findCode(name) == null);
            this.code2name.put(code, name);
            this.name2code.put(name, code);
        }

        public synchronized Integer findCode(String name) {
            assert (name != null);
            return this.name2code.get(name);
        }

        public synchronized String findName(Integer code) {
            assert (code != null);
            return this.code2name.get(code);
        }
    }
}

