/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import jd.HostPluginWrapper;
import jd.controlling.AccountController;
import jd.gui.swing.dialog.AbstractDialog;
import jd.gui.swing.jdgui.actions.ActionController;
import jd.gui.swing.jdgui.settings.JDLabelListRenderer;
import jd.nutils.JDFlags;
import jd.plugins.Account;
import jd.plugins.PluginForHost;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class AccountDialog
extends AbstractDialog {
    private static final long serialVersionUID = -2099080199110932990L;
    private static final String JDL_PREFIX = "jd.gui.swing.components.AccountDialog.";
    private JComboBox hoster;
    private JButton link;
    private JTextField name;
    private JPasswordField pass;
    private PluginForHost plugin;

    public static void showDialog(PluginForHost pluginForHost) {
        AccountDialog dialog = new AccountDialog(pluginForHost);
        if (JDFlags.hasAllFlags((int)dialog.getReturnValue(), (int[])new int[]{2})) {
            Account ac = new Account(dialog.getUsername(), dialog.getPassword());
            AccountController.getInstance().addAccount(dialog.getHoster().getPlugin(), ac);
        }
    }

    public AccountDialog(PluginForHost pluginForHost) {
        super(4, JDL.L((String)"jd.gui.swing.components.AccountDialog.title", (String)"Add new Account"), JDTheme.II((String)"gui.images.premium", (int)16, (int)16), null, null);
        this.plugin = pluginForHost;
        this.init();
    }

    public JComponent contentInit() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("ins 0, wrap 2"));
        panel.add(new JLabel(JDL.L((String)"jd.gui.swing.components.AccountDialog.hoster", (String)"Hoster:")));
        ArrayList plugins = JDUtilities.getPremiumPluginsForHost();
        Collections.sort(plugins, new Comparator<HostPluginWrapper>(){

            @Override
            public int compare(HostPluginWrapper a, HostPluginWrapper b) {
                return a.getHost().compareToIgnoreCase(b.getHost());
            }
        });
        HostPluginWrapper[] array = plugins.toArray(new HostPluginWrapper[plugins.size()]);
        this.hoster = new JComboBox<HostPluginWrapper>(array);
        panel.add(this.hoster, "w 200!");
        if (this.plugin != null) {
            try {
                this.hoster.setSelectedItem(this.plugin.getWrapper());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.hoster.setRenderer(new JDLabelListRenderer());
        panel.add(new JLabel());
        this.link = new JButton(ActionController.getToolBarAction("action.premium.buy"));
        panel.add((Component)this.link, "w 200!");
        this.link.setIcon(JDTheme.II((String)"gui.images.buy", (int)16, (int)16));
        panel.add(new JLabel(JDL.L((String)"jd.gui.swing.components.AccountDialog.name", (String)"Name:")));
        this.name = new JTextField();
        panel.add((Component)this.name, "w 200!");
        panel.add(new JLabel(JDL.L((String)"jd.gui.swing.components.AccountDialog.pass", (String)"Pass:")));
        this.pass = new JPasswordField();
        panel.add((Component)this.pass, "w 200!");
        return panel;
    }

    public HostPluginWrapper getHoster() {
        return (HostPluginWrapper)this.hoster.getSelectedItem();
    }

    public String getUsername() {
        return this.name.getText();
    }

    public String getPassword() {
        return new String(this.pass.getPassword());
    }
}

