/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import jd.config.SubConfiguration;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.components.JDFileChooser;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBrowseFile
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -3852915099917640687L;
    private Object LOCK = new Object();
    private ArrayList<ActionListener> listenerList = new ArrayList();
    private String approveButtonText;
    private JButton btnBrowse;
    private JComboBox cmboInput;
    private File currentPath;
    private Vector<String> files;
    private int fileSelectionMode = 0;
    private FileFilter fileFilter;
    private boolean dispatchingDisabled = false;

    public ComboBrowseFile(String string) {
        Vector list = (Vector)SubConfiguration.getConfig((String)"GUI").getGenericProperty(string, new Vector());
        this.setFiles(list);
        this.setName(string);
        this.initGUI();
    }

    public ComboBrowseFile(Vector<String> files) {
        if (files == null) {
            files = new Vector();
        }
        this.setFiles(files);
        this.initGUI();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block5: {
            block4: {
                if (e.getSource() != this.cmboInput) break block4;
                Object sel = this.cmboInput.getSelectedItem();
                if (sel != null) {
                    this.setCurrentPath(new File(sel.toString()));
                }
                if (this.dispatchingDisabled) break block5;
                for (ActionListener l : this.listenerList) {
                    l.actionPerformed(new ActionEvent(this, e.getID(), e.getActionCommand()));
                }
                break block5;
            }
            if (e.getSource() == this.btnBrowse) {
                this.setCurrentPath(this.getPath());
                for (ActionListener l : this.listenerList) {
                    l.actionPerformed(new ActionEvent(this, e.getID(), e.getActionCommand()));
                }
            }
        }
    }

    public String getApproveButtonText() {
        return this.approveButtonText;
    }

    public File getCurrentPath() {
        return this.currentPath;
    }

    private File getDirectoryFromTxtInput() {
        File directory = null;
        Object sel = this.cmboInput.getSelectedItem();
        if (sel != null) {
            directory = new File(sel.toString());
            if (directory.exists()) {
                if (directory.isFile()) {
                    directory = directory.getParentFile();
                }
            } else {
                directory = null;
            }
        }
        return directory;
    }

    public boolean getEditable() {
        return this.cmboInput.isEditable();
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    private File getPath() {
        JDFileChooser fc = new JDFileChooser();
        if (this.approveButtonText != null) {
            fc.setApproveButtonText(this.approveButtonText);
        }
        fc.setFileSelectionMode(this.fileSelectionMode);
        if (this.fileFilter != null) {
            fc.setFileFilter(this.fileFilter);
        }
        fc.setCurrentDirectory(this.getDirectoryFromTxtInput());
        if (fc.showOpenDialog(this) == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    public String getText() {
        if (this.cmboInput.getSelectedItem() == null) {
            return "";
        }
        return this.cmboInput.getSelectedItem().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initGUI() {
        this.setLayout((LayoutManager)new MigLayout("insets 0", "[left, grow]15px[]", ""));
        this.cmboInput = new JComboBox(this.files){
            private static final long serialVersionUID = 5288948184335860046L;

            public Dimension getMaximumSize() {
                return new Dimension(20, 20);
            }

            public Dimension getMinimumSize() {
                return new Dimension(20, 20);
            }

            public Dimension getPreferredSize() {
                return new Dimension(20, 20);
            }
        };
        this.cmboInput.setEditable(false);
        this.cmboInput.addActionListener(this);
        if (this.cmboInput.getItemCount() > 0) {
            Object object = this.LOCK;
            synchronized (object) {
                this.dispatchingDisabled = true;
                this.cmboInput.setSelectedIndex(0);
                this.dispatchingDisabled = false;
            }
        }
        this.btnBrowse = new JButton(JDL.L((String)"gui.btn_select", (String)"Ausw\u00e4hlen"));
        this.btnBrowse.addActionListener(this);
        this.add((Component)this.cmboInput, "grow");
        this.add((Component)this.btnBrowse, "wrap");
    }

    public JButton getButton() {
        return this.btnBrowse;
    }

    public JComboBox getInput() {
        return this.cmboInput;
    }

    public void setApproveButtonText(String approveButtonText) {
        this.approveButtonText = approveButtonText;
    }

    public void setButtonText(String text) {
        this.btnBrowse.setText(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentPath(File currentPath) {
        if (currentPath == null || currentPath.equals(this.currentPath)) {
            return;
        }
        this.currentPath = currentPath;
        String item = currentPath.toString();
        this.files.remove(item);
        this.files.add(0, item);
        SubConfiguration.getConfig((String)"GUI").setProperty(this.getName(), new Vector<String>(this.files.subList(0, Math.min(this.files.size(), 20))));
        SubConfiguration.getConfig((String)"GUI").save();
        if (this.getText() != null && this.getText().equalsIgnoreCase(currentPath.toString())) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.dispatchingDisabled = true;
            this.cmboInput.setSelectedIndex(0);
            this.dispatchingDisabled = false;
        }
    }

    public void setEditable(final boolean value) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ComboBrowseFile.this.cmboInput.setEditable(value);
            }
        });
    }

    @Override
    public void setEnabled(final boolean value) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ComboBrowseFile.this.cmboInput.setEnabled(value);
                ComboBrowseFile.this.btnBrowse.setEnabled(value);
            }
        });
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
        int i = this.files.size() - 1;
        while (i >= 0) {
            if (!fileFilter.accept(new File(this.files.get(i)))) {
                this.files.remove(i);
            }
            --i;
        }
    }

    private void setFiles(Vector<String> files) {
        int i = files.size() - 1;
        while (i >= 0) {
            if (!new File(files.get(i)).exists()) {
                files.remove(i);
            }
            --i;
        }
        this.files = files;
    }

    public void setFileSelectionMode(int fileSelectionMode) {
        block5: {
            block4: {
                this.fileSelectionMode = fileSelectionMode;
                if (fileSelectionMode != 1) break block4;
                int i = this.files.size() - 1;
                while (i >= 0) {
                    if (!new File(this.files.get(i)).isDirectory()) {
                        this.files.remove(i);
                    }
                    --i;
                }
                break block5;
            }
            if (fileSelectionMode != 0) break block5;
            int i = this.files.size() - 1;
            while (i >= 0) {
                if (!new File(this.files.get(i)).isFile()) {
                    this.files.remove(i);
                }
                --i;
            }
        }
    }

    public void setText(final String text) {
        new GuiRunnable<Object>(){

            @Override
            public Object runSave() {
                if (text == null) {
                    ComboBrowseFile.this.setCurrentPath(new File(""));
                } else {
                    ComboBrowseFile.this.setCurrentPath(new File(text));
                }
                return null;
            }
        }.start();
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(l);
    }
}

