/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.dialog.AbstractDialog;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertDialog
extends AbstractDialog {
    private static final long serialVersionUID = -9146764850581039090L;
    private static boolean forcekeep = false;
    private static ArrayList<ConversionMode> keeped = new ArrayList();
    private static ArrayList<ConversionMode> keeped_availablemodes = new ArrayList();
    private static boolean keepformat = false;
    private ArrayList<ConversionMode> modes;
    private JCheckBox chkKeepFormat;
    private JCheckBox chkForceKeep;
    private JCheckBox chkTopPriority;
    private JComboBox cmbModes;

    public static ConversionMode displayDialog(final ArrayList<ConversionMode> modes, final String name) {
        if (modes.size() == 0) {
            return null;
        }
        if (modes.size() == 1) {
            return modes.get(0);
        }
        if (keepformat) {
            int i;
            boolean newFormatChoosable = false;
            if (!forcekeep) {
                i = 0;
                while (i < modes.size()) {
                    if (!keeped_availablemodes.contains((Object)modes.get(i))) {
                        newFormatChoosable = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!newFormatChoosable) {
                i = 0;
                while (i < keeped.size()) {
                    if (modes.contains((Object)keeped.get(i))) {
                        return keeped.get(i);
                    }
                    ++i;
                }
            }
        }
        GuiRunnable<ConversionMode> run = new GuiRunnable<ConversionMode>(){

            @Override
            public ConversionMode runSave() {
                return new ConvertDialog(modes, name, null).getReturnMode();
            }
        };
        return (ConversionMode)((Object)run.getReturnValue());
    }

    private static void setKeepformat(boolean newkeepformat) {
        if (!newkeepformat) {
            keepformat = false;
            ConvertDialog.setForceKeep(false);
            keeped_availablemodes = new ArrayList();
            keeped = new ArrayList();
        } else {
            keepformat = true;
        }
    }

    private static void setForceKeep(boolean newforcekeep) {
        forcekeep = newforcekeep;
    }

    private static boolean hasKeeped() {
        if (keepformat) {
            return !keeped.isEmpty();
        }
        return false;
    }

    private static void addKeeped(ConversionMode FormatToAdd, ArrayList<ConversionMode> FormatsInList, boolean TopPriority) {
        keepformat = true;
        if (TopPriority) {
            keeped.add(0, FormatToAdd);
        } else {
            keeped.add(FormatToAdd);
        }
        int i = 0;
        while (i < FormatsInList.size()) {
            if (!keeped_availablemodes.contains((Object)FormatsInList.get(i))) {
                keeped_availablemodes.add(FormatsInList.get(i));
            }
            ++i;
        }
    }

    public static ArrayList<ConversionMode> getKeeped() {
        return keeped;
    }

    private ConvertDialog(ArrayList<ConversionMode> modes, String name) {
        super(4, String.valueOf(JDL.L((String)"convert.dialog.chooseformat", (String)"W\u00e4hle das Dateiformat:")) + " [" + name + "]", UserIO.getInstance().getIcon(3), null, null);
        this.modes = modes;
        this.init();
    }

    @Override
    public JComponent contentInit() {
        this.chkKeepFormat = new JCheckBox(ConvertDialog.hasKeeped() ? JDL.L((String)"convert.dialog.staykeepingformat", (String)"Formate weiterhin beibehalten") : JDL.L((String)"convert.dialog.keepformat", (String)"Format f\u00fcr diese Sitzung beibehalten"));
        this.chkKeepFormat.setSelected(ConvertDialog.hasKeeped());
        this.chkForceKeep = new JCheckBox(JDL.L((String)"convert.dialog.forcekeep", (String)"Beibehalten erzwingen"));
        this.chkForceKeep.setSelected(forcekeep);
        this.chkTopPriority = new JCheckBox(JDL.L((String)"convert.dialog.toppriority", (String)"Diese Auswahl vorherigen immer vorziehen"));
        this.cmbModes = new JComboBox<ConversionMode>(this.modes.toArray(new ConversionMode[this.modes.size()]));
        this.cmbModes.setSelectedIndex(0);
        JPanel panel = new JPanel((LayoutManager)new MigLayout("ins 0"));
        if (ConvertDialog.hasKeeped()) {
            panel.add(this.chkTopPriority);
        }
        panel.add(this.chkKeepFormat);
        panel.add((Component)this.chkForceKeep, "wrap");
        panel.add((Component)this.cmbModes, "spanx");
        return panel;
    }

    private ConversionMode getReturnMode() {
        if (!UserIO.isOK(this.getReturnValue())) {
            return null;
        }
        ConversionMode selectedValue = (ConversionMode)((Object)this.cmbModes.getSelectedItem());
        if (this.chkKeepFormat.isSelected() || this.chkForceKeep.isSelected()) {
            ConvertDialog.setKeepformat(true);
            ConvertDialog.addKeeped(selectedValue, this.modes, this.chkTopPriority.isSelected());
            ConvertDialog.setForceKeep(this.chkForceKeep.isSelected());
        } else {
            ConvertDialog.setKeepformat(false);
        }
        return selectedValue;
    }

    /* synthetic */ ConvertDialog(ArrayList arrayList, String string, ConvertDialog convertDialog) {
        this(arrayList, string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConversionMode {
        AUDIOMP3("Audio (MP3)", new String[]{".mp3"}),
        VIDEOFLV("Video (FLV)", new String[]{".flv"}),
        AUDIOMP3_AND_VIDEOFLV("Audio & Video (MP3 & FLV)", new String[]{".mp3", ".flv"}),
        VIDEOMP4("Video (MP4)", new String[]{".mp4"}),
        VIDEO3GP("Video (3GP)", new String[]{".3gp"}),
        VIDEOPODCAST("Video (MP4-Podcast)", new String[]{".mp4"}),
        VIDEOIPHONE("Video (iPhone)", new String[]{".mp4"});

        private String text;
        private String[] ext;

        private ConversionMode(String text, String[] ext) {
            this.text = text;
            this.ext = ext;
        }

        public String toString() {
            return this.text;
        }

        public String getText() {
            return this.text;
        }

        public String getExtFirst() {
            return this.ext[0];
        }
    }
}

