/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jd.controlling.reconnect.HTTPLiveHeader;
import jd.gui.UserIO;
import jd.gui.swing.Factory;
import jd.gui.swing.dialog.AbstractDialog;
import jd.nutils.encoding.Encoding;
import jd.utils.JDTheme;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class ImportRouterDialog
extends AbstractDialog {
    private static final long serialVersionUID = 2043825047691368115L;
    private ArrayList<String[]> scripts = HTTPLiveHeader.getLHScripts();
    private JList list;

    public static String[] showDialog() {
        ImportRouterDialog dialog = new ImportRouterDialog();
        if (UserIO.isOK(dialog.getReturnValue())) {
            return dialog.getResult();
        }
        return null;
    }

    private ImportRouterDialog() {
        super(4, JDL.L((String)"gui.config.liveHeader.dialog.importRouter", (String)"Router importieren"), JDTheme.II((String)"gui.images.search", (int)32, (int)32), null, null);
        Collections.sort(this.scripts, new Comparator<String[]>(){

            @Override
            public int compare(String[] a, String[] b) {
                return (String.valueOf(a[0]) + " " + a[1]).compareToIgnoreCase(String.valueOf(b[0]) + " " + b[1]);
            }
        });
        this.init();
    }

    public String[] getResult() {
        String selected = this.list.getSelectedValue().toString();
        int id = Integer.parseInt(selected.split("\\.")[0]);
        return this.scripts.get(id);
    }

    public JComponent contentInit() {
        HashMap<String, Boolean> ch = new HashMap<String, Boolean>();
        int i = this.scripts.size() - 1;
        while (i >= 0) {
            if (ch.containsKey(String.valueOf(this.scripts.get(i)[0]) + this.scripts.get(i)[1] + this.scripts.get(i)[2])) {
                this.scripts.remove(i);
            } else {
                ch.put(String.valueOf(this.scripts.get(i)[0]) + this.scripts.get(i)[1] + this.scripts.get(i)[2], true);
            }
            --i;
        }
        final String[] d = new String[this.scripts.size()];
        int i2 = 0;
        while (i2 < d.length) {
            d[i2] = String.valueOf(i2) + ". " + Encoding.htmlDecode((String)(String.valueOf(this.scripts.get(i2)[0]) + " : " + this.scripts.get(i2)[1]));
            ++i2;
        }
        JPanel panel = new JPanel((LayoutManager)new MigLayout("ins 10,wrap 3", "[grow 30,fill]5[grow 0,fill]10[grow,fill,300!]", "[fill]5[]5[fill,grow]"));
        final DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        final String text = JDL.L((String)"gui.config.reconnect.selectrouter", (String)"Search Router Model");
        final JTextField searchField = new JTextField();
        this.list = new JList(defaultListModel);
        searchField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                this.refreshList();
            }

            private void refreshList() {
                String search = searchField.getText().toLowerCase();
                String[] hits = search.split(" ");
                defaultListModel.removeAllElements();
                int i = 0;
                while (i < d.length) {
                    int j = 0;
                    while (j < hits.length) {
                        if (!d[i].toLowerCase().contains(hits[j])) break;
                        if (j == hits.length - 1) {
                            defaultListModel.addElement(d[i]);
                        }
                        ++j;
                    }
                    ++i;
                }
                ImportRouterDialog.this.list.setModel(defaultListModel);
            }

            public void removeUpdate(DocumentEvent e) {
                this.refreshList();
            }
        });
        searchField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (searchField.getText().equals(text)) {
                    searchField.setText("");
                }
            }

            public void focusLost(FocusEvent e) {
                if (searchField.getText().equals("")) {
                    searchField.setText(text);
                    String[] stringArray = d;
                    int n = d.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String element = stringArray[n2];
                        defaultListModel.addElement(element);
                        ++n2;
                    }
                }
            }
        });
        final JTextArea preview = new JTextArea();
        preview.setFocusable(true);
        JButton reset = Factory.createButton(null, JDTheme.II((String)"gui.images.undo", (int)16, (int)16), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                searchField.setForeground(Color.lightGray);
                searchField.setText(text);
                preview.setText("");
                String[] stringArray = d;
                int n = d.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    defaultListModel.addElement(element);
                    ++n2;
                }
            }
        });
        reset.setBorder(null);
        searchField.setText(text);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                String selected = (String)ImportRouterDialog.this.list.getSelectedValue();
                if (selected != null) {
                    int id = Integer.parseInt(selected.split("\\.")[0]);
                    String[] data = (String[])ImportRouterDialog.this.scripts.get(id);
                    preview.setText(data[2]);
                }
            }
        });
        JLabel example = new JLabel(JDL.L((String)"gui.config.reconnect.selectrouter.example", (String)"Example: 3Com ADSL"));
        String[] stringArray = d;
        int n = d.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            defaultListModel.addElement(element);
            ++n2;
        }
        panel.add(searchField);
        panel.add(reset);
        panel.add((Component)new JScrollPane(preview), "spany");
        panel.add((Component)example, "spanx 2");
        panel.add((Component)new JScrollPane(this.list), "spanx 2");
        return panel;
    }

    protected void packed() {
        this.setMinimumSize(new Dimension(700, 500));
    }
}

