/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import jd.config.ConfigPropertyListener;
import jd.config.Property;
import jd.config.SubConfiguration;
import jd.controlling.DownloadWatchDog;
import jd.event.ControlListener;
import jd.gui.swing.jdgui.GUIUtils;
import jd.nutils.Formatter;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public class SpeedMeterPanel
extends JPanel
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 5571694800446993879L;
    private int i = 0;
    private int[] cache;
    private transient Thread th;
    private int window = GUIUtils.getConfig().getIntegerProperty("PARAM_SHOW_SPEEDMETER_WINDOWSIZE", 60);
    private boolean show = GUIUtils.getConfig().getBooleanProperty("PARAM_SHOW_SPEEDMETER", true);
    private static final int CAPACITY = 40;
    private float opacity = 0.0f;
    private float fadeSteps = 0.1f;
    private Timer fadeTimer;

    public SpeedMeterPanel() {
        this.cache = new int[40];
        int x = 0;
        while (x < 40) {
            this.cache[x] = 0;
            ++x;
        }
        this.setOpaque(false);
        this.setBorder(this.show ? BorderFactory.createEtchedBorder() : null);
        this.addMouseListener(this);
        JDUtilities.getController().addControlListener((ControlListener)new ConfigPropertyListener(new String[]{"DOWNLOAD_MAX_SPEED_V2", "PARAM_SHOW_SPEEDMETER_WINDOWSIZE", "PARAM_SHOW_SPEEDMETER"}){

            public void onPropertyChanged(Property source, String key) {
                if (key == null) {
                    return;
                }
                if (key.equalsIgnoreCase("DOWNLOAD_MAX_SPEED_V2")) {
                    SpeedMeterPanel.this.update();
                } else if (key.equalsIgnoreCase("PARAM_SHOW_SPEEDMETER_WINDOWSIZE")) {
                    SpeedMeterPanel.this.window = GUIUtils.getConfig().getIntegerProperty("PARAM_SHOW_SPEEDMETER_WINDOWSIZE", 60);
                } else if (key.equalsIgnoreCase("PARAM_SHOW_SPEEDMETER")) {
                    SpeedMeterPanel.this.show = GUIUtils.getConfig().getBooleanProperty("PARAM_SHOW_SPEEDMETER", true);
                    SpeedMeterPanel.this.setBorder(SpeedMeterPanel.this.show ? BorderFactory.createEtchedBorder() : null);
                }
            }
        });
    }

    public void start() {
        if (this.th != null) {
            return;
        }
        this.th = new Thread("Speedmeter updater"){

            public void run() {
                while (!this.isInterrupted()) {
                    SpeedMeterPanel.this.update();
                    try {
                        Thread.sleep(SpeedMeterPanel.this.window * 1000 / 40);
                        ((SpeedMeterPanel)SpeedMeterPanel.this).cache[((SpeedMeterPanel)SpeedMeterPanel.this).i] = JDUtilities.getController().getSpeedMeter();
                        SpeedMeterPanel speedMeterPanel = SpeedMeterPanel.this;
                        speedMeterPanel.i = speedMeterPanel.i + 1;
                        SpeedMeterPanel speedMeterPanel2 = SpeedMeterPanel.this;
                        speedMeterPanel2.i = speedMeterPanel2.i % SpeedMeterPanel.this.cache.length;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        };
        this.th.start();
        if (this.show) {
            this.fadeIn();
        }
    }

    public void stop() {
        if (!this.show) {
            return;
        }
        if (this.th != null) {
            this.th.interrupt();
            this.th = null;
        }
        if (this.show) {
            this.fadeOut();
        }
    }

    public synchronized void update() {
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        if (!this.show) {
            super.paintComponent(g);
            return;
        }
        ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, this.opacity));
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(1.0f));
        Color col1 = new Color(8181282);
        Color col2 = new Color(0x339933);
        int id = this.i;
        int limit = SubConfiguration.getConfig((String)"DOWNLOAD").getIntegerProperty("DOWNLOAD_MAX_SPEED_V2", 0) * 1024;
        int max = Math.max(10, limit);
        int[] nArray = this.cache;
        int n = this.cache.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            max = Math.max(element, max);
            ++n2;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        Polygon poly = new Polygon();
        poly.addPoint(0, height);
        int x = 0;
        while (x < 40) {
            poly.addPoint(x * width / 39, height - (int)((double)(height * this.cache[id]) * 0.9) / max);
            ++id;
            id %= this.cache.length;
            ++x;
        }
        poly.addPoint(width, height);
        ((Graphics2D)g).setPaint(new GradientPaint(width / 2, 0.0f, col1, width / 2, height, col2.darker()));
        g2.fill(poly);
        FontUIResource f = (FontUIResource)UIManager.getDefaults().get("Panel.font");
        g2.setFont(f);
        String txt = String.valueOf(Formatter.formatReadable((long)JDUtilities.getController().getSpeedMeter())) + "/s";
        FontMetrics fmetrics = g2.getFontMetrics();
        int len = fmetrics.stringWidth(txt);
        Color fontCol = this.getForeground();
        if (limit > 0) {
            int limitpx = height - (int)((double)(height * limit) * 0.9) / max;
            g2.setColor(Color.RED);
            g2.drawLine(0, limitpx, width, limitpx);
            if (limitpx > height / 2) {
                g2.drawString(String.valueOf(DownloadWatchDog.getInstance().isPaused() ? String.valueOf(JDL.L((String)"gui.speedmeter.pause", (String)"pause")) + " " : "") + Formatter.formatReadable((long)limit) + "/s", 5, limitpx - 4);
                g2.setColor(fontCol);
                g2.drawString(String.valueOf(Formatter.formatReadable((long)JDUtilities.getController().getSpeedMeter())) + "/s", width - len - 5, limitpx - 4);
            } else {
                g2.drawString(String.valueOf(DownloadWatchDog.getInstance().isPaused() ? String.valueOf(JDL.L((String)"gui.speedmeter.pause", (String)"pause")) + " " : "") + Formatter.formatReadable((long)limit) + "/s", 5, limitpx + 12);
                g2.setColor(fontCol);
                g2.drawString(String.valueOf(Formatter.formatReadable((long)JDUtilities.getController().getSpeedMeter())) + "/s", width - len - 5, limitpx + 12);
            }
        } else {
            g2.setColor(fontCol);
            g2.drawString(String.valueOf(Formatter.formatReadable((long)JDUtilities.getController().getSpeedMeter())) + "/s", width - len - 5, 12);
        }
    }

    public void fadeIn() {
        if (this.fadeTimer != null) {
            this.fadeTimer.stop();
            this.fadeTimer = null;
        }
        this.setVisible(true);
        this.fadeSteps = 0.1f;
        this.fadeTimer = new Timer(75, this);
        this.fadeTimer.setInitialDelay(0);
        this.fadeTimer.start();
    }

    public void fadeOut() {
        if (this.fadeTimer != null) {
            this.fadeTimer.stop();
            this.fadeTimer = null;
        }
        this.fadeSteps = -0.1f;
        this.fadeTimer = new Timer(75, this);
        this.fadeTimer.setInitialDelay(0);
        this.fadeTimer.start();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.fadeTimer) {
            this.opacity += this.fadeSteps;
            if (this.opacity > 1.0f) {
                this.opacity = 1.0f;
                this.fadeTimer.stop();
                this.fadeTimer = null;
            } else if (this.opacity < 0.0f) {
                this.opacity = 0.0f;
                this.fadeTimer.stop();
                this.fadeTimer = null;
            }
            this.update();
        } else if (e.getSource() instanceof JMenuItem) {
            GUIUtils.getConfig().setProperty("PARAM_SHOW_SPEEDMETER", (Object)(!this.show ? 1 : 0));
            GUIUtils.getConfig().save();
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger() || e.getButton() == 3) {
            if (DownloadWatchDog.getInstance().getDownloadStatus() != DownloadWatchDog.STATE.RUNNING) {
                return;
            }
            JMenuItem mi = new JMenuItem(this.show ? JDL.L((String)"gui.speedmeter.hide", (String)"Hide Speedmeter") : JDL.L((String)"gui.speedmeter.show", (String)"Show Speedmeter"));
            mi.addActionListener(this);
            JPopupMenu popup = new JPopupMenu();
            popup.add(mi);
            popup.show(this, e.getPoint().x, e.getPoint().y);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

