/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JEditorPane;
import jd.controlling.JDLogger;

class WebBrowserPane
extends JEditorPane {
    private static final long serialVersionUID = 1L;
    private ArrayList<URL> history = new ArrayList();
    private int historyIndex;

    public WebBrowserPane() {
        this.setEditable(false);
    }

    public URL back() {
        --this.historyIndex;
        if (this.historyIndex < 0) {
            this.historyIndex = 0;
        }
        URL url = this.history.get(this.historyIndex);
        this.displayPage(url);
        return url;
    }

    private void displayPage(URL pageURL) {
        try {
            this.setPage(pageURL);
        }
        catch (IOException ioException) {
            JDLogger.exception((Throwable)ioException);
        }
    }

    public URL forward() {
        ++this.historyIndex;
        if (this.historyIndex >= this.history.size()) {
            this.historyIndex = this.history.size() - 1;
        }
        URL url = this.history.get(this.historyIndex);
        this.displayPage(url);
        return url;
    }

    public void goToURL(URL url) {
        this.displayPage(url);
        this.history.add(url);
        this.historyIndex = this.history.size() - 1;
    }
}

