/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jd.controlling.JDLogger;
import jd.gui.swing.components.WebBrowserPane;

class WebToolBar
extends JToolBar
implements HyperlinkListener {
    private static final long serialVersionUID = 1L;
    private JButton backButton;
    private JButton forwardButton;
    public JTextField urlTextField;
    private WebBrowserPane webBrowserPane;

    public WebToolBar(WebBrowserPane browser) {
        super("Web Navigation");
        this.webBrowserPane = browser;
        this.webBrowserPane.addHyperlinkListener(this);
        this.urlTextField = new JTextField(25);
        this.urlTextField.setEditable(true);
        this.urlTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    URL url = new URL(WebToolBar.this.urlTextField.getText());
                    WebToolBar.this.webBrowserPane.goToURL(url);
                }
                catch (MalformedURLException urlException) {
                    JDLogger.exception((Throwable)urlException);
                }
            }
        });
        this.backButton = new JButton("back");
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                URL url = WebToolBar.this.webBrowserPane.back();
                WebToolBar.this.urlTextField.setText(url.toString());
            }
        });
        this.forwardButton = new JButton("forward");
        this.forwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                URL url = WebToolBar.this.webBrowserPane.forward();
                WebToolBar.this.urlTextField.setText(url.toString());
            }
        });
        this.add(this.backButton);
        this.add(this.forwardButton);
        this.add(this.urlTextField);
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL url = event.getURL();
            this.webBrowserPane.goToURL(url);
            this.urlTextField.setText(url.toString());
        }
    }
}

