/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components.linkbutton;

import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.event.JDBroadcaster;
import jd.event.JDEvent;
import jd.gui.swing.components.linkbutton.JLinkButtonEditor;
import jd.gui.swing.components.linkbutton.JLinkButtonRenderer;
import jd.gui.swing.jdgui.interfaces.JDMouseAdapter;
import jd.nutils.Executer;
import jd.nutils.nativeintegration.LocalBrowser;
import jd.parser.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JLink
extends JLabel {
    private static final long serialVersionUID = 1L;
    public static final int CLICKED = 0;
    private URL url;
    private transient JDBroadcaster<ActionListener, JDEvent> broadcaster;

    public static JLinkButtonEditor getJLinkButtonEditor() {
        return new JLinkButtonEditor();
    }

    public static JLinkButtonRenderer getJLinkButtonRenderer() {
        return new JLinkButtonRenderer();
    }

    public static void openURL(String url) throws Exception {
        if (url == null) {
            return;
        }
        JLink.openURL(new URL(url));
    }

    public static void openURL(URL url) throws Exception {
        if (url == null) {
            return;
        }
        SubConfiguration cfg = SubConfiguration.getConfig((String)"jdgui");
        if (cfg.getBooleanProperty("PARAM_CUSTOM_ROWSER_USE", false).booleanValue()) {
            Executer exec = new Executer(cfg.getStringProperty("CUSTOM_ROWSER"));
            exec.setLogger(JDLogger.getLogger());
            String params = cfg.getStringProperty("PARAM_CUSTOM_ROWSER_PARAM").replace("%url", "" + url);
            exec.addParameters(Regex.getLines((String)params));
            exec.start();
            exec.setWaitTimeout(1);
            exec.waitTimeout();
            if (exec.getException() != null) {
                throw exec.getException();
            }
        } else {
            String browser = SubConfiguration.getConfig((String)"jdgui").getStringProperty("BROWSER2", null);
            LocalBrowser.openURL((String)browser, (URL)url);
        }
    }

    public JLink() {
        this(null, null, null);
    }

    public JLink(Icon icon) {
        this(null, icon, null);
    }

    public JLink(Icon icon, URL url) {
        this(null, icon, url);
    }

    public JLink(String s) {
        this(s, null, null);
    }

    public JLink(String text, String urlstr) {
        super(text);
        URL url = null;
        try {
            url = new URL(urlstr);
        }
        catch (Exception e) {
            this.setEnabled(false);
        }
        this.init(text, url);
    }

    public JLink(String s, URL url) {
        this(s, null, url);
    }

    public JLink(URL url) {
        this(null, null, url);
    }

    public JLink(String text, Icon icon, URL url) {
        super(text);
        this.setIcon(icon);
        this.init(text, url);
    }

    private void initBroadcaster() {
        this.broadcaster = new JDBroadcaster<ActionListener, JDEvent>(){

            protected void fireEvent(ActionListener listener, JDEvent event) {
                listener.actionPerformed(new ActionEvent(JLink.this, 0, JLink.this.getText()));
            }
        };
    }

    public JDBroadcaster<ActionListener, JDEvent> getBroadcaster() {
        if (this.broadcaster == null) {
            this.initBroadcaster();
        }
        return this.broadcaster;
    }

    private void init(String text, URL url) {
        if (url == null && text != null) {
            if (text.matches("https?://.*")) {
                try {
                    url = new URL(text);
                }
                catch (MalformedURLException e1) {
                    JDLogger.exception((Throwable)e1);
                }
            } else if (text.matches("www\\..*?\\..*")) {
                try {
                    url = new URL("http://" + text);
                }
                catch (MalformedURLException e1) {
                    JDLogger.exception((Throwable)e1);
                }
            }
        }
        if (text == null && url != null) {
            this.setText(url.toExternalForm());
        }
        this.setUrl(url);
        this.setBackground(null);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new JDMouseAdapter(){
            private Font originalFont;

            public void mouseEntered(MouseEvent evt) {
                this.originalFont = JLink.this.getFont();
                if (JLink.this.isEnabled()) {
                    Map<TextAttribute, ?> attributes = this.originalFont.getAttributes();
                    attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                    JLink.this.setFont(this.originalFont.deriveFont(attributes));
                }
            }

            public void mouseExited(MouseEvent evt) {
                JLink.this.setFont(this.originalFont);
            }

            public void mouseClicked(MouseEvent e) {
                try {
                    if (JLink.this.getUrl() != null) {
                        JLink.openURL(JLink.this.getUrl());
                    }
                    JLink.this.getBroadcaster().fireEvent(null);
                }
                catch (Exception e1) {
                    JDLogger.exception((Throwable)e1);
                }
            }
        });
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
        if (url != null) {
            this.setToolTipText(url.toExternalForm());
        }
    }

    public static HyperlinkListener getHyperlinkListener() {
        return new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        JLink.openURL(e.getURL());
                    }
                    catch (Exception e1) {
                        JDLogger.exception((Throwable)e1);
                    }
                }
            }
        };
    }
}

