/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import jd.config.SubConfiguration;
import jd.gui.UserIO;
import jd.gui.swing.SwingGui;
import jd.gui.swing.dialog.JCountdownDialog;
import jd.gui.swing.jdgui.interfaces.JDMouseAdapter;
import jd.gui.userio.DummyFrame;
import jd.nutils.JDFlags;
import jd.nutils.Screen;
import jd.nutils.encoding.Encoding;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public abstract class AbstractDialog
extends JCountdownDialog
implements ActionListener {
    private static final long serialVersionUID = -169149552591067268L;
    public static final String DIALOGS_CONFIG = "DIALOGS";
    protected JButton btnCancel;
    protected JButton btnOK;
    protected JComponent contentpane;
    protected static Color BACKGROUND_COLOR = new Color(15395287);
    private static Dimension DEFAULT_DIMENSION;
    protected int flag;
    private int returnValue = 0;
    private ImageIcon icon;
    private String okOption;
    private String cancelOption;
    private JCheckBox dont;
    private JLabel dontlabel;
    private JPanel buttonBar;

    public AbstractDialog(int flag, String title, ImageIcon icon, String okOption, String cancelOption) {
        super(DummyFrame.getDialogParent());
        this.flag = flag;
        this.setTitle(title);
        this.icon = JDFlags.hasAllFlags((int)flag, (int[])new int[]{256}) ? null : icon;
        this.okOption = okOption == null ? JDL.L((String)"gui.btn_ok", (String)"Ok") : okOption;
        this.cancelOption = cancelOption == null ? JDL.L((String)"gui.btn_cancel", (String)"Cancel") : cancelOption;
    }

    public void init() {
        SubConfiguration cfg;
        Object value;
        if (JDFlags.hasAllFlags((int)this.flag, (int[])new int[]{32}) && (value = (cfg = SubConfiguration.getConfig((String)DIALOGS_CONFIG)).getProperty(this.getDontShowAgainKey())) != null && value instanceof Integer) {
            int i = (Integer)value;
            int ret = i & 6 | 8 | 0x10;
            if (!(JDFlags.hasAllFlags((int)this.flag, (int[])new int[]{512}) && JDFlags.hasAllFlags((int)ret, (int[])new int[]{4}) || JDFlags.hasAllFlags((int)this.flag, (int[])new int[]{1024}) && JDFlags.hasAllFlags((int)ret, (int[])new int[]{2}))) {
                this.returnValue = ret;
                return;
            }
        }
        this.setModal(true);
        this.setLayout((LayoutManager)new MigLayout("ins 5", "[fill,grow]", "[fill,grow][]"));
        this.setDefaultCloseOperation(2);
        this.buttonBar = new JPanel((LayoutManager)new MigLayout("ins 0", "[fill,grow]", "[fill,grow]"));
        JButton focus = this.btnOK = new JButton(this.okOption);
        this.btnOK.addActionListener(this);
        this.btnCancel = new JButton(this.cancelOption);
        this.btnCancel.addActionListener(this);
        if (this.icon != null) {
            this.add((Component)new JLabel(this.icon), "split 2,alignx left,aligny center,shrinkx,gapright 10");
        }
        this.contentpane = this.contentInit();
        this.add((Component)this.contentpane, "pushx,growx,pushy,growy,spanx,aligny center,wrap");
        this.add((Component)this.countDownLabel, "split 3,growx");
        if ((this.flag & 0x20) > 0) {
            this.dont = new JCheckBox();
            this.dont.setHorizontalAlignment(11);
            this.dontlabel = new JLabel(JDL.L((String)"gui.dialogs.dontshowthisagain", (String)"Don't show this again"));
            this.add(this.dontlabel);
            this.add((Component)this.dont, "alignx right");
        }
        this.add((Component)this.buttonBar, "alignx right");
        if ((this.flag & 8) == 0) {
            this.getRootPane().setDefaultButton(this.btnOK);
            this.btnOK.addHierarchyListener(new HierarchyListener(){

                public void hierarchyChanged(HierarchyEvent e) {
                    JButton defaultButton;
                    JRootPane root;
                    if ((e.getChangeFlags() & 1L) != 0L && (root = SwingUtilities.getRootPane(defaultButton = (JButton)e.getComponent())) != null) {
                        root.setDefaultButton(defaultButton);
                    }
                }
            });
            focus = this.btnOK;
            this.buttonBar.add((Component)this.btnOK, "alignx right,tag ok,sizegroup confirms");
        }
        if ((this.flag & 0x10) == 0) {
            this.buttonBar.add((Component)this.btnCancel, "alignx right,tag cancel,sizegroup confirms");
            if ((this.flag & 8) != 0) {
                this.getRootPane().setDefaultButton(this.btnCancel);
                this.btnCancel.requestFocusInWindow();
                focus = this.btnCancel;
            }
        }
        this.addButtons(this.buttonBar);
        this.setMinimumSize(new Dimension(300, -1));
        if (JDFlags.hasNoFlags((int)this.flag, (int[])new int[]{4})) {
            this.countdown(UserIO.getCountdownTime());
        } else {
            this.countDownLabel.setVisible(false);
        }
        if (this.dont != null) {
            this.btnOK.addMouseListener(new JDMouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    if (JDFlags.hasAllFlags((int)AbstractDialog.this.flag, (int[])new int[]{1024})) {
                        AbstractDialog.this.dont.setEnabled(false);
                        AbstractDialog.this.dontlabel.setEnabled(false);
                    }
                }

                public void mouseExited(MouseEvent e) {
                    AbstractDialog.this.dont.setEnabled(true);
                    AbstractDialog.this.dontlabel.setEnabled(true);
                }
            });
            this.btnCancel.addMouseListener(new JDMouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    if (JDFlags.hasAllFlags((int)AbstractDialog.this.flag, (int[])new int[]{512})) {
                        AbstractDialog.this.dont.setEnabled(false);
                        AbstractDialog.this.dontlabel.setEnabled(false);
                    }
                }

                public void mouseExited(MouseEvent e) {
                    AbstractDialog.this.dont.setEnabled(true);
                    AbstractDialog.this.dontlabel.setEnabled(true);
                }
            });
        }
        this.invalidate();
        this.pack();
        this.setResizable(true);
        this.toFront();
        this.setMinimumSize(this.getPreferredSize());
        if (DEFAULT_DIMENSION != null) {
            this.setSize(DEFAULT_DIMENSION);
        }
        if (SwingGui.getInstance() == null) {
            this.setLocation(Screen.getCenterOfComponent(null, (Component)this));
        } else if (SwingGui.getInstance().getMainFrame().getExtendedState() == 1 || !SwingGui.getInstance().getMainFrame().isVisible()) {
            this.setLocation(Screen.getDockBottomRight((Component)this));
        } else {
            this.setLocation(Screen.getCenterOfComponent((Component)SwingGui.getInstance().getMainFrame(), (Component)this));
        }
        KeyStroke ks = KeyStroke.getKeyStroke("ESCAPE");
        focus.getInputMap().put(ks, "ESCAPE");
        focus.getInputMap(1).put(ks, "ESCAPE");
        focus.getInputMap(2).put(ks, "ESCAPE");
        focus.getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = -4143073679291503041L;

            public void actionPerformed(ActionEvent e) {
                AbstractDialog.this.dispose();
            }
        });
        focus.requestFocus();
        this.packed();
        this.setVisible(true);
        DummyFrame.getDialogParent().setAlwaysOnTop(true);
        DummyFrame.getDialogParent().setAlwaysOnTop(false);
    }

    protected void addButtons(JPanel buttonBar) {
    }

    protected String getDontShowAgainKey() {
        return "DONT_SHOW_AGAIN_" + this.toString();
    }

    protected void packed() {
    }

    public String toString() {
        return Encoding.filterString((String)("dialog-" + this.getTitle())).replaceAll("\\d", "");
    }

    public abstract JComponent contentInit();

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnOK) {
            this.setReturnValue(true);
        } else if (e.getSource() == this.btnCancel) {
            this.setReturnValue(false);
        }
        this.dispose();
    }

    protected void onCountdown() {
        this.setReturnValue(false);
        this.returnValue |= 0x20;
        this.dispose();
    }

    protected void setReturnValue(boolean b) {
        int n = this.returnValue = b ? 2 : 4;
        if (JDFlags.hasAllFlags((int)this.flag, (int[])new int[]{32}) && this.dont.isSelected() && this.dont.isEnabled()) {
            this.returnValue |= 8;
            SubConfiguration cfg = SubConfiguration.getConfig((String)DIALOGS_CONFIG);
            cfg.setProperty(this.getDontShowAgainKey(), (Object)this.returnValue);
            cfg.save();
        }
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public static void setDefaultDimension(Dimension dimension) {
        DEFAULT_DIMENSION = dimension;
    }

    public static Dimension getDefaultDimension() {
        return DEFAULT_DIMENSION;
    }

    public static void resetDialogInformations() {
        SubConfiguration.getConfig((String)DIALOGS_CONFIG).getProperties().clear();
        SubConfiguration.getConfig((String)DIALOGS_CONFIG).save();
    }
}

