/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.JFrame;
import jd.config.SubConfiguration;
import jd.gui.swing.SwingGui;
import jd.nutils.Screen;

public class GUIUtils {
    public static Dimension getLastDimension(Component child, String key) {
        if (key == null) {
            key = child.getName();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = screenSize.width;
        int height = screenSize.height;
        SubConfiguration cfg = GUIUtils.getConfig();
        Object loc = cfg.getProperty("DIMENSION_OF_" + key);
        if (loc != null && loc instanceof Dimension) {
            Dimension dim = (Dimension)loc;
            if (dim.width > width) {
                dim.width = width;
            }
            if (dim.height > height) {
                dim.height = height;
            }
            return dim;
        }
        return null;
    }

    public static SubConfiguration getConfig() {
        return SubConfiguration.getConfig((String)"jdgui");
    }

    public static Point getLastLocation(Component parent, String key, Component child) {
        if (key == null) {
            key = child.getName();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = screenSize.width;
        int height = screenSize.height;
        Object loc = GUIUtils.getConfig().getProperty("LOCATION_OF_" + key);
        if (loc != null && loc instanceof Point) {
            Point point = (Point)loc;
            if (point.x < 0) {
                point.x = 0;
            }
            if (point.y < 0) {
                point.y = 0;
            }
            if (point.x > width) {
                point.x = width;
            }
            if (point.y > height) {
                point.y = height;
            }
            return point;
        }
        return Screen.getCenterOfComponent((Component)parent, (Component)child);
    }

    public static void restoreWindow(JFrame parent, Component component) {
        if (parent == null) {
            parent = SwingGui.getInstance().getMainFrame();
        }
        component.setLocation(GUIUtils.getLastLocation(parent, null, component));
        Dimension dim = GUIUtils.getLastDimension(component, null);
        if (dim != null) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            dim.width = Math.min(dim.width, screenSize.width);
            dim.height = Math.min(dim.height, screenSize.height);
            component.setSize(dim);
            if (component instanceof JFrame) {
                ((JFrame)component).setExtendedState(GUIUtils.getConfig().getIntegerProperty("MAXIMIZED_STATE_OF_" + component.getName(), 0));
            }
        } else {
            component.validate();
        }
    }

    public static void saveLastDimension(Component child, String key) {
        if (GUIUtils.getConfig() == null) {
            return;
        }
        if (key == null) {
            key = child.getName();
        }
        boolean max = false;
        if (child instanceof JFrame) {
            GUIUtils.getConfig().setProperty("MAXIMIZED_STATE_OF_" + key, (Object)((JFrame)child).getExtendedState());
            if (((JFrame)child).getExtendedState() != 0) {
                max = true;
            }
        }
        if (!max) {
            GUIUtils.getConfig().setProperty("DIMENSION_OF_" + key, (Object)child.getSize());
        }
        GUIUtils.getConfig().save();
    }

    public static void saveLastLocation(Component parent, String key) {
        if (GUIUtils.getConfig() == null) {
            return;
        }
        if (key == null) {
            key = parent.getName();
        }
        if (parent instanceof JFrame && ((JFrame)parent).getExtendedState() != 0) {
            return;
        }
        if (parent.isShowing()) {
            GUIUtils.getConfig().setProperty("LOCATION_OF_" + key, (Object)parent.getLocationOnScreen());
            GUIUtils.getConfig().save();
        }
    }
}

