/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.actions;

import java.awt.event.ActionEvent;
import jd.gui.action.JDAction;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.jdgui.actions.ActionController;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public abstract class ToolBarAction
extends JDAction {
    protected boolean inited = false;
    private static final long serialVersionUID = -7856598906795360922L;
    public static final String PRIORITY = "PRIORITY";
    public static final String ID = "ID";
    private Types type = Types.NORMAL;

    public void setType(Types type) {
        if (type == Types.TOGGLE && this.getValue("SwingSelectedKey") == null) {
            super.setSelected(false);
        }
        this.type = type;
    }

    public void setId(String id) {
        this.putValue(ID, id);
    }

    public void setPriority(int priority) {
        this.putValue(PRIORITY, priority);
    }

    public ToolBarAction(String menukey, int id) {
        this(menukey, null, id);
    }

    public ToolBarAction(String menukey, String iconkey) {
        this(menukey, iconkey, -1);
    }

    public ToolBarAction(String menukey, String iconkey, int id) {
        super(JDL.L((String)("gui.menu." + menukey + ".name"), (String)menukey));
        this.setId(menukey);
        this.setActionID(id);
        if (iconkey != null) {
            this.setIcon(iconkey);
        }
        this.setMnemonic(JDL.L((String)("gui.menu." + menukey + ".mnem"), (String)"-"));
        this.setAccelerator(JDL.L((String)("gui.menu." + menukey + ".accel"), (String)"-"));
        this.setToolTipText(JDL.L((String)("gui.menu." + menukey + ".tooltip"), (String)menukey));
        this.initDefaults();
        ActionController.register(this);
    }

    protected ToolBarAction() {
        super("");
    }

    public final void actionPerformed(ActionEvent e) {
        if (this.type == Types.TOGGLE && JDUtilities.getJavaVersion() < 1.6) {
            this.setSelected(!this.isSelected());
        }
        if (this.getActionListener() == null) {
            this.onAction(e);
            return;
        }
        this.getActionListener().actionPerformed(new ActionEvent(this, this.getActionID(), this.getTitle()));
    }

    public void setSelected(final boolean selected) {
        new GuiRunnable<Object>(){

            @Override
            public Object runSave() {
                ToolBarAction.this.setSelectedInternal(selected);
                return null;
            }
        }.start();
    }

    private void setSelectedInternal(boolean selected) {
        super.setSelected(selected);
        this.setType(Types.TOGGLE);
    }

    public void onAction(ActionEvent e) {
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ToolBarAction)) {
            return false;
        }
        if (this.getID() == null) {
            return false;
        }
        return this.getID().equals(((ToolBarAction)o).getID());
    }

    public abstract void initDefaults();

    public abstract void init();

    public void setToolTipText(String tt) {
        this.putValue("ShortDescription", tt);
    }

    public String getID() {
        if (this.getValue(ID) == null) {
            return null;
        }
        return this.getValue(ID).toString();
    }

    public Types getType() {
        return this.type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Types {
        TOGGLE,
        NORMAL,
        SEPARATOR,
        CONTAINER;

    }
}

