/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.menu;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JMenuItem;
import jd.OptionalPluginWrapper;
import jd.gui.UserIF;
import jd.gui.swing.SwingGui;
import jd.gui.swing.jdgui.actions.ToolBarAction;
import jd.gui.swing.jdgui.menu.JStartMenu;
import jd.gui.swing.jdgui.menu.MenuAction;
import jd.gui.swing.menu.Menu;
import jd.utils.JDTheme;

public class AddonsMenu
extends JStartMenu {
    private static final long serialVersionUID = 1019851981865519325L;
    private static AddonsMenu INSTANCE = null;

    private AddonsMenu() {
        super("gui.menu.addons", "gui.images.config.addons");
        this.updateMenu();
    }

    public void update() {
        this.removeAll();
        this.updateMenu();
    }

    public static AddonsMenu getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AddonsMenu();
        }
        return INSTANCE;
    }

    private void updateMenu() {
        ToolBarAction cfg = new ToolBarAction("addonsMenu.configuration", 9999){
            private static final long serialVersionUID = -3613887193435347389L;

            public void onAction(ActionEvent e) {
                SwingGui.getInstance().requestPanel(UserIF.Panels.ADDON_MANAGER, null);
            }

            public void init() {
            }

            public void initDefaults() {
            }
        };
        cfg.setIcon(JDTheme.II((String)"gui.images.config.packagemanager", (int)16, (int)16));
        this.add(cfg);
        ArrayList<JMenuItem> itemsWithSubmenu = new ArrayList<JMenuItem>();
        ArrayList<JMenuItem> itemsToggle = new ArrayList<JMenuItem>();
        ArrayList<JMenuItem> itemsPress = new ArrayList<JMenuItem>();
        ArrayList<JMenuItem> itemsConfig = new ArrayList<JMenuItem>();
        ArrayList pluginsOptional = new ArrayList(OptionalPluginWrapper.getOptionalWrapper());
        Collections.sort(pluginsOptional);
        for (OptionalPluginWrapper plg : pluginsOptional) {
            if (!plg.isLoaded() || !plg.isEnabled()) continue;
            boolean config = false;
            ArrayList<MenuAction> mis = plg.getPlugin().createMenuitems();
            if (mis == null && plg.getPlugin().getConfig() != null && plg.getPlugin().getConfig().getEntries().size() > 0) {
                mis = new ArrayList<MenuAction>();
                config = true;
            }
            if (mis == null) continue;
            if (mis.size() > 1) {
                MenuAction m = new MenuAction(plg.getID(), 0);
                m.setTitle(plg.getHost());
                m.setIcon(JDTheme.II((String)plg.getPlugin().getIconKey(), (int)16, (int)16));
                m.setItems(mis);
                JMenuItem mi = Menu.getJMenuItem(m);
                if (mi != null) {
                    mi.setIcon(m.getIcon());
                    itemsWithSubmenu.add(mi);
                    continue;
                }
                this.addSeparator();
                continue;
            }
            Iterator iterator = mis.iterator();
            if (!iterator.hasNext()) continue;
            MenuAction mi = (MenuAction)iterator.next();
            JMenuItem c = Menu.getJMenuItem(mi);
            c.setDisabledIcon(null);
            c.setIcon(JDTheme.II((String)plg.getPlugin().getIconKey(), (int)16, (int)16));
            c.setSelectedIcon(JDTheme.II((String)plg.getPlugin().getIconKey(), (int)16, (int)16));
            c.setDisabledSelectedIcon(null);
            if (mi.getType() == ToolBarAction.Types.TOGGLE) {
                itemsToggle.add(c);
                continue;
            }
            if (config) {
                itemsConfig.add(c);
                continue;
            }
            itemsPress.add(c);
        }
        boolean c = itemsConfig.size() > 0;
        boolean p = itemsPress.size() > 0;
        boolean t = itemsToggle.size() > 0;
        boolean pre = false;
        for (JMenuItem jmi : itemsWithSubmenu) {
            if (!pre) {
                this.addSeparator();
            }
            this.add(jmi);
            pre = true;
        }
        if (pre && (c || p || t)) {
            this.addSeparator();
        }
        pre = false;
        for (JMenuItem jmi : itemsConfig) {
            this.add(jmi);
            pre = true;
        }
        if (pre && (p || t)) {
            this.addSeparator();
        }
        pre = false;
        for (JMenuItem jmi : itemsPress) {
            this.add(jmi);
            pre = true;
        }
        pre = false;
        if (pre && t) {
            this.addSeparator();
        }
        for (JMenuItem jmi : itemsToggle) {
            this.add(jmi);
        }
    }
}

