/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jd.config.ConfigEntry;
import jd.config.container.JDLabelContainer;
import jd.controlling.JDLogger;
import jd.gui.swing.components.BrowseFile;
import jd.gui.swing.components.JDTextArea;
import jd.gui.swing.components.JDTextField;
import jd.gui.swing.components.linkbutton.JLink;
import jd.gui.swing.jdgui.settings.JDLabelListRenderer;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class GUIConfigEntry
implements ActionListener,
ChangeListener,
PropertyChangeListener,
DocumentListener {
    private static final long serialVersionUID = -1391952049282528582L;
    private ConfigEntry configEntry;
    private JComponent[] input;
    private JComponent decoration;
    private Logger logger = JDLogger.getLogger();

    /*
     * Unable to fully structure code
     */
    public GUIConfigEntry(ConfigEntry cfg) {
        super();
        this.configEntry = cfg;
        cfg.setGuiListener((PropertyChangeListener)this);
        this.input = new JComponent[1];
        switch (this.configEntry.getType()) {
            case 12: {
                try {
                    this.input[0] = new JLink(this.configEntry.getLabel(), new URL(this.configEntry.getPropertyName()));
                }
                catch (MalformedURLException e) {
                    this.input[0] = new JLabel(this.configEntry.getPropertyName());
                    JDLogger.exception((Throwable)e);
                }
                this.input[0].setEnabled(this.configEntry.isEnabled());
                break;
            }
            case 11: {
                this.decoration = new JLabel(this.configEntry.getLabel());
                this.input[0] = new JPasswordField();
                doc = ((JPasswordField)this.input[0]).getDocument();
                doc.addDocumentListener(this);
                this.input[0].setEnabled(this.configEntry.isEnabled());
                ((JPasswordField)this.input[0]).setHorizontalAlignment(4);
                break;
            }
            case 0: {
                this.decoration = new JLabel(this.configEntry.getLabel());
                this.input[0] = new JDTextField();
                doc = ((JDTextField)this.input[0]).getDocument();
                doc.addDocumentListener(this);
                this.input[0].setEnabled(this.configEntry.isEnabled());
                ((JDTextField)this.input[0]).setHorizontalAlignment(4);
                break;
            }
            case 10: 
            case 110: {
                this.decoration = new JLabel(this.configEntry.getLabel());
                this.input[0] = new JDTextArea();
                this.input[0].setEnabled(this.configEntry.isEnabled());
                doc = ((JDTextArea)this.input[0]).getDocument();
                doc.addDocumentListener(this);
                break;
            }
            case 3: {
                this.input[0] = new JCheckBox();
                this.input[0].setEnabled(this.configEntry.isEnabled());
                ((JCheckBox)this.input[0]).addChangeListener(this);
                this.decoration = new JLabel(this.configEntry.getLabel());
                break;
            }
            case 7: {
                if (this.configEntry.getLabel().trim().length() > 0) {
                    this.decoration = new JLabel(this.configEntry.getLabel());
                }
                this.input[0] = new BrowseFile();
                ((BrowseFile)this.input[0]).setEnabled(this.configEntry.isEnabled());
                ((BrowseFile)this.input[0]).setEditable(true);
                break;
            }
            case 9: {
                if (this.configEntry.getLabel().trim().length() > 0) {
                    this.decoration = new JLabel(this.configEntry.getLabel());
                }
                this.input[0] = new BrowseFile();
                ((BrowseFile)this.input[0]).setEditable(true);
                ((BrowseFile)this.input[0]).setEnabled(this.configEntry.isEnabled());
                ((BrowseFile)this.input[0]).setFileSelectionMode(1);
                break;
            }
            case 8: {
                this.decoration = new JLabel(this.configEntry.getLabel());
                this.input[0] = new JSpinner(new SpinnerNumberModel(this.configEntry.getStart(), this.configEntry.getStart(), this.configEntry.getEnd(), this.configEntry.getStep()));
                this.input[0].setEnabled(this.configEntry.isEnabled());
                ((JSpinner)this.input[0]).addChangeListener(this);
                break;
            }
            case 2: {
                this.decoration = new JLabel(this.configEntry.getDescription());
                this.input[0] = new JButton(this.configEntry.getLabel());
                if (this.configEntry.getImageIcon() != null) {
                    ((JButton)this.input[0]).setIcon(this.configEntry.getImageIcon());
                }
                ((JButton)this.input[0]).addActionListener(this);
                ((JButton)this.input[0]).addActionListener(this.configEntry.getActionListener());
                this.input[0].setEnabled(this.configEntry.isEnabled());
                break;
            }
            case 1: 
            case 15: {
                this.decoration = new JLabel(this.configEntry.getLabel());
                this.input[0] = new JComboBox<Object>(this.configEntry.getList());
                if (this.configEntry.getList().length > 0 && this.configEntry.getList()[0] instanceof JDLabelContainer) {
                    ((JComboBox)this.input[0]).setRenderer(new JDLabelListRenderer());
                    ((JComboBox)this.input[0]).setMaximumRowCount(10);
                }
                ((JComboBox)this.input[0]).addActionListener(this);
                if (!(this.configEntry.getPropertyInstance().getProperty(this.configEntry.getPropertyName()) instanceof String)) ** GOTO lbl91
                i = 0;
                while (i < this.configEntry.getList().length) {
                    if (!this.configEntry.getList()[i].toString().equals(this.configEntry.getPropertyInstance().getStringProperty(this.configEntry.getPropertyName()))) ** GOTO lbl88
                    ((JComboBox)this.input[0]).setSelectedIndex(i);
                    ** GOTO lbl98
lbl88:
                    // 1 sources

                    ++i;
                }
                ** GOTO lbl98
lbl91:
                // 1 sources

                i = 0;
                while (i < this.configEntry.getList().length) {
                    if (!this.configEntry.getList()[i].equals(this.configEntry.getPropertyInstance().getProperty(this.configEntry.getPropertyName()))) ** GOTO lbl96
                    ((JComboBox)this.input[0]).setSelectedIndex(i);
                    break;
lbl96:
                    // 1 sources

                    ++i;
                }
lbl98:
                // 4 sources

                this.input[0].setEnabled(this.configEntry.isEnabled());
                break;
            }
            case 5: {
                this.decoration = new JLabel(this.configEntry.getLabel());
                this.input = new JComponent[1];
                this.input[0] = new JPanel((LayoutManager)new MigLayout("ins 0", "", ""));
                group = new ButtonGroup();
                i = 0;
                while (i < this.configEntry.getList().length) {
                    radio = new JRadioButton(this.configEntry.getList()[i].toString());
                    radio.setActionCommand(this.configEntry.getList()[i].toString());
                    this.input[0].add(radio);
                    radio.setEnabled(this.configEntry.isEnabled());
                    radio.addActionListener(this);
                    group.add(radio);
                    p = this.configEntry.getPropertyInstance().getProperty(this.configEntry.getPropertyName());
                    if (p == null) {
                        p = "";
                    }
                    if (this.configEntry.getList()[i].toString().equals(p.toString())) {
                        radio.setSelected(true);
                    }
                    ++i;
                }
                break;
            }
            case 4: {
                this.input = new JComponent[0];
                this.decoration = new JLabel(this.configEntry.getLabel());
                break;
            }
            case 6: {
                this.input = new JComponent[0];
                this.decoration = new JSeparator(0);
            }
        }
        if (this.configEntry.getHelptags() != null) {
            tooltip = JDL.LF((String)"gui.tooltips.quickhelp", (String)"Quickhelp available: %s (ctrl+shift+CLICK)", (Object[])new Object[]{this.configEntry.getHelptags()});
            if (this.decoration != null) {
                this.decoration.setName(this.configEntry.getHelptags());
                this.decoration.setToolTipText(tooltip);
            }
            var6_10 = this.input;
            var5_9 = this.input.length;
            var4_8 = 0;
            while (var4_8 < var5_9) {
                c = var6_10[var4_8];
                if (c != null) {
                    c.setToolTipText(tooltip);
                    c.setName(this.configEntry.getHelptags());
                }
                ++var4_8;
            }
        }
    }

    public JComponent[] getInput() {
        return this.input;
    }

    public void actionPerformed(ActionEvent e) {
        this.getConfigEntry().valueChanged(this.getText());
    }

    public void changedUpdate(DocumentEvent e) {
        this.getConfigEntry().valueChanged(this.getText());
    }

    public ConfigEntry getConfigEntry() {
        return this.configEntry;
    }

    public Object getText() {
        switch (this.configEntry.getType()) {
            case 12: {
                return ((JLink)this.input[0]).getUrl().toString();
            }
            case 11: {
                return new String(((JPasswordField)this.input[0]).getPassword());
            }
            case 0: {
                return ((JDTextField)this.input[0]).getText();
            }
            case 10: {
                return ((JDTextArea)this.input[0]).getText();
            }
            case 3: {
                return ((JCheckBox)this.input[0]).isSelected();
            }
            case 110: {
                return ((JDTextArea)this.input[0]).getText();
            }
            case 2: {
                return null;
            }
            case 1: {
                return ((JComboBox)this.input[0]).getSelectedItem();
            }
            case 15: {
                return ((JComboBox)this.input[0]).getSelectedIndex();
            }
            case 4: {
                return null;
            }
            case 5: {
                Component[] inputs;
                Component[] componentArray = inputs = this.input[0].getComponents();
                int n = inputs.length;
                int n2 = 0;
                while (n2 < n) {
                    Component element = componentArray[n2];
                    JRadioButton radio = (JRadioButton)element;
                    if (radio.getSelectedObjects() != null && radio.getSelectedObjects()[0] != null) {
                        return radio.getSelectedObjects()[0];
                    }
                    ++n2;
                }
                return null;
            }
            case 6: {
                return null;
            }
            case 7: 
            case 9: {
                return ((BrowseFile)this.input[0]).getText();
            }
            case 8: {
                return ((JSpinner)this.input[0]).getValue();
            }
        }
        return null;
    }

    public void insertUpdate(DocumentEvent e) {
        this.getConfigEntry().valueChanged(this.getText());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.input[0] == null) {
            return;
        }
        boolean state = this.getConfigEntry().isConditionalEnabled(evt);
        JComponent[] jComponentArray = this.input;
        int n = this.input.length;
        int n2 = 0;
        while (n2 < n) {
            JComponent i = jComponentArray[n2];
            if (i != null) {
                i.setEnabled(state);
                if (i.getComponents() != null) {
                    Component[] componentArray = i.getComponents();
                    int n3 = componentArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Component c = componentArray[n4];
                        c.setEnabled(state);
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    public JComponent getDecoration() {
        return this.decoration;
    }

    public void removeUpdate(DocumentEvent e) {
        this.getConfigEntry().valueChanged(this.getText());
    }

    public void setConfigEntry(ConfigEntry configEntry) {
        this.configEntry = configEntry;
    }

    public void setData(Object text) {
        if (text == null && this.configEntry.getDefaultValue() != null) {
            text = this.configEntry.getDefaultValue();
        }
        switch (this.configEntry.getType()) {
            case 12: {
                try {
                    ((JLink)this.input[0]).setUrl(new URL(text == null ? "" : text.toString()));
                }
                catch (MalformedURLException e1) {
                    JDLogger.exception((Throwable)e1);
                }
                break;
            }
            case 11: {
                ((JPasswordField)this.input[0]).setText(text == null ? "" : text.toString());
                break;
            }
            case 0: {
                ((JDTextField)this.input[0]).setText(text == null ? "" : text.toString());
                break;
            }
            case 110: {
                ((JDTextArea)this.input[0]).setText(text == null ? "" : text.toString());
                break;
            }
            case 10: {
                ((JDTextArea)this.input[0]).setText(text == null ? "" : text.toString());
                break;
            }
            case 3: {
                if (text == null) {
                    text = false;
                }
                try {
                    ((JCheckBox)this.input[0]).setSelected((Boolean)text);
                }
                catch (Exception e) {
                    this.logger.severe("Falcher Wert: " + text);
                    ((JCheckBox)this.input[0]).setSelected(false);
                }
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                ((JComboBox)this.input[0]).setSelectedItem(text);
                break;
            }
            case 15: {
                if (text instanceof Integer) {
                    ((JComboBox)this.input[0]).setSelectedIndex((Integer)text);
                    break;
                }
                ((JComboBox)this.input[0]).setSelectedItem(text);
                break;
            }
            case 4: {
                break;
            }
            case 7: 
            case 9: {
                ((BrowseFile)this.input[0]).setText(text == null ? "" : text.toString());
                break;
            }
            case 8: {
                int value = text instanceof Integer ? (Integer)text : Integer.parseInt(text.toString());
                try {
                    value = Math.min((Integer)((SpinnerNumberModel)((JSpinner)this.input[0]).getModel()).getMaximum(), value);
                    value = Math.max((Integer)((SpinnerNumberModel)((JSpinner)this.input[0]).getModel()).getMinimum(), value);
                    ((JSpinner)this.input[0]).setModel(new SpinnerNumberModel(value, this.configEntry.getStart(), this.configEntry.getEnd(), this.configEntry.getStep()));
                }
                catch (Exception e) {
                    JDLogger.exception((Throwable)e);
                }
                break;
            }
            case 5: {
                Component[] inputs = this.input[0].getComponents();
                int i = 0;
                while (i < this.configEntry.getList().length) {
                    JRadioButton radio = (JRadioButton)inputs[i];
                    if (radio.getActionCommand().equals(text)) {
                        radio.setSelected(true);
                    } else {
                        radio.setSelected(false);
                    }
                    ++i;
                }
                break;
            }
        }
        this.getConfigEntry().valueChanged(this.getText());
    }

    public void stateChanged(ChangeEvent e) {
        this.getConfigEntry().valueChanged(this.getText());
    }

    public void load() {
        if (this.getConfigEntry().getPropertyInstance() != null && this.getConfigEntry().getPropertyName() != null) {
            this.setData(this.getConfigEntry().getPropertyInstance().getProperty(this.getConfigEntry().getPropertyName(), this.getConfigEntry().getDefaultValue()));
        } else if (this.getConfigEntry().getListController() != null) {
            this.setData(this.getConfigEntry().getListController().getList());
        }
    }

    public void save() {
        if (this.getConfigEntry().getPropertyInstance() != null && this.getConfigEntry().getPropertyName() != null) {
            this.getConfigEntry().getPropertyInstance().setProperty(this.getConfigEntry().getPropertyName(), this.getText());
        } else if (this.getConfigEntry().getListController() != null) {
            this.getConfigEntry().getListController().setList("" + this.getText());
        }
    }
}

