/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.settings.panels.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jd.config.ConfigEntry;
import jd.config.Configuration;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.jdgui.GUIUtils;
import jd.gui.swing.jdgui.actions.ActionController;
import jd.gui.swing.jdgui.actions.ToolBarAction;
import jd.gui.swing.jdgui.components.toolbar.MainToolBar;
import jd.gui.swing.jdgui.components.toolbar.ToolBar;
import jd.gui.swing.jdgui.settings.ConfigPanel;
import jd.utils.JDTheme;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.JRendererLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolbarController
extends ConfigPanel {
    private static final ArrayList<String> WHITELIST = new ArrayList();
    private static final long serialVersionUID = -7024581410075950497L;
    private static final String JDL_PREFIX = "jd.gui.swing.jdgui.settings.panels.gui.ToolbarController.";
    private JXTable table;
    private InternalTableModel tableModel;
    private ArrayList<ToolBarAction> actions = new ArrayList();
    private ArrayList<String> list;

    static {
        WHITELIST.add("toolbar.control.start");
        WHITELIST.add("toolbar.control.pause");
        WHITELIST.add("toolbar.control.stop");
        WHITELIST.add("separator");
        WHITELIST.add("action.downloadview.movetotop");
        WHITELIST.add("action.downloadview.moveup");
        WHITELIST.add("action.downloadview.movedown");
        WHITELIST.add("action.downloadview.movetobottom");
        WHITELIST.add("separator");
        WHITELIST.add("toolbar.quickconfig.clipboardoberserver");
        WHITELIST.add("toolbar.quickconfig.reconnecttoggle");
        WHITELIST.add("toolbar.control.stopmark");
        WHITELIST.add("separator");
        WHITELIST.add("scheduler");
        WHITELIST.add("langfileditor");
        WHITELIST.add("chat");
        WHITELIST.add("livescripter");
        WHITELIST.add("separator");
        WHITELIST.add("action.remove.links");
        WHITELIST.add("action.remove.packages");
        WHITELIST.add("action.remove_dupes");
        WHITELIST.add("action.remove_disabled");
        WHITELIST.add("action.remove_offline");
        WHITELIST.add("action.remove_failed");
        WHITELIST.add("separator");
        WHITELIST.add("action.addurl");
        WHITELIST.add("action.load");
        WHITELIST.add("toolbar.interaction.reconnect");
        WHITELIST.add("toolbar.interaction.update");
        WHITELIST.add("action.opendlfolder");
        WHITELIST.add("action.restore");
        WHITELIST.add("action.premiumview.addacc");
        WHITELIST.add("action.premium.buy");
        WHITELIST.add("action.about");
        WHITELIST.add("action.help");
        WHITELIST.add("action.changes");
        WHITELIST.add("action.restart");
        WHITELIST.add("action.exit");
        WHITELIST.add("gui.jdshutdown.toggle");
        WHITELIST.add("optional.jdunrar.menu.extract.singlefils");
    }

    @Override
    public String getBreadcrum() {
        return JDL.L((String)(String.valueOf(this.getClass().getName()) + ".breadcrum"), (String)this.getClass().getSimpleName());
    }

    public static String getTitle() {
        return JDL.L((String)"jd.gui.swing.jdgui.settings.panels.gui.ToolbarController..toolbarController.title", (String)"Toolbar Manager");
    }

    public ToolbarController(Configuration configuration) {
        this.initPanel();
        this.load();
    }

    @Override
    public void onShow() {
        super.onShow();
        this.setActions(ActionController.getActions());
    }

    private void setActions(ArrayList<ToolBarAction> actions2) {
        Collections.sort(actions2, new Comparator<ToolBarAction>(){

            @Override
            public int compare(ToolBarAction o1, ToolBarAction o2) {
                int ib;
                int ia = WHITELIST.indexOf(o1.getID());
                return ia < (ib = WHITELIST.indexOf(o2.getID())) ? -1 : 1;
            }
        });
        this.list = new ArrayList();
        this.list.addAll((Collection)GUIUtils.getConfig().getGenericProperty("TOOLBAR", ToolBar.DEFAULT_LIST));
        Iterator<ToolBarAction> it = actions2.iterator();
        while (it.hasNext()) {
            ToolBarAction a = it.next();
            if (a.getValue("IMAGE_KEY") == null) {
                it.remove();
                this.list.remove(a.getID());
                continue;
            }
            if (WHITELIST.contains(a.getID())) continue;
            it.remove();
            this.list.remove(a.getID());
        }
        this.actions = actions2;
        new GuiRunnable<Object>(){

            @Override
            public Object runSave() {
                ToolbarController.this.tableModel.fireTableDataChanged();
                return null;
            }
        }.start();
    }

    @Override
    public void initPanel() {
        this.tableModel = new InternalTableModel();
        this.table = new JXTable(this.tableModel){
            private static final long serialVersionUID = -7914266013067863393L;

            public TableCellRenderer getCellRenderer(int row, int col) {
                if (col == 0) {
                    return super.getCellRenderer(row, col);
                }
                return new TableRenderer();
            }
        };
        this.table.setSortable(false);
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        TableColumn column = this.table.getColumnModel().getColumn(0);
        column.setMinWidth(50);
        column.setPreferredWidth(50);
        column.setMaxWidth(50);
        this.panel.setLayout((LayoutManager)new MigLayout("ins 5,wrap 1", "[fill,grow]", "[fill,grow][]"));
        this.panel.add(new JScrollPane((Component)this.table));
        JTabbedPane tabbed = new JTabbedPane();
        tabbed.setOpaque(false);
        tabbed.add(this.getBreadcrum(), this.panel);
        this.add(tabbed);
    }

    @Override
    public ConfigEntry.PropertyType hasChanges() {
        return ConfigEntry.PropertyType.NONE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1155282457354673850L;

        private InternalTableModel() {
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return ToolBarAction.class;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return JDL.L((String)"jd.gui.swing.jdgui.settings.panels.gui.ToolbarController..column.use", (String)"Use");
                }
                case 1: {
                    return JDL.L((String)"jd.gui.swing.jdgui.settings.panels.gui.ToolbarController..column.name", (String)"Name");
                }
                case 2: {
                    return JDL.L((String)"jd.gui.swing.jdgui.settings.panels.gui.ToolbarController..column.desc", (String)"Description");
                }
            }
            return super.getColumnName(column);
        }

        @Override
        public int getRowCount() {
            return ToolbarController.this.actions.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return ToolbarController.this.list.contains(((ToolBarAction)ToolbarController.this.actions.get(rowIndex)).getID());
            }
            return ToolbarController.this.actions.get(rowIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                if (((Boolean)value).booleanValue()) {
                    if (!ToolbarController.this.list.contains(((ToolBarAction)ToolbarController.this.actions.get(row)).getID())) {
                        ToolbarController.this.list.add(((ToolBarAction)ToolbarController.this.actions.get(row)).getID());
                    }
                } else {
                    while (ToolbarController.this.list.remove(((ToolBarAction)ToolbarController.this.actions.get(row)).getID())) {
                    }
                }
                GUIUtils.getConfig().setProperty("TOOLBAR", (Object)ToolbarController.this.list);
                GUIUtils.getConfig().save();
                Collections.sort(ToolbarController.this.list, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        int ib;
                        int ia = WHITELIST.indexOf(o1);
                        return ia < (ib = WHITELIST.indexOf(o2)) ? -1 : 1;
                    }
                });
                while (ToolbarController.this.list.remove("toolbar.separator")) {
                }
                int i = 1;
                while (i < ToolbarController.this.list.size()) {
                    int b = WHITELIST.indexOf(ToolbarController.this.list.get(i));
                    int a = WHITELIST.indexOf(ToolbarController.this.list.get(i - 1));
                    if (a > 0 && b > 0) {
                        int ii = a;
                        while (ii < b) {
                            if (((String)WHITELIST.get(ii)).equals("separator")) {
                                ToolbarController.this.list.add(i, "toolbar.separator");
                                ++i;
                                break;
                            }
                            ++ii;
                        }
                    }
                    ++i;
                }
                MainToolBar.getInstance().setList(ToolbarController.this.list.toArray(new String[0]));
            }
        }
    }

    private class TableRenderer
    extends DefaultTableRenderer {
        private static final long serialVersionUID = 1L;
        private JRendererLabel label = new JRendererLabel();

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ToolBarAction action = (ToolBarAction)value;
            switch (column) {
                case 1: {
                    this.label.setIcon((Icon)JDTheme.II((String)("" + action.getValue("IMAGE_KEY")), (int)16, (int)16));
                    this.label.setText(action.getTitle());
                    return this.label;
                }
                case 2: {
                    this.label.setIcon(null);
                    this.label.setText(action.getTooltipText());
                    return this.label;
                }
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

