/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.settings.panels.reconnect;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import jd.config.ConfigContainer;
import jd.config.ConfigEntry;
import jd.config.ConfigGroup;
import jd.config.Configuration;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.controlling.ProgressController;
import jd.controlling.reconnect.BatchReconnect;
import jd.controlling.reconnect.ExternReconnect;
import jd.controlling.reconnect.Reconnecter;
import jd.event.JDEvent;
import jd.gui.swing.Factory;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.jdgui.interfaces.SwitchPanelEvent;
import jd.gui.swing.jdgui.settings.ConfigPanel;
import jd.gui.swing.jdgui.settings.GUIConfigEntry;
import jd.gui.swing.jdgui.settings.subpanels.SubPanelCLRReconnect;
import jd.gui.swing.jdgui.settings.subpanels.SubPanelLiveHeaderReconnect;
import jd.nrouter.IPCheck;
import jd.nutils.Formatter;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class MethodSelection
extends ConfigPanel
implements ActionListener {
    private static final String JDL_PREFIX = "jd.gui.swing.jdgui.settings.panels.reconnect.MethodSelection.";
    private static final long serialVersionUID = 3383448498625377495L;
    private JButton btn;
    private Configuration configuration;
    private JTabbedPane tabbed;
    private JLabel currentip;
    private JLabel success;
    private JLabel beforeIPLabel;
    private JLabel beforeIP;
    private JLabel message;
    private JLabel timeLabel;
    private JLabel time;
    private JPanel method;

    public String getBreadcrum() {
        return JDL.L((String)(String.valueOf(this.getClass().getName()) + ".breadcrum"), (String)this.getClass().getSimpleName());
    }

    public static String getTitle() {
        return JDL.L((String)"jd.gui.swing.jdgui.settings.panels.reconnect.MethodSelection.reconnect.title", (String)"Reconnection");
    }

    public MethodSelection(Configuration configuration) {
        this.configuration = configuration;
        this.initPanel();
        this.load();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btn) {
            this.save();
            JDLogger.addHeader((String)"Reconnect Testing");
            final ProgressController progress = new ProgressController(JDL.L((String)"gui.warning.reconnect.pleaseWait", (String)"Bitte Warten...Reconnect l\u00e4uft"), 100L);
            this.logger.info("Start Reconnect");
            this.message.setText(JDL.L((String)"gui.warning.reconnect.running", (String)"running..."));
            this.message.setEnabled(true);
            this.beforeIP.setText(this.currentip.getText());
            this.beforeIP.setEnabled(true);
            this.beforeIPLabel.setEnabled(true);
            this.currentip.setText("?");
            final long timel = System.currentTimeMillis();
            final Thread timer = new Thread(){

                public void run() {
                    do {
                        new GuiRunnable<Object>(){

                            @Override
                            public Object runSave() {
                                MethodSelection.this.time.setText(Formatter.formatSeconds((long)((System.currentTimeMillis() - timel) / 1000L)));
                                MethodSelection.this.time.setEnabled(true);
                                MethodSelection.this.timeLabel.setEnabled(true);
                                return null;
                            }
                        }.start();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    } while (!progress.isFinalizing());
                }
            };
            timer.start();
            final int retries = JDUtilities.getConfiguration().getIntegerProperty("RECONNECT_RETRIES2", 5);
            progress.setStatus(30L);
            new Thread(){

                public void run() {
                    JDUtilities.getConfiguration().setProperty("RECONNECT_RETRIES2", (Object)0);
                    if (Reconnecter.doManualReconnect()) {
                        if (SubConfiguration.getConfig((String)"DOWNLOAD").getBooleanProperty("GLOBAL_IP_DISABLE2", false).booleanValue()) {
                            progress.setStatusText(JDL.L((String)"gui.warning.reconnectunknown", (String)"Reconnect unknown"));
                        } else {
                            progress.setStatusText(JDL.L((String)"gui.warning.reconnectSuccess", (String)"Reconnect successfull"));
                        }
                        new GuiRunnable<Object>(){

                            @Override
                            public Object runSave() {
                                if (SubConfiguration.getConfig((String)"DOWNLOAD").getBooleanProperty("GLOBAL_IP_DISABLE2", false).booleanValue()) {
                                    MethodSelection.this.message.setText(JDL.L((String)"gui.warning.reconnectunknown", (String)"Reconnect unknown"));
                                } else {
                                    MethodSelection.this.message.setText(JDL.L((String)"gui.warning.reconnectSuccess", (String)"Reconnect successfull"));
                                }
                                MethodSelection.this.success.setIcon(JDTheme.II((String)"gui.images.selected", (int)32, (int)32));
                                MethodSelection.this.success.setEnabled(true);
                                if (SubConfiguration.getConfig((String)"DOWNLOAD").getBooleanProperty("GLOBAL_IP_DISABLE2", false).booleanValue()) {
                                    MethodSelection.this.currentip.setText("?");
                                } else {
                                    MethodSelection.this.currentip.setText(IPCheck.getIPAddress());
                                }
                                return null;
                            }
                        }.start();
                    } else {
                        progress.setStatusText(JDL.L((String)"gui.warning.reconnectFailed", (String)"Reconnect failed!"));
                        progress.setColor(Color.RED);
                        new GuiRunnable<Object>(){

                            @Override
                            public Object runSave() {
                                MethodSelection.this.message.setText(JDL.L((String)"gui.warning.reconnectFailed", (String)"Reconnect failed!"));
                                MethodSelection.this.success.setIcon(JDTheme.II((String)"gui.images.unselected", (int)32, (int)32));
                                MethodSelection.this.success.setEnabled(true);
                                if (SubConfiguration.getConfig((String)"DOWNLOAD").getBooleanProperty("GLOBAL_IP_DISABLE2", false).booleanValue()) {
                                    MethodSelection.this.currentip.setText("?");
                                } else {
                                    MethodSelection.this.currentip.setText(IPCheck.getIPAddress());
                                }
                                return null;
                            }
                        }.start();
                    }
                    timer.interrupt();
                    progress.setStatus(100L);
                    progress.doFinalize(5000L);
                    JDUtilities.getConfiguration().setProperty("RECONNECT_RETRIES2", (Object)retries);
                }
            }.start();
        }
    }

    public void initPanel() {
        this.method = new JPanel((LayoutManager)new MigLayout("ins 0 0 0 0,wrap 2", "[fill,grow 10]10[fill,grow]"));
        this.tabbed = new JTabbedPane();
        this.method.add((Component)this.tabbed, "spanx,pushy,growy");
        this.tabbed.setTabPlacement(1);
        this.addLiveheader();
        this.addExtern();
        this.addBatch();
        this.addCLR();
        this.method.add((Component)Factory.createHeader(new ConfigGroup(JDL.L((String)"gui.config.reconnect.test", (String)"Showcase"), JDTheme.II((String)"gui.images.config.network_local", (int)32, (int)32))), "spanx,gaptop 15,gapleft 20,gapright 15");
        JPanel p = new JPanel((LayoutManager)new MigLayout(" ins 0,wrap 7", "[]5[fill]5[align right]20[align right]20[align right]20[align right]20[align right]", "[][]"));
        this.method.add((Component)p, "spanx,gapright 20,gapleft 54");
        this.btn = new JButton(JDL.L((String)"gui.config.reconnect.showcase.reconnect", (String)"Change IP"));
        this.btn.addActionListener(this);
        p.add((Component)this.btn, "spany, aligny top");
        p.add((Component)new JPanel(), "height 32!,spany,alignx left,pushx");
        this.timeLabel = new JLabel(JDL.L((String)"gui.config.reconnect.showcase.time", (String)"Reconnect duration"));
        p.add(this.timeLabel);
        this.time = new JLabel("---");
        p.add(this.time);
        this.timeLabel.setEnabled(false);
        this.time.setEnabled(false);
        p.add(new JLabel(JDL.L((String)"gui.config.reconnect.showcase.currentip", (String)"Your current IP")));
        this.currentip = new JLabel("---");
        p.add(this.currentip);
        this.success = new JLabel(JDTheme.II((String)"gui.images.selected", (int)32, (int)32));
        this.success.setEnabled(false);
        p.add((Component)this.success, "spany,alignx right");
        this.message = new JLabel(JDL.L((String)"gui.config.reconnect.showcase.message.none", (String)"Not tested yet"));
        p.add((Component)this.message, "spanx 2");
        this.message.setEnabled(false);
        this.beforeIPLabel = new JLabel(JDL.L((String)"gui.config.reconnect.showcase.lastip", (String)"Ip before reconnect"));
        p.add(this.beforeIPLabel);
        this.beforeIP = new JLabel("---");
        p.add(this.beforeIP);
        this.beforeIPLabel.setEnabled(false);
        this.beforeIP.setEnabled(false);
        if (!SubConfiguration.getConfig((String)"DOWNLOAD").getBooleanProperty("GLOBAL_IP_DISABLE2", false).booleanValue()) {
            new Thread(){

                public void run() {
                    final String ip = IPCheck.getIPAddress();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MethodSelection.this.currentip.setText(ip);
                        }
                    });
                }
            }.start();
        }
        this.setLayout((LayoutManager)new MigLayout("ins 0,wrap 1", "[fill,grow 10]", "[fill,grow]"));
        JTabbedPane tabbed = new JTabbedPane();
        tabbed.setOpaque(false);
        tabbed.add(this.getBreadcrum(), this.method);
        this.add(tabbed);
    }

    private void addCLR() {
        String name = JDL.L((String)"modules.reconnect.types.clr", (String)"CLR Script");
        this.tabbed.addTab(name, new SubPanelCLRReconnect(this.configuration));
    }

    private void addBatch() {
        String name = JDL.L((String)"modules.reconnect.types.batch", (String)"Batch");
        ConfigPanel cp = new ConfigPanel(){
            private static final long serialVersionUID = -6178073263504701330L;

            public void initPanel() {
                ConfigContainer container = new BatchReconnect().getConfig();
                for (ConfigEntry cfgEntry : container.getEntries()) {
                    GUIConfigEntry ce = new GUIConfigEntry(cfgEntry);
                    if (ce == null) continue;
                    this.addGUIConfigEntry(ce);
                }
                this.add(this.panel);
            }
        };
        this.tabbed.addTab(name, cp);
        cp.initPanel();
    }

    private void addExtern() {
        String name = JDL.L((String)"modules.reconnect.types.extern", (String)"Extern");
        ConfigPanel cp = new ConfigPanel(){
            private static final long serialVersionUID = 1086423194283483561L;

            public void initPanel() {
                ConfigContainer container = new ExternReconnect().getConfig();
                for (ConfigEntry cfgEntry : container.getEntries()) {
                    GUIConfigEntry ce = new GUIConfigEntry(cfgEntry);
                    if (ce == null) continue;
                    this.addGUIConfigEntry(ce);
                }
                this.add(this.panel);
            }
        };
        this.tabbed.addTab(name, cp);
        cp.initPanel();
    }

    private void addLiveheader() {
        String name = JDL.L((String)"modules.reconnect.types.liveheader", (String)"LiveHeader/Curl");
        this.tabbed.addTab(name, new SubPanelLiveHeaderReconnect(this.configuration));
    }

    public void loadSpecial() {
        this.tabbed.setSelectedIndex(this.configuration.getIntegerProperty("RECONNECT_TYPE", 0));
    }

    public ConfigEntry.PropertyType hasChanges() {
        ConfigEntry.PropertyType ret = this.tabbed.getSelectedIndex() != this.configuration.getIntegerProperty("RECONNECT_TYPE", 0) ? ConfigEntry.PropertyType.NORMAL : ConfigEntry.PropertyType.NONE;
        return ConfigEntry.PropertyType.getMax((ConfigEntry.PropertyType[])new ConfigEntry.PropertyType[]{ret, super.hasChanges(), ((ConfigPanel)this.tabbed.getSelectedComponent()).hasChanges()});
    }

    public void setHidden() {
        this.save();
        this.getBroadcaster().fireEvent((JDEvent)new SwitchPanelEvent(this, 1));
    }

    public void saveSpecial() {
        this.configuration.setProperty("RECONNECT_TYPE", (Object)this.tabbed.getSelectedIndex());
        ((ConfigPanel)this.tabbed.getSelectedComponent()).save();
    }
}

