/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.userio;

import java.awt.Point;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileFilter;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.components.JDFileChooser;
import jd.gui.swing.dialog.CaptchaDialog;
import jd.gui.swing.dialog.ClickPositionDialog;
import jd.gui.swing.dialog.ComboDialog;
import jd.gui.swing.dialog.ConfirmDialog;
import jd.gui.swing.dialog.HelpDialog;
import jd.gui.swing.dialog.InputDialog;
import jd.gui.swing.dialog.TextAreaDialog;
import jd.gui.swing.dialog.TwoTextFieldDialog;
import jd.gui.userio.DummyFrame;
import jd.nutils.JDFlags;
import jd.utils.JDTheme;

public class UserIOGui
extends UserIO {
    private UserIOGui() {
    }

    public static UserIO getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UserIOGui();
        }
        return INSTANCE;
    }

    protected String showCaptchaDialog(final int flag, final String host, final String methodname, final File captchafile, final String suggestion, final String explain) {
        if ((flag & 2) > 0) {
            return suggestion;
        }
        return (String)new GuiRunnable<String>(){

            @Override
            public String runSave() {
                return new CaptchaDialog(flag, host, methodname, captchafile, suggestion, explain).getCaptchaText();
            }
        }.getReturnValue();
    }

    protected Point showClickPositionDialog(final File imagefile, final String title, final String explain) {
        return (Point)new GuiRunnable<Point>(){

            @Override
            public Point runSave() {
                return new ClickPositionDialog(imagefile, title, explain).getPoint();
            }
        }.getReturnValue();
    }

    protected int showHelpDialog(final int flag, final String title, final String message, final String helpMessage, final String url) {
        return (Integer)new GuiRunnable<Integer>(){

            @Override
            public Integer runSave() {
                return new HelpDialog(flag, title, message, helpMessage, url).getReturnValue();
            }
        }.getReturnValue();
    }

    protected int showConfirmDialog(final int flag, final String title, final String message, final ImageIcon icon, final String okOption, final String cancelOption) {
        if ((flag & 2) > 0) {
            return 0;
        }
        return (Integer)new GuiRunnable<Integer>(){

            @Override
            public Integer runSave() {
                return new ConfirmDialog(flag, title, message, icon, okOption, cancelOption).getReturnID();
            }
        }.getReturnValue();
    }

    protected String showInputDialog(final int flag, final String title, final String message, final String defaultMessage, final ImageIcon icon, final String okOption, final String cancelOption) {
        if ((flag & 2) > 0) {
            return defaultMessage;
        }
        return (String)new GuiRunnable<String>(){

            @Override
            public String runSave() {
                return new InputDialog(flag, title, message, defaultMessage, icon, okOption, cancelOption).getReturnID();
            }
        }.getReturnValue();
    }

    protected String showTextAreaDialog(final String title, final String message, final String def) {
        return (String)new GuiRunnable<String>(){

            @Override
            public String runSave() {
                TextAreaDialog dialog = new TextAreaDialog(title, message, def);
                if (JDFlags.hasAllFlags((int)dialog.getReturnValue(), (int[])new int[]{2})) {
                    return dialog.getResult();
                }
                return null;
            }
        }.getReturnValue();
    }

    protected String[] showTwoTextFieldDialog(final String title, final String messageOne, final String defOne, final String messageTwo, final String defTwo) {
        return (String[])new GuiRunnable<String[]>(){

            @Override
            public String[] runSave() {
                TwoTextFieldDialog dialog = new TwoTextFieldDialog(title, messageOne, defOne, messageTwo, defTwo);
                if (JDFlags.hasAllFlags((int)dialog.getReturnValue(), (int[])new int[]{2})) {
                    return dialog.getResult();
                }
                return null;
            }
        }.getReturnValue();
    }

    public ImageIcon getIcon(int iconInfo) {
        switch (iconInfo) {
            case 2: {
                return JDTheme.II((String)"gui.images.stop", (int)32, (int)32);
            }
            case 1: {
                return JDTheme.II((String)"gui.images.warning", (int)32, (int)32);
            }
            case 3: {
                return JDTheme.II((String)"gui.images.help", (int)32, (int)32);
            }
        }
        return JDTheme.II((String)"gui.images.config.tip", (int)32, (int)32);
    }

    protected File[] showFileChooser(String id, String title, Integer fileSelectionMode, FileFilter fileFilter, Boolean multiSelection) {
        JDFileChooser fc = new JDFileChooser(id);
        if (title != null) {
            fc.setDialogTitle(title);
        }
        if (fileSelectionMode != null) {
            fc.setFileSelectionMode(fileSelectionMode);
        }
        if (fileFilter != null) {
            fc.setFileFilter(fileFilter);
        }
        if (multiSelection != null) {
            fc.setMultiSelectionEnabled(multiSelection);
        }
        if (fc.showOpenDialog(DummyFrame.getDialogParent()) == 0) {
            return fc.getSelectedFiles();
        }
        return null;
    }

    public int requestComboDialog(final int flag, final String title, final String question, final Object[] options, final int defaultSelection, final ImageIcon icon, final String okText, final String cancelText, final ListCellRenderer renderer) {
        if ((flag & 2) > 0) {
            return defaultSelection;
        }
        return (Integer)new GuiRunnable<Integer>(){

            @Override
            public Integer runSave() {
                return new ComboDialog(flag, title, question, options, defaultSelection, icon, okText, cancelText, renderer).getReturnID();
            }
        }.getReturnValue();
    }
}

