/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.downloadview;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import jd.controlling.DownloadController;
import jd.gui.swing.SwingGui;
import jd.gui.swing.jdgui.views.downloadview.DownloadTable;
import jd.parser.Regex;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public class TableTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 2560352681437669412L;
    private static final int DRAG_LINKS = 1;
    private static final int DRAG_PACKAGES = 2;
    private Object draggingObjects = null;
    private int draggingType = 0;
    public boolean isDragging = false;
    private DownloadTable table;

    public TableTransferHandler(DownloadTable downloadTreeTable) {
        this.table = downloadTreeTable;
    }

    public boolean canImport(TransferHandler.TransferSupport info) {
        if (this.isDragging) {
            if (this.draggingObjects == null) {
                return false;
            }
            int row = ((JTable.DropLocation)info.getDropLocation()).getRow();
            if (row == -1) {
                return false;
            }
            Object current = this.table.getModel().getValueAt(row, 0);
            if (current == null) {
                return false;
            }
            switch (this.draggingType) {
                case 1: {
                    ArrayList downloadLinks = (ArrayList)this.draggingObjects;
                    if (!(current instanceof DownloadLink) || !downloadLinks.contains(current)) break;
                    return false;
                }
                case 2: {
                    ArrayList packages = (ArrayList)this.draggingObjects;
                    if (current instanceof FilePackage && packages.contains(current)) {
                        return false;
                    }
                    if (!(current instanceof DownloadLink) || !packages.contains(((DownloadLink)current).getFilePackage())) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        if (info.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return true;
        }
        return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    protected Transferable createTransferable(JComponent c) {
        this.isDragging = true;
        String url = "http://www.jdownloader.org";
        ArrayList<FilePackage> packages = this.table.getSelectedFilePackages();
        ArrayList<DownloadLink> downloadLinks = this.table.getSelectedDownloadLinks();
        Point p = SwingGui.getInstance().getMainFrame().getMousePosition();
        p = SwingUtilities.convertPoint(SwingGui.getInstance().getMainFrame(), p, (Component)((Object)this.table));
        int row = this.table.rowAtPoint(p);
        if (row == -1) {
            this.isDragging = false;
            return null;
        }
        Object current = this.table.getModel().getValueAt(row, 0);
        if (current == null) {
            return new StringSelection(url);
        }
        if (current instanceof FilePackage) {
            this.draggingObjects = packages;
            this.draggingType = 2;
        } else {
            this.draggingObjects = downloadLinks;
            if (downloadLinks.size() != 0 && downloadLinks.get(0).getLinkType() == 0) {
                url = downloadLinks.get(0).getBrowserUrl();
            }
            this.draggingType = 1;
        }
        return new StringSelection(url);
    }

    protected void exportDone(JComponent source, Transferable data, int action) {
        this.isDragging = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean drop(int row, Point point) {
        JMenuItem m;
        if (!this.isDragging) {
            return false;
        }
        final Object current = this.table.getModel().getValueAt(row, 0);
        if (current == null) {
            return false;
        }
        JPopupMenu popup = new JPopupMenu();
        ArrayList arrayList = DownloadController.getInstance().getPackages();
        synchronized (arrayList) {
            switch (this.draggingType) {
                case 1: {
                    if (current instanceof FilePackage) {
                        String name = ((FilePackage)current).getName();
                        m = new JMenuItem(JDL.LF((String)"gui.table.draganddrop.insertinpackagestart", (String)"In Paket '%s' am Anfang einf\u00fcgen", (Object[])new Object[]{name}));
                        popup.add(m);
                        m.setIcon(JDTheme.II((String)"gui.images.go_top", (int)16, (int)16));
                        m.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                DownloadController.getInstance().move(TableTransferHandler.this.draggingObjects, current, (byte)3);
                            }
                        });
                        m = new JMenuItem(JDL.LF((String)"gui.table.draganddrop.insertinpackageend", (String)"In Paket '%s' am Ende einf\u00fcgen", (Object[])new Object[]{name}));
                        popup.add(m);
                        m.setIcon(JDTheme.II((String)"gui.images.go_bottom", (int)16, (int)16));
                        m.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                DownloadController.getInstance().move(TableTransferHandler.this.draggingObjects, current, (byte)4);
                            }
                        });
                        break;
                    }
                    if (!(current instanceof DownloadLink)) break;
                    String name = ((DownloadLink)current).getName();
                    m = new JMenuItem(JDL.LF((String)"gui.table.draganddrop.before", (String)"Vor '%s' ablegen", (Object[])new Object[]{name}));
                    popup.add(m);
                    m.setIcon(JDTheme.II((String)"gui.images.go_top", (int)16, (int)16));
                    m.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            DownloadController.getInstance().move(TableTransferHandler.this.draggingObjects, current, (byte)1);
                        }
                    });
                    m = new JMenuItem(JDL.LF((String)"gui.table.draganddrop.after", (String)"Nach '%s' ablegen", (Object[])new Object[]{name}));
                    popup.add(m);
                    m.setIcon(JDTheme.II((String)"gui.images.go_bottom", (int)16, (int)16));
                    m.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            DownloadController.getInstance().move(TableTransferHandler.this.draggingObjects, current, (byte)2);
                        }
                    });
                    break;
                }
                case 2: {
                    String name;
                    if (current instanceof FilePackage) {
                        name = ((FilePackage)current).getName();
                    } else {
                        if (!(current instanceof DownloadLink)) {
                            return false;
                        }
                        name = ((DownloadLink)current).getFilePackage().getName();
                    }
                    m = new JMenuItem(JDL.LF((String)"gui.table.draganddrop.movepackagebefore", (String)"Vor Paket '%s' einf\u00fcgen", (Object[])new Object[]{name}));
                    popup.add(m);
                    m.setIcon(JDTheme.II((String)"gui.images.go_top", (int)16, (int)16));
                    m.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            DownloadController.getInstance().move(TableTransferHandler.this.draggingObjects, current, (byte)1);
                        }
                    });
                    m = new JMenuItem(JDL.LF((String)"gui.table.draganddrop.movepackageend", (String)"Nach Paket '%s' einf\u00fcgen", (Object[])new Object[]{name}));
                    popup.add(m);
                    m.setIcon(JDTheme.II((String)"gui.images.go_bottom", (int)16, (int)16));
                    m.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            DownloadController.getInstance().move(TableTransferHandler.this.draggingObjects, current, (byte)2);
                        }
                    });
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        m = new JMenuItem(JDL.L((String)"gui.btn_cancel", (String)"Abbrechen"));
        popup.add(m);
        m.setIcon(JDTheme.II((String)"gui.images.unselected", (int)16, (int)16));
        popup.show((Component)((Object)this.table), point.x, point.y);
        return true;
    }

    public int getSourceActions(JComponent c) {
        return 2;
    }

    public boolean importData(TransferHandler.TransferSupport info) {
        try {
            Transferable tr = info.getTransferable();
            if (this.isDragging) {
                Point p = ((JTable.DropLocation)info.getDropLocation()).getDropPoint();
                int row = ((JTable.DropLocation)info.getDropLocation()).getRow();
                return this.drop(row, p);
            }
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List list = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                int t = 0;
                while (t < list.size()) {
                    JDUtilities.getController().loadContainerFile((File)list.get(t));
                    ++t;
                }
            } else if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String files = (String)tr.getTransferData(DataFlavor.stringFlavor);
                String[] linuxfiles = new Regex(files, "file://(.*?)(\r\n|\r|\n)").getColumn(0);
                if (linuxfiles != null && linuxfiles.length > 0) {
                    String[] stringArray = linuxfiles;
                    int n = linuxfiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String file = stringArray[n2];
                        JDUtilities.getController().loadContainerFile(new File(file.trim()));
                        ++n2;
                    }
                } else {
                    JDUtilities.getController().distributeLinks(files);
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

