/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.linkgrabberview.Columns;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import jd.controlling.LinkGrabberController;
import jd.gui.swing.components.table.JDTableColumn;
import jd.gui.swing.components.table.JDTableModel;
import jd.nutils.Formatter;
import jd.plugins.DownloadLink;
import jd.plugins.LinkGrabberFilePackage;
import org.jdesktop.swingx.renderer.JRendererLabel;

public class RequestTimeColumn
extends JDTableColumn {
    private static final long serialVersionUID = 2228210790952050305L;
    private DownloadLink dLink;
    private JRendererLabel jlr = new JRendererLabel();

    public RequestTimeColumn(String name, JDTableModel table) {
        super(name, table);
        this.jlr.setBorder(null);
    }

    public boolean isEditable(Object obj) {
        return false;
    }

    public boolean defaultVisible() {
        return false;
    }

    public Component myTableCellEditorComponent(JDTableModel table, Object value, boolean isSelected, int row, int column) {
        return null;
    }

    public Component myTableCellRendererComponent(JDTableModel table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof LinkGrabberFilePackage) {
            this.jlr.setText("");
        } else if (value instanceof DownloadLink) {
            this.dLink = (DownloadLink)value;
            this.jlr.setText(Formatter.formatMilliseconds((long)this.dLink.getRequestTime()));
        }
        return this.jlr;
    }

    public void setValue(Object value, Object object) {
    }

    public Object getCellEditorValue() {
        return null;
    }

    public boolean isSortable(Object obj) {
        if (obj == null && LinkGrabberController.getInstance().size() == 1) {
            return true;
        }
        return obj instanceof ArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(Object obj, final boolean sortingToggle) {
        ArrayList packages = null;
        Object object = LinkGrabberController.ControllerLock;
        synchronized (object) {
            ArrayList arrayList = LinkGrabberController.getInstance().getPackages();
            synchronized (arrayList) {
                packages = LinkGrabberController.getInstance().getPackages();
                if (obj != null && packages.size() > 1) {
                    packages = (ArrayList)obj;
                }
                for (LinkGrabberFilePackage fp : packages) {
                    Collections.sort(fp.getDownloadLinks(), new Comparator<DownloadLink>(){

                        @Override
                        public int compare(DownloadLink a, DownloadLink b) {
                            DownloadLink aa = b;
                            DownloadLink bb = a;
                            if (sortingToggle) {
                                aa = a;
                                bb = b;
                            }
                            if (aa.getRequestTime() == bb.getRequestTime()) {
                                return 0;
                            }
                            return aa.getRequestTime() < bb.getRequestTime() ? -1 : 1;
                        }
                    });
                }
            }
        }
        LinkGrabberController.getInstance().throwRefresh();
    }

    public boolean isEnabled(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DownloadLink) {
            return ((DownloadLink)obj).isEnabled();
        }
        return true;
    }
}

