/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.linkgrabberview;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import jd.config.Property;
import jd.config.SubConfiguration;
import jd.controlling.ClipboardHandler;
import jd.controlling.DownloadWatchDog;
import jd.controlling.JDLogger;
import jd.controlling.LinkCheck;
import jd.controlling.LinkCheckEvent;
import jd.controlling.LinkCheckListener;
import jd.controlling.LinkGrabberController;
import jd.controlling.LinkGrabberControllerEvent;
import jd.controlling.LinkGrabberControllerListener;
import jd.controlling.ProgressController;
import jd.controlling.ProgressControllerEvent;
import jd.controlling.ProgressControllerListener;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.SwingGui;
import jd.gui.swing.components.Balloon;
import jd.gui.swing.components.JDFileChooser;
import jd.gui.swing.components.linkbutton.JLink;
import jd.gui.swing.jdgui.GUIUtils;
import jd.gui.swing.jdgui.actions.ThreadedAction;
import jd.gui.swing.jdgui.interfaces.SwitchPanel;
import jd.gui.swing.jdgui.views.LinkgrabberView;
import jd.gui.swing.jdgui.views.linkgrabberview.LinkGrabberFilePackageInfo;
import jd.gui.swing.jdgui.views.linkgrabberview.LinkGrabberTable;
import jd.gui.swing.jdgui.views.linkgrabberview.LinkGrabberTableAction;
import jd.gui.swing.jdgui.views.linkgrabberview.LinkGrabberToolbar;
import jd.gui.swing.jdgui.views.toolbar.ViewToolbar;
import jd.nutils.JDFlags;
import jd.nutils.io.JDFileFilter;
import jd.nutils.io.JDIO;
import jd.nutils.jobber.Jobber;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.LinkGrabberFilePackage;
import jd.plugins.LinkGrabberFilePackageListener;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkGrabberPanel
extends SwitchPanel
implements ActionListener,
LinkCheckListener,
ProgressControllerListener,
LinkGrabberControllerListener {
    private static final long serialVersionUID = 1607433619381447389L;
    public static final String JDL_PREFIX = "jd.gui.swing.jdgui.views.linkgrabberview";
    private ArrayList<DownloadLink> waitingList = new ArrayList();
    private LinkGrabberTable internalTable;
    protected Logger logger = JDLogger.getLogger();
    private transient Thread gatherer;
    private boolean gatherer_running = false;
    private ProgressController pc;
    private LinkGrabberFilePackageInfo filePackageInfo;
    private Timer gathertimer;
    private Jobber checkJobbers = new Jobber(4);
    private LinkCheck lc = LinkCheck.getLinkChecker();
    private Timer Update_Async;
    private static LinkGrabberPanel INSTANCE;
    private LinkGrabberController LGINSTANCE = null;
    protected boolean tablerefreshinprogress = false;
    protected boolean addinginprogress = false;
    private JScrollPane scrollPane;
    private ViewToolbar toolbar;
    private boolean notvisible = true;

    public static synchronized LinkGrabberPanel getLinkGrabber() {
        if (INSTANCE == null) {
            INSTANCE = new LinkGrabberPanel();
        }
        return INSTANCE;
    }

    public boolean isRunning() {
        return this.gatherer_running;
    }

    public boolean needsViewport() {
        return false;
    }

    public boolean isNotVisible() {
        return this.notvisible;
    }

    private LinkGrabberPanel() {
        super((LayoutManager)new MigLayout("ins 0,wrap 1", "[fill,grow]", "[fill,grow]"));
        this.internalTable = new LinkGrabberTable(this);
        this.scrollPane = new JScrollPane((Component)((Object)this.internalTable));
        this.add((Component)this.scrollPane, "cell 0 0");
        this.filePackageInfo = new LinkGrabberFilePackageInfo();
        this.Update_Async = new Timer(250, this);
        this.Update_Async.setInitialDelay(250);
        this.Update_Async.setRepeats(false);
        this.gathertimer = new Timer(2000, this);
        this.gathertimer.setInitialDelay(2000);
        this.gathertimer.setRepeats(false);
        INSTANCE = this;
        this.LGINSTANCE = LinkGrabberController.getInstance();
        this.LGINSTANCE.addListener((LinkGrabberControllerListener)this);
        this.initActions();
        if (!SubConfiguration.getConfig((String)"LINKGRABBER").getBooleanProperty("PARAM_CONTROLPOSITION", false).booleanValue()) {
            this.toolbar = new LinkGrabberToolbar();
            this.add((Component)this.toolbar, "gapbottom 3,DOCK SOUTH");
        }
    }

    public void initActions() {
        new ThreadedAction("action.linkgrabber.clearlist", "gui.images.clear"){
            private static final long serialVersionUID = -4407938288408350792L;

            public void initDefaults() {
                this.setToolTipText(JDL.L((String)"gui.linkgrabberv2.lg.clear", (String)"Clear List"));
            }

            public void init() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void threadedActionPerformed(ActionEvent e) {
                if (LinkGrabberPanel.this.LGINSTANCE.getPackages().isEmpty() && LinkGrabberPanel.this.LGINSTANCE.getFilterPackage().isEmpty()) {
                    return;
                }
                if (JDFlags.hasSomeFlags((int)UserIO.getInstance().requestConfirmDialog(548, JDL.L((String)"gui.linkgrabberv2.lg.clear.ask", (String)"Clear linkgrabber list?")), (int[])new int[]{2})) {
                    Object object = LinkGrabberController.ControllerLock;
                    synchronized (object) {
                        ArrayList arrayList = LinkGrabberPanel.this.LGINSTANCE.getPackages();
                        synchronized (arrayList) {
                            LinkGrabberPanel.this.stopLinkGatherer();
                            LinkGrabberPanel.this.lc.abortLinkCheck();
                            LinkGrabberPanel.this.LGINSTANCE.getFilterPackage().clear();
                            ArrayList<LinkGrabberFilePackage> selected_packages = new ArrayList<LinkGrabberFilePackage>(LinkGrabberPanel.this.LGINSTANCE.getPackages());
                            selected_packages.add(LinkGrabberPanel.this.LGINSTANCE.getFilterPackage());
                            for (LinkGrabberFilePackage fp2 : selected_packages) {
                                fp2.setDownloadLinks(new ArrayList());
                            }
                        }
                    }
                }
            }
        };
        new ThreadedAction("action.linkgrabber.addall", "gui.images.add_all"){
            private static final long serialVersionUID = 6181260839200699153L;

            public void initDefaults() {
                this.setToolTipText(JDL.L((String)"gui.linkgrabberv2.lg.addall", (String)"Add all packages"));
            }

            public void init() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void threadedActionPerformed(ActionEvent e) {
                Object object = LinkGrabberController.ControllerLock;
                synchronized (object) {
                    ArrayList arrayList = LinkGrabberPanel.this.LGINSTANCE.getPackages();
                    synchronized (arrayList) {
                        LinkGrabberPanel.this.LGINSTANCE.getFilterPackage().clear();
                        ArrayList fps = new ArrayList(LinkGrabberPanel.this.LGINSTANCE.getPackages());
                        LinkGrabberPanel.this.confirmPackages(fps);
                    }
                }
            }
        };
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void showFilePackageInfo(LinkGrabberFilePackage fp) {
        this.filePackageInfo.setPackage(fp);
        new GuiRunnable<Object>(){

            @Override
            public Object runSave() {
                LinkgrabberView.getInstance().setInfoPanel(LinkGrabberPanel.this.filePackageInfo);
                return null;
            }
        }.start();
    }

    public void hideFilePackageInfo() {
        new GuiRunnable<Object>(){

            @Override
            public Object runSave() {
                LinkgrabberView.getInstance().setInfoPanel(null);
                return null;
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTableChanged() {
        Object object = LinkGrabberController.ControllerLock;
        synchronized (object) {
            ArrayList arrayList = this.LGINSTANCE.getPackages();
            synchronized (arrayList) {
                if (this.gatherer_running) {
                    ArrayList fps = this.LGINSTANCE.getPackages();
                    int count = 0;
                    for (LinkGrabberFilePackage fp : fps) {
                        count += 1 + fp.size();
                    }
                    if ((double)count > this.internalTable.getVisibleRect().getHeight() / 16.0) {
                        for (LinkGrabberFilePackage fp : fps) {
                            if (fp.getBooleanProperty("lg_userexpand", false).booleanValue()) continue;
                            fp.setProperty("lg_expanded", (Object)false);
                        }
                    } else {
                        for (LinkGrabberFilePackage fp : fps) {
                            if (fp.getBooleanProperty("lg_userexpand", false).booleanValue()) continue;
                            fp.setProperty("lg_expanded", (Object)true);
                        }
                    }
                }
                try {
                    this.internalTable.fireTableChanged();
                }
                catch (Exception e) {
                    this.logger.severe("TreeTable Exception, complete refresh!");
                    this.Update_Async.restart();
                }
            }
        }
    }

    @Override
    public void onHide() {
        this.notvisible = true;
        this.LGINSTANCE.removeListener((LinkGrabberControllerListener)this);
        this.Update_Async.stop();
    }

    public void move(byte mode) {
        ArrayList<LinkGrabberFilePackage> fps = this.internalTable.getSelectedFilePackages();
        ArrayList<DownloadLink> links = this.internalTable.getSelectedDownloadLinks();
        if (fps.size() > 0) {
            LinkGrabberController.getInstance().move(fps, null, mode);
        }
        if (links.size() > 0) {
            LinkGrabberController.getInstance().move(links, null, mode);
        }
    }

    public void addLinks(final ArrayList<DownloadLink> linkList) {
        this.addinginprogress = true;
        new Thread(){

            public void run() {
                Balloon.showIfHidden(JDL.L((String)"gui.config.gui.linkgrabber", (String)"LinkGrabber"), JDTheme.II((String)"gui.images.add", (int)32, (int)32), JDL.LF((String)"gui.linkgrabber.adding", (String)"Adding %s link(s) to LinkGrabber", (Object[])new Object[]{"" + linkList.size()}));
                for (DownloadLink element : linkList) {
                    if (LinkGrabberPanel.this.LGINSTANCE.isDupe(element)) continue;
                    LinkGrabberPanel.this.addToWaitingList(element);
                }
                LinkGrabberPanel.this.Update_Async.restart();
                LinkGrabberPanel.this.gathertimer.restart();
                LinkGrabberPanel.this.addinginprogress = false;
            }
        }.start();
    }

    public boolean isAddinginProgress() {
        return this.addinginprogress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToWaitingList(DownloadLink element) {
        ArrayList<DownloadLink> arrayList = this.waitingList;
        synchronized (arrayList) {
            this.waitingList.add(element);
        }
        this.checkAlreadyinList(element);
        this.LGINSTANCE.attachToPackagesFirstStage(element);
    }

    public void recheckLinks(final ArrayList<DownloadLink> links) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = LinkGrabberPanel.this.waitingList;
                synchronized (object) {
                    LinkGrabberPanel.this.waitingList.removeAll(links);
                }
                LinkGrabberPanel.this.lc.removefromWaitingList(links);
                object = LinkGrabberController.ControllerLock;
                synchronized (object) {
                    ArrayList arrayList = LinkGrabberPanel.this.LGINSTANCE.getPackages();
                    synchronized (arrayList) {
                        for (DownloadLink link : links) {
                            LinkGrabberFilePackage fp = LinkGrabberPanel.this.LGINSTANCE.getFPwithLink(link);
                            if (fp != null) {
                                fp.remove(link);
                                link.setAvailableStatus(DownloadLink.AvailableStatus.UNCHECKED);
                            }
                            link.setProperty("forcecheck", (Object)1);
                        }
                    }
                }
                LinkGrabberPanel.this.addLinks(links);
            }
        }.start();
    }

    private void stopLinkGatherer() {
        this.lc.getBroadcaster().removeListener((EventListener)this);
        if (this.gatherer != null && this.gatherer.isAlive()) {
            this.gatherer_running = false;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    LinkGrabberPanel.this.pc.setStatusText(String.valueOf(LinkGrabberPanel.this.pc.getStatusText()) + ": " + JDL.L((String)"gui.linkgrabber.aborted", (String)"Aborted"));
                    LinkGrabberPanel.this.pc.doFinalize(5000L);
                }
            });
            this.checkJobbers.stop();
            this.gatherer.interrupt();
        }
    }

    public ArrayList<String> getExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        String ext = null;
        ArrayList<LinkGrabberFilePackage> fps = new ArrayList<LinkGrabberFilePackage>(this.LGINSTANCE.getPackages());
        fps.add(this.LGINSTANCE.getFilterPackage());
        for (LinkGrabberFilePackage fp : fps) {
            for (DownloadLink l : new ArrayList(fp.getDownloadLinks())) {
                ext = JDIO.getFileExtension((String)l.getName());
                if (ext == null || ext.trim().length() <= 1 || extensions.contains(ext.trim())) continue;
                extensions.add(ext.trim());
            }
        }
        Collections.sort(extensions);
        return extensions;
    }

    private void startLinkGatherer() {
        if (this.gatherer != null && this.gatherer.isAlive()) {
            return;
        }
        this.gatherer = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                this.setName("LinkGrabber");
                LinkGrabberPanel.this.gatherer_running = true;
                LinkGrabberPanel.this.pc = new ProgressController(JDL.L((String)"gui.linkgrabber.pc.linkgrabber", (String)"LinkGrabber operations pending..."));
                LinkGrabberPanel.this.pc.getBroadcaster().addListener((EventListener)INSTANCE);
                LinkGrabberPanel.this.lc.getBroadcaster().addListener((EventListener)INSTANCE);
                LinkGrabberPanel.this.pc.setRange(0L);
                while (LinkGrabberPanel.this.waitingList.size() > 0 || LinkGrabberPanel.this.lc.isRunning()) {
                    ArrayList currentList = new ArrayList();
                    ArrayList arrayList = LinkGrabberPanel.this.waitingList;
                    synchronized (arrayList) {
                        currentList = new ArrayList(LinkGrabberPanel.this.waitingList);
                        LinkGrabberPanel.this.pc.addToMax((long)currentList.size());
                        LinkGrabberPanel.this.waitingList.removeAll(currentList);
                    }
                    if (!LinkGrabberPanel.this.LGINSTANCE.isLinkCheckEnabled()) {
                        ArrayList<DownloadLink> currentList2 = new ArrayList<DownloadLink>();
                        for (DownloadLink link : currentList) {
                            if (link.getIntegerProperty("forcecheck", 0) != 1) continue;
                            currentList2.add(link);
                        }
                        if (currentList2.size() > 0) {
                            currentList.removeAll(currentList);
                            LinkGrabberPanel.this.lc.checkLinks(currentList2, false);
                        }
                        if (currentList.size() > 0) {
                            LinkGrabberPanel.this.afterLinkGrabber(currentList);
                        }
                    } else {
                        LinkGrabberPanel.this.lc.checkLinks(currentList, false);
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                LinkGrabberPanel.this.lc.getBroadcaster().removeListener((EventListener)INSTANCE);
                LinkGrabberPanel.this.pc.doFinalize();
                LinkGrabberPanel.this.pc.getBroadcaster().removeListener((EventListener)INSTANCE);
                LinkGrabberPanel.this.LGINSTANCE.postprocessing();
                LinkGrabberPanel.this.gatherer_running = false;
                ArrayList fps = new ArrayList(LinkGrabberPanel.this.LGINSTANCE.getPackages());
                int links = 0;
                for (LinkGrabberFilePackage fp : fps) {
                    links += fp.getDownloadLinks().size();
                }
                Balloon.showIfHidden(JDL.L((String)"gui.config.gui.linkgrabber", (String)"LinkGrabber"), JDTheme.II((String)"gui.images.add", (int)32, (int)32), JDL.LF((String)"gui.linkgrabber.finished", (String)"Grabbed %s link(s) in %s Package(s)", (Object[])new Object[]{"" + links, "" + fps.size()}));
                fps = null;
            }
        };
        this.gatherer.start();
    }

    private void afterLinkGrabber(ArrayList<DownloadLink> links) {
        for (DownloadLink link : links) {
            if (!this.gatherer_running) break;
            if (link.getBooleanProperty("removed", false).booleanValue()) continue;
            this.LGINSTANCE.attachToPackagesSecondStage(link);
        }
        this.pc.increase((long)links.size());
        this.Update_Async.restart();
    }

    @Override
    public void onShow() {
        this.notvisible = false;
        this.LGINSTANCE.addListener((LinkGrabberControllerListener)this);
        this.fireTableChanged();
    }

    @Override
    public void actionPerformed(final ActionEvent arg0) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                this.setName("LinkGrabberPanel: actionPerformed");
                if (arg0.getSource() == INSTANCE.Update_Async) {
                    LinkGrabberPanel.this.fireTableChanged();
                    return;
                }
                if (arg0.getSource() == INSTANCE.gathertimer) {
                    LinkGrabberPanel.this.gathertimer.stop();
                    if (LinkGrabberPanel.this.waitingList.size() > 0) {
                        LinkGrabberPanel.this.startLinkGatherer();
                    }
                    return;
                }
                ArrayList<Object> selected_packages = new ArrayList<LinkGrabberFilePackage>();
                ArrayList selected_links = new ArrayList();
                DownloadLink link = null;
                int prio = 0;
                String pw = "";
                HashMap prop = new HashMap();
                String ext = null;
                Set hoster = null;
                String name = null;
                boolean b = false;
                HashSet<String> List2 = new HashSet<String>();
                StringBuilder build = new StringBuilder();
                String string = null;
                Object object = LinkGrabberController.ControllerLock;
                synchronized (object) {
                    ArrayList arrayList = LinkGrabberPanel.this.LGINSTANCE.getPackages();
                    synchronized (arrayList) {
                        ArrayList fps = LinkGrabberPanel.this.LGINSTANCE.getPackages();
                        if (arg0.getSource() instanceof JMenuItem) {
                            switch (arg0.getID()) {
                                case 500: {
                                    hoster = (Set)((LinkGrabberTableAction)((JMenuItem)arg0.getSource()).getAction()).getProperty().getProperty("hoster");
                                    selected_packages = new ArrayList(fps);
                                    selected_packages.add(LinkGrabberPanel.this.LGINSTANCE.getFilterPackage());
                                    break;
                                }
                                case 9991: 
                                case 9992: {
                                    selected_packages = new ArrayList(fps);
                                    selected_packages.add(LinkGrabberPanel.this.LGINSTANCE.getFilterPackage());
                                    break;
                                }
                                case 101: 
                                case 301: 
                                case 501: {
                                    selected_packages = new ArrayList<LinkGrabberFilePackage>(INSTANCE.internalTable.getSelectedFilePackages());
                                    break;
                                }
                                case 200: 
                                case 400: {
                                    prop = (HashMap)((LinkGrabberTableAction)((JMenuItem)arg0.getSource()).getAction()).getProperty().getProperty("infos");
                                    selected_links = (ArrayList)prop.get("links");
                                    break;
                                }
                                case 8: 
                                case 20: 
                                case 100: 
                                case 110: 
                                case 120: 
                                case 201: 
                                case 302: 
                                case 999: {
                                    selected_links = (ArrayList)((LinkGrabberTableAction)((JMenuItem)arg0.getSource()).getAction()).getProperty().getProperty("links");
                                    break;
                                }
                                case 7: {
                                    link = (DownloadLink)((LinkGrabberTableAction)((JMenuItem)arg0.getSource()).getAction()).getProperty().getProperty("link");
                                    break;
                                }
                                case 99999: {
                                    ext = (String)((LinkGrabberTableAction)((JMenuItem)arg0.getSource()).getAction()).getProperty().getProperty("extension");
                                    b = ((JCheckBoxMenuItem)arg0.getSource()).isSelected();
                                }
                            }
                        } else if (arg0.getSource() instanceof LinkGrabberTableAction) {
                            switch (arg0.getID()) {
                                case 999: {
                                    selected_links = (ArrayList)((LinkGrabberTableAction)arg0.getSource()).getProperty().getProperty("links");
                                }
                            }
                        }
                        switch (arg0.getID()) {
                            case 120: {
                                LinkGrabberPanel.this.recheckLinks(selected_links);
                                break;
                            }
                            case 302: {
                                ArrayList<LinkGrabberFilePackage> selected_packages2 = new ArrayList<LinkGrabberFilePackage>();
                                while (selected_links.size() > 0) {
                                    ArrayList arrayList2 = new ArrayList(selected_links);
                                    LinkGrabberFilePackage fp3 = LinkGrabberPanel.this.LGINSTANCE.getFPwithLink((DownloadLink)selected_links.get(0));
                                    if (fp3 == null) {
                                        LinkGrabberPanel.this.logger.warning("DownloadLink not controlled by LinkGrabberController!");
                                        selected_links.remove(selected_links.get(0));
                                        continue;
                                    }
                                    LinkGrabberFilePackage fp4 = new LinkGrabberFilePackage(fp3.getName());
                                    fp4.setDownloadDirectory(fp3.getDownloadDirectory());
                                    fp4.setPassword(fp3.getPassword());
                                    fp4.setExtractAfterDownload(fp3.isExtractAfterDownload());
                                    fp4.setUseSubDir(fp3.useSubDir());
                                    fp4.setComment(fp3.getComment());
                                    for (DownloadLink dl : arrayList2) {
                                        if (LinkGrabberPanel.this.LGINSTANCE.getFPwithLink(dl) == null || LinkGrabberPanel.this.LGINSTANCE.getFPwithLink(dl) != fp3) continue;
                                        fp4.add(dl);
                                        selected_links.remove(dl);
                                    }
                                    selected_packages2.add(fp4);
                                }
                                LinkGrabberPanel.this.confirmPackages(selected_packages2);
                                break;
                            }
                            case 501: {
                                Iterator fp3 = selected_packages.iterator();
                                while (fp3.hasNext()) {
                                    LinkGrabberFilePackage linkGrabberFilePackage;
                                    LinkGrabberFilePackage fp4 = linkGrabberFilePackage = (LinkGrabberFilePackage)fp3.next();
                                    synchronized (fp4) {
                                        ArrayList links2 = new ArrayList(linkGrabberFilePackage.getDownloadLinks());
                                        Set hosts = DownloadLink.getHosterList(links2);
                                        for (String host : hosts) {
                                            LinkGrabberFilePackage fp32 = new LinkGrabberFilePackage(linkGrabberFilePackage.getName());
                                            fp32.setDownloadDirectory(linkGrabberFilePackage.getDownloadDirectory());
                                            fp32.setPassword(linkGrabberFilePackage.getPassword());
                                            fp32.setExtractAfterDownload(linkGrabberFilePackage.isExtractAfterDownload());
                                            fp32.setUseSubDir(linkGrabberFilePackage.useSubDir());
                                            fp32.setComment(linkGrabberFilePackage.getComment());
                                            for (DownloadLink dl : links2) {
                                                if (!dl.getPlugin().getHost().equalsIgnoreCase(host)) continue;
                                                fp32.add(dl);
                                            }
                                            LinkGrabberPanel.this.LGINSTANCE.addPackage(fp32);
                                        }
                                    }
                                }
                                break;
                            }
                            case 9991: {
                                for (LinkGrabberFilePackage linkGrabberFilePackage : selected_packages) {
                                    linkGrabberFilePackage.removeOffline();
                                }
                                break;
                            }
                            case 9992: {
                                for (LinkGrabberFilePackage linkGrabberFilePackage : selected_packages) {
                                    selected_links = linkGrabberFilePackage.getLinksListbyStatus(8192);
                                    linkGrabberFilePackage.remove(selected_links);
                                }
                                break;
                            }
                            case 500: {
                                for (LinkGrabberFilePackage linkGrabberFilePackage : selected_packages) {
                                    linkGrabberFilePackage.keepHostersOnly(hoster);
                                }
                                break;
                            }
                            case 101: {
                                final ArrayList arrayList3 = new ArrayList(selected_packages);
                                new GuiRunnable<Object>(){

                                    @Override
                                    public Object runSave() {
                                        JDFileChooser fc = new JDFileChooser();
                                        fc.setApproveButtonText(JDL.L((String)"gui.btn_ok", (String)"OK"));
                                        fc.setFileSelectionMode(1);
                                        fc.setCurrentDirectory(new File(((LinkGrabberFilePackage)arrayList3.get(0)).getDownloadDirectory()));
                                        if (fc.showOpenDialog(INSTANCE) == 0 && fc.getSelectedFile() != null) {
                                            for (LinkGrabberFilePackage fp2 : arrayList3) {
                                                fp2.setDownloadDirectory(fc.getSelectedFile().getAbsolutePath());
                                            }
                                        }
                                        return null;
                                    }
                                }.start();
                                break;
                            }
                            case 110: {
                                LinkGrabberFilePackage fp = LinkGrabberPanel.this.LGINSTANCE.getFPwithLink((DownloadLink)selected_links.get(0));
                                name = fp.getName();
                            }
                            case 100: {
                                LinkGrabberFilePackage fp = LinkGrabberPanel.this.LGINSTANCE.getFPwithLink((DownloadLink)selected_links.get(0));
                                if (name == null) {
                                    name = UserIO.getInstance().requestInputDialog(0, JDL.L((String)"gui.linklist.newpackage.message", (String)"Name of the new package"), fp.getName());
                                }
                                if (name == null) break;
                                LinkGrabberFilePackage nfp = new LinkGrabberFilePackage(name, (LinkGrabberFilePackageListener)LinkGrabberPanel.this.LGINSTANCE);
                                nfp.setDownloadDirectory(fp.getDownloadDirectory());
                                nfp.setExtractAfterDownload(fp.isExtractAfterDownload());
                                nfp.setUseSubDir(fp.useSubDir());
                                nfp.setComment(fp.getComment());
                                for (DownloadLink dlink : selected_links) {
                                    fp = LinkGrabberPanel.this.LGINSTANCE.getFPwithLink(dlink);
                                    if (fp == null) continue;
                                    nfp.setPassword(fp.getPassword());
                                }
                                nfp.addAll(selected_links);
                                if (GUIUtils.getConfig().getBooleanProperty("PARAM_INSERT_NEW_LINKS_AT2", false).booleanValue()) {
                                    LinkGrabberPanel.this.LGINSTANCE.addPackageAt(nfp, 0, 0);
                                    break;
                                }
                                LinkGrabberPanel.this.LGINSTANCE.addPackage(nfp);
                                break;
                            }
                            case 8: {
                                int i = 0;
                                while (i < selected_links.size()) {
                                    String url;
                                    if (((DownloadLink)selected_links.get(i)).getLinkType() == 0 && !List2.contains(url = ((DownloadLink)selected_links.get(i)).getBrowserUrl())) {
                                        if (List2.size() > 0) {
                                            build.append("\r\n");
                                        }
                                        List2.add(url);
                                        build.append(url);
                                    }
                                    ++i;
                                }
                                string = build.toString();
                                ClipboardHandler.getClipboard().setOldText(string);
                                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
                                break;
                            }
                            case 7: {
                                if (link.getLinkType() != 0) break;
                                try {
                                    JLink.openURL(link.getBrowserUrl());
                                }
                                catch (Exception e1) {
                                    JDLogger.exception((Throwable)e1);
                                }
                                break;
                            }
                            case 20: {
                                GuiRunnable<File> temp = new GuiRunnable<File>(){

                                    @Override
                                    public File runSave() {
                                        JDFileChooser fc = new JDFileChooser("_LOADSAVEDLC");
                                        fc.setFileFilter((FileFilter)new JDFileFilter(null, ".dlc", true));
                                        if (fc.showSaveDialog(SwingGui.getInstance().getMainFrame()) == 0) {
                                            return fc.getSelectedFile();
                                        }
                                        return null;
                                    }
                                };
                                File ret = (File)temp.getReturnValue();
                                if (ret == null) {
                                    return;
                                }
                                if (JDIO.getFileExtension((File)ret) == null || !JDIO.getFileExtension((File)ret).equalsIgnoreCase("dlc")) {
                                    ret = new File(String.valueOf(ret.getAbsolutePath()) + ".dlc");
                                }
                                JDUtilities.getController().saveDLC(ret, selected_links);
                                break;
                            }
                            case 201: {
                                pw = UserIO.getInstance().requestInputDialog(0, JDL.L((String)"gui.linklist.setpw.message", (String)"Set download password"), null);
                                int i = 0;
                                while (i < selected_links.size()) {
                                    ((DownloadLink)selected_links.get(i)).setProperty("pass", (Object)pw);
                                    ++i;
                                }
                                break;
                            }
                            case 400: {
                                b = (Boolean)prop.get("boolean");
                                int i = 0;
                                while (i < selected_links.size()) {
                                    ((DownloadLink)selected_links.get(i)).setEnabled(b);
                                    ++i;
                                }
                                LinkGrabberPanel.this.Update_Async.restart();
                                break;
                            }
                            case 301: {
                                LinkGrabberPanel.this.confirmPackages(selected_packages);
                                break;
                            }
                            case 999: {
                                if (!JDFlags.hasSomeFlags((int)UserIO.getInstance().requestConfirmDialog(544, String.valueOf(JDL.L((String)"gui.downloadlist.delete", (String)"Ausgew\u00e4hlte Links wirklich entfernen?")) + " (" + JDL.LF((String)"gui.downloadlist.delete.size_packagev2", (String)"%s links", (Object[])new Object[]{selected_links.size()}) + ")"), (int[])new int[]{2, 8})) break;
                                for (DownloadLink dlink : selected_links) {
                                    dlink.setProperty("removed", (Object)true);
                                    LinkGrabberFilePackage fp = LinkGrabberPanel.this.LGINSTANCE.getFPwithLink(dlink);
                                    if (fp == null) continue;
                                    fp.remove(dlink);
                                }
                                break;
                            }
                            case 200: {
                                prio = (Integer)prop.get("prio");
                                int i = 0;
                                while (i < selected_links.size()) {
                                    ((DownloadLink)selected_links.get(i)).setPriority(prio);
                                    ++i;
                                }
                                break;
                            }
                            case 99999: {
                                LinkGrabberPanel.this.LGINSTANCE.filterExtension(ext, b);
                            }
                        }
                    }
                }
            }
        }.start();
    }

    private void confirmPackages(ArrayList<LinkGrabberFilePackage> all) {
        if (all.size() == 0) {
            return;
        }
        int i = 0;
        while (i < all.size()) {
            this.confirmPackage(all.get(i), null, i);
            ++i;
        }
        this.LGINSTANCE.throwLinksAdded();
        if (GUIUtils.getConfig().getBooleanProperty("PARAM_START_AFTER_ADDING_LINKS", true).booleanValue()) {
            DownloadWatchDog.getInstance().startDownloads();
        }
    }

    private void addToDownloadDirs(String downloadDirectory, String packageName) {
        if (packageName.length() < 5 || downloadDirectory.equalsIgnoreCase(JDUtilities.getDefaultDownloadDirectory())) {
            return;
        }
        this.getDownloadDirList().add(new String[]{downloadDirectory, packageName});
        GUIUtils.getConfig().save();
    }

    private ArrayList<String[]> getDownloadDirList() {
        return (ArrayList)GUIUtils.getConfig().getGenericProperty("DOWNLOADDIR_LIST", new ArrayList());
    }

    public void confirmPackage(LinkGrabberFilePackage fpv2, String host, int index) {
        ArrayList linkList;
        if (fpv2 == null) {
            return;
        }
        if (this.filePackageInfo.getPackage() != null && this.filePackageInfo.getPackage() == fpv2) {
            this.filePackageInfo.onHideSave();
        }
        if ((linkList = fpv2.getDownloadLinks()).isEmpty()) {
            return;
        }
        for (DownloadLink link : linkList) {
            link.setProperty("forcecheck", Property.NULL);
        }
        FilePackage fp = FilePackage.getInstance();
        fp.setName(fpv2.getName());
        fp.setComment(fpv2.getComment());
        fp.setPassword(fpv2.getPassword());
        fp.setExtractAfterDownload(fpv2.isExtractAfterDownload());
        this.addToDownloadDirs(fpv2.getDownloadDirectory(), fpv2.getName());
        fp.setDownloadDirectory(fpv2.getDownloadDirectory());
        if (fpv2.useSubDir()) {
            File file = new File(new File(fpv2.getDownloadDirectory()), fp.getName());
            fp.setDownloadDirectory(file.getAbsolutePath());
            if (JDUtilities.getConfiguration().getBooleanProperty("CREATE_SUBFOLDER_BEFORE_DOWNLOAD", false).booleanValue() && !file.exists() && !file.mkdirs()) {
                this.logger.severe("could not create " + file.toString());
                fp.setDownloadDirectory(fpv2.getDownloadDirectory());
            }
        }
        if (host == null) {
            fp.addLinks(linkList);
            for (DownloadLink link : linkList) {
                boolean avail = true;
                if (link.isAvailabilityStatusChecked()) {
                    avail = link.isAvailable();
                }
                link.getLinkStatus().reset();
                if (!avail) {
                    link.getLinkStatus().addStatus(32);
                }
                link.setFilePackage(fp);
            }
            fpv2.setDownloadLinks(new ArrayList());
        } else {
            int files = 0;
            ArrayList<DownloadLink> linkListHost = new ArrayList<DownloadLink>();
            int i = fpv2.getDownloadLinks().size() - 1;
            while (i >= 0) {
                if (((DownloadLink)linkList.get(i)).getHost().compareTo(host) == 0) {
                    DownloadLink link = (DownloadLink)linkList.remove(i);
                    boolean avail = true;
                    if (link.isAvailabilityStatusChecked()) {
                        avail = link.isAvailable();
                    }
                    link.getLinkStatus().reset();
                    if (!avail) {
                        link.getLinkStatus().addStatus(32);
                    }
                    linkListHost.add(link);
                    link.setFilePackage(fp);
                    ++files;
                }
                --i;
            }
            if (files == 0) {
                return;
            }
            fp.addLinks(linkListHost);
            fpv2.setDownloadLinks(linkList);
        }
        long curtime = System.currentTimeMillis();
        fp.setCreated(curtime);
        for (DownloadLink link : fp.getDownloadLinkList()) {
            link.setCreated(curtime);
        }
        if (!fpv2.isIgnored()) {
            if (GUIUtils.getConfig() != null && GUIUtils.getConfig().getBooleanProperty("PARAM_INSERT_NEW_LINKS_AT2", false).booleanValue()) {
                JDUtilities.getDownloadController().addPackageAt(fp, index, 0);
            } else {
                JDUtilities.getDownloadController().addPackage(fp);
            }
        }
    }

    public void checkAlreadyinList(DownloadLink link) {
        if (JDUtilities.getDownloadController().hasDownloadLinkwithURL(link.getDownloadURL())) {
            link.getLinkStatus().setErrorMessage(JDL.L((String)"gui.linkgrabber.alreadyindl", (String)"Already on Download List"));
            link.getLinkStatus().addStatus(8192);
        }
    }

    public void onLinkCheckEvent(LinkCheckEvent event) {
        switch (event.getID()) {
            case 4: {
                if (event.getParameter() instanceof ArrayList) {
                    this.afterLinkGrabber((ArrayList)event.getParameter());
                    break;
                }
                if (!(event.getParameter() instanceof DownloadLink)) break;
                ArrayList<DownloadLink> links = new ArrayList<DownloadLink>();
                links.add((DownloadLink)event.getParameter());
                this.afterLinkGrabber(links);
                break;
            }
            case 3: {
                this.stopLinkGatherer();
            }
        }
    }

    public void onProgressControllerEvent(ProgressControllerEvent event) {
        if (event.getSource() == this.pc) {
            this.lc.abortLinkCheck();
            this.stopLinkGatherer();
            return;
        }
    }

    public boolean hasLinks() {
        return this.addinginprogress || this.waitingList.size() > 0 || this.LGINSTANCE.size() > 0 || this.LGINSTANCE.getFilterPackage().size() > 0;
    }

    public void onLinkGrabberControllerEvent(LinkGrabberControllerEvent event) {
        switch (event.getID()) {
            case 2: {
                if (SubConfiguration.getConfig((String)"LINKGRABBER").getBooleanProperty("PARAM_INFOPANEL_ONLINKGRAB").booleanValue()) {
                    this.showFilePackageInfo((LinkGrabberFilePackage)event.getParameter());
                }
                this.Update_Async.restart();
                break;
            }
            case 3: {
                if (this.filePackageInfo.getPackage() != null && this.filePackageInfo.getPackage() == (LinkGrabberFilePackage)event.getParameter()) {
                    if (!this.LGINSTANCE.getPackages().isEmpty()) {
                        this.showFilePackageInfo((LinkGrabberFilePackage)this.LGINSTANCE.getPackages().get(0));
                    } else {
                        this.hideFilePackageInfo();
                    }
                }
                this.Update_Async.restart();
                break;
            }
            case 1: {
                this.Update_Async.restart();
                break;
            }
        }
    }

    public boolean isFilePackageInfoVisible(Object obj) {
        boolean visible;
        boolean bl = visible = LinkgrabberView.getInstance().getInfoPanel() == this.filePackageInfo;
        if (obj != null) {
            return obj instanceof LinkGrabberFilePackage && this.filePackageInfo.getPackage() == obj && visible;
        }
        return visible;
    }
}

