/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import jd.HostPluginWrapper;
import jd.controlling.AccountController;
import jd.gui.swing.jdgui.menu.MenuAction;
import jd.gui.swing.menu.Menu;
import jd.plugins.PluginForHost;
import jd.utils.locale.JDL;

public class HosterMenu
extends Menu {
    public static void update(JComponent c) {
        JMenuItem mi;
        JMenu pluginPopup;
        PluginForHost plugin;
        ArrayList hosts = new ArrayList(HostPluginWrapper.getHostWrapper());
        Collections.sort(hosts, new Comparator<HostPluginWrapper>(){

            @Override
            public int compare(HostPluginWrapper o1, HostPluginWrapper o2) {
                return o1.getHost().compareToIgnoreCase(o2.getHost());
            }
        });
        for (HostPluginWrapper wrapper : hosts) {
            if (!wrapper.isLoaded() || !wrapper.isPremiumEnabled() || !AccountController.getInstance().hasAccounts(wrapper.getHost()) || !wrapper.isEnabled()) continue;
            plugin = wrapper.getPlugin();
            pluginPopup = new JMenu(wrapper.getHost());
            pluginPopup.setIcon(plugin.getHosterIcon());
            for (MenuAction next : plugin.createMenuitems()) {
                mi = HosterMenu.getJMenuItem(next);
                if (mi == null) {
                    pluginPopup.addSeparator();
                    continue;
                }
                pluginPopup.add(mi);
            }
            c.add(pluginPopup);
        }
        c.add(new JSeparator());
        int entries = 10;
        int menus = 25 / entries + 1;
        JMenu[] jmenus = new JMenu[menus];
        JMenu num = new JMenu(JDL.LF((String)"jd.gui.swing.menu.HosterMenu", (String)"Hoster %s", (Object[])new Object[]{"0 - 9"}));
        c.add(num);
        for (HostPluginWrapper wrapper : hosts) {
            if (!wrapper.isLoaded() || !wrapper.isPremiumEnabled()) continue;
            char ccv = wrapper.getHost().toLowerCase().charAt(0);
            JMenu menu = null;
            if (ccv >= '0' && ccv <= '9') {
                menu = num;
            } else {
                int index = (ccv - 97) / entries;
                if (jmenus[index] == null) {
                    int start = 97 + index * entries;
                    int end = Math.min(97 + (1 + index) * entries - 1, 122);
                    jmenus[index] = new JMenu(JDL.LF((String)"jd.gui.swing.menu.HosterMenu", (String)"Hoster %s", (Object[])new Object[]{String.valueOf(new String(new byte[]{(byte)start}).toUpperCase()) + " - " + new String(new byte[]{(byte)end}).toUpperCase()}));
                    c.add(jmenus[index]);
                }
                menu = jmenus[index];
            }
            plugin = wrapper.getPlugin();
            pluginPopup = new JMenu(wrapper.getHost());
            pluginPopup.setIcon(plugin.getHosterIcon());
            for (MenuAction next : plugin.createMenuitems()) {
                mi = HosterMenu.getJMenuItem(next);
                if (mi == null) {
                    pluginPopup.addSeparator();
                    continue;
                }
                pluginPopup.add(mi);
            }
            menu.add(pluginPopup);
        }
    }
}

