/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jd.config.SubConfiguration;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.components.table.JDRowHighlighter;
import jd.gui.swing.jdgui.actions.ThreadedAction;
import jd.gui.swing.jdgui.interfaces.SwitchPanel;
import jd.gui.swing.jdgui.views.toolbar.ViewToolbar;
import jd.nutils.JDFlags;
import jd.plugins.optional.customizer.CustomizeSetting;
import jd.plugins.optional.customizer.CustomizerTable;
import jd.utils.JDTheme;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class CustomizerGui
extends SwitchPanel
implements KeyListener,
ActionListener {
    private static final long serialVersionUID = 7508784076121700378L;
    private static final String JDL_PREFIX = "jd.plugins.optional.customizer.CustomizerGui.";
    private final SubConfiguration config;
    private CustomizerTable table;
    private JTextField tester;
    private JButton reset;

    public CustomizerGui(SubConfiguration config) {
        this.config = config;
        this.initActions();
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout((LayoutManager)new MigLayout("ins 5, wrap 1", "[grow,fill]", "[][grow,fill][]"));
        ViewToolbar vt = new ViewToolbar(){
            private static final long serialVersionUID = -2194834048392779383L;

            public void setDefaults(int i, AbstractButton ab) {
                ab.setForeground(new JLabel().getForeground());
            }
        };
        vt.setList(new String[]{"action.customize.addsetting", "action.customize.removesetting"});
        this.add((Component)vt, "dock north,gapleft 3");
        this.table = new CustomizerTable((ArrayList)this.config.getGenericProperty("SETTINGS", new ArrayList()));
        this.add(new JScrollPane((Component)((Object)this.table)), "growx,growy");
        this.add(new JLabel(JDL.L((String)"jd.plugins.optional.customizer.CustomizerGui.tester", (String)"Insert examplelinks here to highlight the matched setting:")), "split 3, h pref!");
        this.tester = new JTextField();
        this.add(this.tester, "growx, h pref!");
        this.reset = new JButton(JDTheme.II((String)"gui.images.undo", (int)16, (int)16));
        this.add(this.reset, "h pref!");
        this.table.addJDRowHighlighter(new JDRowHighlighter(new Color(204, 255, 170)){

            public boolean doHighlight(Object obj) {
                return ((CustomizeSetting)obj).matches(CustomizerGui.this.tester.getText()) && CustomizerGui.this.tester.getText().length() > 0;
            }
        });
        this.tester.addKeyListener(this);
        this.reset.addActionListener(this);
    }

    private void initActions() {
        new ThreadedAction("action.customize.addsetting", "gui.images.add"){
            private static final long serialVersionUID = 2902582906883565245L;

            public void initDefaults() {
                this.setToolTipText(JDL.L((String)"action.customize.addsetting.tooltip", (String)"Add a new Setting"));
            }

            public void init() {
            }

            public void threadedActionPerformed(ActionEvent e) {
                CustomizerGui.this.table.editingStopped(null);
                new GuiRunnable<Object>(){

                    public Object runSave() {
                        String result = UserIO.getInstance().requestInputDialog(JDL.L((String)"action.customize.addsetting.ask", (String)"Please insert the name for the new Setting:"));
                        if (result != null) {
                            CustomizerGui.this.table.getModel().getSettings().add(new CustomizeSetting(result));
                            CustomizerGui.this.table.getModel().refreshModel();
                            CustomizerGui.this.table.getModel().fireTableDataChanged();
                        }
                        return null;
                    }
                }.start();
            }
        };
        new ThreadedAction("action.customize.removesetting", "gui.images.delete"){
            private static final long serialVersionUID = -961227177718839351L;

            public void initDefaults() {
                this.setToolTipText(JDL.L((String)"action.customize.removesetting.tooltip", (String)"Remove selected Setting(s)"));
            }

            public void init() {
            }

            public void threadedActionPerformed(ActionEvent e) {
                int[] rows = CustomizerGui.this.table.getSelectedRows();
                CustomizerGui.this.table.editingStopped(null);
                if (rows.length == 0) {
                    return;
                }
                if (JDFlags.hasSomeFlags((int)UserIO.getInstance().requestConfirmDialog(0, JDL.LF((String)"action.customize.removesetting.ask", (String)"Remove selected Setting(s)? (%s Account(s))", (Object[])new Object[]{rows.length})), (int[])new int[]{2, 8})) {
                    ArrayList<CustomizeSetting> settings = CustomizerGui.this.table.getModel().getSettings();
                    int i = rows.length - 1;
                    while (i >= 0) {
                        settings.remove(rows[i]);
                        --i;
                    }
                }
                CustomizerGui.this.table.getModel().refreshModel();
                CustomizerGui.this.table.getModel().fireTableDataChanged();
            }
        };
    }

    protected void onHide() {
        this.config.setProperty("SETTINGS", this.table.getModel().getSettings());
        this.config.save();
    }

    protected void onShow() {
        this.table.getModel().setSettings((ArrayList)this.config.getGenericProperty("SETTINGS", new ArrayList()));
        this.table.getModel().refreshModel();
        this.table.getModel().fireTableDataChanged();
    }

    public void keyPressed(KeyEvent e) {
        this.table.getModel().fireTableDataChanged();
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.reset) {
            this.tester.setText("");
            this.table.getModel().fireTableDataChanged();
        }
    }
}

