/*
 * Decompiled with CFR 0.152.
 */
package jd.http.ext;

import java.util.ArrayList;
import java.util.regex.Pattern;
import jd.http.Request;
import jd.http.ext.AdBlockerInterface;
import org.appwork.utils.logging.Log;

public class AdBlocker
implements AdBlockerInterface {
    private static final AdBlocker INSTANCE = new AdBlocker();
    private ArrayList<Pattern> blackList = new ArrayList();

    public static AdBlocker getInstance() {
        return INSTANCE;
    }

    private AdBlocker() {
        this.blackList.add(Pattern.compile(".*\\.doubleclick\\..*", 2));
        this.blackList.add(Pattern.compile(".*partner\\.googleadservices\\..*", 2));
        this.blackList.add(Pattern.compile(".*\\.googlesyndication\\..*", 2));
        this.blackList.add(Pattern.compile(".*\\.google\\..*", 2));
        this.blackList.add(Pattern.compile(".*harrenmedianetwork.*", 2));
        this.blackList.add(Pattern.compile(".*rubiconproject.*", 2));
        this.blackList.add(Pattern.compile(".*scorecardresearch.*", 2));
        this.blackList.add(Pattern.compile(".*\\.addthis\\.com.*", 2));
    }

    public boolean doBlockRequest(Request request) {
        String url = request.getUrl().toExternalForm();
        for (Pattern p : this.blackList) {
            if (!p.matcher(url).matches()) continue;
            Log.L.info("Adblocked: " + url);
            return true;
        }
        return false;
    }

    public String prepareScript(String text, String source) {
        if (source != null) {
            return text;
        }
        String rez = text.replaceAll("(\\s*G._google[^;]*.)", "\r\n/*BlockedByAdblocker $1*/");
        rez = rez.replaceAll("(\\s*google_ad[^;]*.)", "\r\n/*BlockedByAdblocker $1*/");
        rez = rez.replace("<!--", "");
        if (!(rez = rez.replace("-->", "")).equals(text)) {
            System.out.println(rez);
        }
        return rez;
    }
}

