/*
 * Decompiled with CFR 0.152.
 */
package jd.http.ext;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import jd.controlling.JDLogger;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.http.ext.ExtBrowser;
import org.appwork.utils.logging.Log;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.ReadyStateChangeListener;
import org.w3c.dom.Document;

public class ExtHTTPRequest
implements HttpRequest {
    private ExtBrowser browser;
    private ArrayList<ReadyStateChangeListener> listener;
    private int readyState = 0;
    private Request request;
    private boolean asyncFlag;
    private Browser br;

    public ExtHTTPRequest(ExtBrowser browser) {
        this.browser = browser;
        this.listener = new ArrayList();
    }

    public void abort() {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    public void addReadyStateChangeListener(ReadyStateChangeListener listener) {
        this.listener.add(listener);
    }

    public String getAllResponseHeaders() {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    private void changeReadyState(int newState) {
        boolean dif;
        boolean bl = dif = newState > 0 && newState != this.readyState;
        if (newState > 0) {
            this.readyState = newState;
        }
        if (dif) {
            for (ReadyStateChangeListener l : this.listener) {
                l.readyStateChanged();
            }
        }
    }

    public int getReadyState() {
        return this.readyState;
    }

    public byte[] getResponseBytes() {
        return this.request.getResponseBytes();
    }

    public String getResponseHeader(String headerName) {
        return this.request.getResponseHeader(headerName);
    }

    public Image getResponseImage() {
        return this.request.getResponseImage();
    }

    public String getResponseText() {
        try {
            return this.request.getHtmlCode();
        }
        catch (CharacterCodingException e) {
            Log.exception(e);
            return null;
        }
    }

    public Document getResponseXML() {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    public int getStatus() {
        block3: {
            try {
                if (this.request != null && this.request.getHttpConnection() != null) break block3;
                return 403;
            }
            catch (IOException e) {
                Log.exception(e);
                return 511;
            }
        }
        return this.request.getHttpConnection().getResponseCode();
    }

    public String getStatusText() {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    public void open(String method, String url) throws IOException {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    public void open(String method, URL url) throws IOException {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    public void open(String method, URL url, boolean asyncFlag) throws IOException {
        this.open(method, "" + url, asyncFlag);
    }

    public void open(String method, String url, boolean asyncFlag) throws IOException {
        this.asyncFlag = asyncFlag;
        if (!method.equalsIgnoreCase("GET")) {
            RuntimeException e = new RuntimeException("Not implemented");
            Log.exception(e);
            throw e;
        }
        this.br = this.browser.getCommContext().cloneBrowser();
        this.request = this.br.createGetRequest(url);
        this.changeReadyState(1);
    }

    public void open(String method, URL url, boolean asyncFlag, String userName) throws IOException {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    public void open(String method, URL url, boolean asyncFlag, String userName, String password) throws IOException {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    public void send(String content) throws IOException {
        if (this.browser.getBrowserEnviroment().doLoadContent(this.request)) {
            if (this.asyncFlag) {
                new Thread("Asynchloader"){

                    public void run() {
                        try {
                            ExtHTTPRequest.this.br.openRequestConnection(ExtHTTPRequest.this.request);
                            ExtHTTPRequest.this.br.loadConnection(null);
                            ExtHTTPRequest.this.browser.getBrowserEnviroment().prepareContents(ExtHTTPRequest.this.br.getRequest());
                            ExtHTTPRequest.this.changeReadyState(2);
                            ExtHTTPRequest.this.changeReadyState(3);
                            ExtHTTPRequest.this.changeReadyState(4);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }.start();
            } else {
                this.br.openRequestConnection(this.request);
                this.changeReadyState(2);
                String htmlCode = ExtHTTPRequest.read(this.request.getHttpConnection());
                this.request.setHtmlCode(htmlCode);
                this.browser.getBrowserEnviroment().prepareContents(this.br.getRequest());
                this.changeReadyState(3);
                this.changeReadyState(4);
            }
        }
    }

    public static String read(URLConnectionAdapter con) throws IOException {
        StringBuilder htmlCode;
        block28: {
            InputStreamReader isr;
            InputStream is = null;
            if (con.getHeaderField("Content-Encoding") != null && con.getHeaderField("Content-Encoding").equalsIgnoreCase("gzip")) {
                if (con.getInputStream() != null) {
                    is = new GZIPInputStream(con.getInputStream());
                }
            } else if (con.getInputStream() != null) {
                is = con.getInputStream();
            }
            if (is == null) {
                return null;
            }
            String cs = con.getCharset();
            if (cs == null) {
                isr = new InputStreamReader(is, "ISO-8859-1");
            } else {
                cs = cs.toUpperCase();
                try {
                    isr = new InputStreamReader(is, cs);
                }
                catch (Exception e) {
                    try {
                        isr = new InputStreamReader(is, cs.replace("-", ""));
                    }
                    catch (Exception e2) {
                        isr = new InputStreamReader(is);
                    }
                }
            }
            BufferedReader rd = new BufferedReader(isr);
            htmlCode = new StringBuilder();
            try {
                String line;
                while ((line = rd.readLine()) != null) {
                    htmlCode.append(String.valueOf(line) + "\r\n");
                }
            }
            catch (EOFException e) {
                JDLogger.getLogger().log(Level.SEVERE, "Try workaround for ", e);
                try {
                    rd.close();
                }
                catch (Exception exception) {}
                break block28;
            }
            catch (IOException e) {
                try {
                    if (e.toString().contains("end of ZLIB") || e.toString().contains("Premature")) {
                        JDLogger.getLogger().log(Level.SEVERE, "Try workaround for ", e);
                        break block28;
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        rd.close();
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                rd.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return htmlCode.toString();
    }
}

