/*
 * Decompiled with CFR 0.152.
 */
package jd.http.ext;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import jd.http.Browser;
import jd.http.Request;
import jd.http.ext.ExtBrowser;
import jd.http.ext.ExtBrowserException;
import jd.http.ext.ExtHTMLDocumentImpl;
import jd.http.ext.ExtHTMLFrameElement;
import jd.http.ext.ExtHTMLFrameImpl;
import jd.http.ext.ExtHTTPRequest;
import jd.http.ext.RendererUtilities;
import jd.parser.Regex;
import jd.parser.html.Form;
import jd.parser.html.InputField;
import org.appwork.utils.logging.Log;
import org.lobobrowser.html.BrowserFrame;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.HtmlObject;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLIFrameElementImpl;
import org.lobobrowser.html.io.WritableLineReader;
import org.lobobrowser.html.js.Executor;
import org.lobobrowser.html.js.Window;
import org.lobobrowser.html.js.event.BasicEvent;
import org.lobobrowser.html.js.event.JSEventListener;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Document;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.html2.HTMLLinkElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameController
implements HtmlRendererContext,
ExtHTMLFrameElement,
BrowserFrame {
    private static final String DOM_CONTENT_LOADED = "DOMContentLoaded";
    private ExtBrowser extBrowser;
    private HTMLDocumentImpl htmlDocument;
    private FrameController parentFrameController;
    private ExtHTMLFrameImpl frame = null;
    private HashMap<String, ArrayList<JSEventListener>> listenerMap = new HashMap();
    private boolean loaded;
    private Browser comContext;

    public ExtHTMLFrameImpl getFrame() {
        return this.frame;
    }

    public FrameController(ExtBrowser extBrowser) {
        this.extBrowser = extBrowser;
        this.comContext = extBrowser.getCommContext();
    }

    public FrameController(ExtBrowser extBrowser, ExtHTMLFrameImpl f) {
        this.extBrowser = extBrowser;
        this.comContext = extBrowser.getCommContext().cloneBrowser();
        this.frame = f;
    }

    @Override
    public void alert(String arg0) {
        this.extBrowser.onAlert(this, arg0);
    }

    @Override
    public void back() {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public void blur() {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public void close() {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public boolean confirm(String arg0) {
        return this.extBrowser.onConfirm(arg0, this);
    }

    @Override
    public void focus() {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public void forward() {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public String getCurrentURL() {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public String getDefaultStatus() {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public HTMLCollection getFrames() {
        return this.htmlDocument.getFrames();
    }

    @Override
    public int getHistoryLength() {
        return 0;
    }

    @Override
    public HtmlObject getHtmlObject(HTMLElement arg0) {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public String getName() {
        if (this.frame == null) {
            return "";
        }
        return this.frame.getName();
    }

    @Override
    public String getNextURL() {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public HtmlRendererContext getOpener() {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public HtmlRendererContext getParent() {
        return this.parentFrameController;
    }

    public String toString() {
        if (this.htmlDocument == null) {
            return "no Doc";
        }
        return this.htmlDocument.getInnerHTML();
    }

    @Override
    public String getPreviousURL() {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public String getStatus() {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public HtmlRendererContext getTop() {
        FrameController ancestor = this.parentFrameController;
        if (ancestor == null) {
            return this;
        }
        return ancestor.getTop();
    }

    @Override
    public UserAgentContext getUserAgentContext() {
        return this.extBrowser.getUserAgentContext();
    }

    @Override
    public void goToHistoryURL(String arg0) {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public boolean isClosed() {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public boolean isImageLoadingEnabled() {
        return this.extBrowser.getBrowserEnviroment().isImageLoadingEnabled();
    }

    @Override
    public boolean isVisitedLink(HTMLLinkElement arg0) {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public void linkClicked(HTMLElement arg0, URL arg1, String arg2) {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public void moveInHistory(int arg0) {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public void navigate(URL arg0, String arg1) {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public boolean onContextMenu(HTMLElement arg0, MouseEvent arg1) {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public boolean onDoubleClick(HTMLElement arg0, MouseEvent arg1) {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public boolean onMouseClick(HTMLElement arg0, MouseEvent arg1) {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public void onMouseOut(HTMLElement arg0, MouseEvent arg1) {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public void onMouseOver(HTMLElement arg0, MouseEvent arg1) {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public HtmlRendererContext open(String arg0, String arg1, String arg2, boolean arg3) {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public HtmlRendererContext open(URL arg0, String arg1, String arg2, boolean arg3) {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public String prompt(String arg0, String arg1) {
        return this.extBrowser.onPrompt(arg0, arg1, this);
    }

    @Override
    public void reload() {
    }

    @Override
    public void resizeBy(int arg0, int arg1) {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public void resizeTo(int arg0, int arg1) {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public void scroll(int arg0, int arg1) {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public void scrollBy(int arg0, int arg1) {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public void setDefaultStatus(String arg0) {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public void setOpener(HtmlRendererContext arg0) {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    @Override
    public void setStatus(String arg0) {
        RuntimeException e = new RuntimeException("Not implemented");
        Log.exception(e);
        throw e;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void submitForm(String method, URL action, String target, String encoding, FormInput[] formInputs) {
        try {
            this.extBrowser.onFrameLoadStart(this);
            String actualMethod = method.toUpperCase();
            if (actualMethod.equals("GET")) {
                if (formInputs == null || formInputs.length == 0) {
                    Request request = this.comContext.createGetRequest("" + action);
                    if (!this.extBrowser.getBrowserEnviroment().doLoadContent(request)) return;
                    this.comContext.openRequestConnection(request);
                    String htmlCode = ExtHTTPRequest.read(request.getHttpConnection());
                    request.setHtmlCode(htmlCode);
                    this.extBrowser.getBrowserEnviroment().prepareContents(this.comContext.getRequest());
                } else {
                    Form form = new Form();
                    form.setAction("" + action);
                    form.setMethod(Form.MethodType.GET);
                    FormInput[] formInputArray = formInputs;
                    int n = formInputs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FormInput i = formInputArray[n2];
                        if (i.isFile()) {
                            InputField iff = new InputField(i.getName(), i.getTextValue());
                            iff.setFileToPost(i.getFileValue());
                            iff.setType("file");
                            form.addInputField(iff);
                        } else {
                            form.addInputField(new InputField(i.getName(), i.getTextValue()));
                        }
                        ++n2;
                    }
                    Request request = this.comContext.createFormRequest(form);
                    if (!this.extBrowser.getBrowserEnviroment().doLoadContent(request)) return;
                    this.comContext.openRequestConnection(request);
                    this.comContext.loadConnection(null);
                }
            } else {
                RuntimeException e = new RuntimeException("Not implemented");
                Log.exception(e);
                throw e;
            }
            this.extBrowser.onFrameLoadEnd(this);
            this.eval();
            return;
        }
        catch (Exception e) {
            Log.exception(e);
        }
    }

    @Override
    public HTMLDocumentImpl getDocument() {
        return this.htmlDocument;
    }

    public void eval() throws ExtBrowserException {
        this.extBrowser.onFrameEvalStart(this);
        WritableLineReader wis = new WritableLineReader(new StringReader("" + this.comContext)){

            public void write(String text) throws IOException {
                super.write(text);
                System.out.println("Wrote to doc:\r\n" + text);
            }

            public int read() throws IOException {
                int ret = super.read();
                return ret;
            }

            public int read(char[] b, int off, int len) throws IOException {
                int ret = super.read(b, off, len);
                System.out.println("Read " + new String(b));
                return ret;
            }
        };
        this.htmlDocument = new ExtHTMLDocumentImpl(this.getUserAgentContext(), this, wis, String.valueOf(this.comContext.getURL()));
        try {
            try {
                this.htmlDocument.load();
                this.loaded = true;
                System.out.println("Load Frames");
                if (this.extBrowser.getBrowserEnviroment().isAutoProcessSubFrames()) {
                    this.processFrames();
                }
                if (this.frame != null) {
                    if (this.frame.getSrc() != null && this.frame.getSrc().length() > 0) {
                        this.dispatch(new BasicEvent("load", this.frame.getImpl()));
                    }
                } else {
                    this.dispatch(new BasicEvent(DOM_CONTENT_LOADED, this.getDocument()));
                    this.dispatch(new BasicEvent("load", Window.getWindow(this)));
                }
            }
            catch (Exception e) {
                throw new ExtBrowserException(e);
            }
        }
        finally {
            this.extBrowser.onFrameEvalEnd(this);
        }
    }

    private synchronized ArrayList<JSEventListener> getListenerList(String eventName) {
        ArrayList<JSEventListener> ret = this.listenerMap.get(eventName);
        if (ret == null) {
            ret = new ArrayList();
            this.listenerMap.put(eventName, ret);
        }
        return ret;
    }

    public void processFrames() throws ExtBrowserException {
        for (ExtHTMLFrameImpl frame : this.extBrowser.getFrames(this)) {
            if (RendererUtilities.isVisible(frame.getImpl())) {
                System.out.println("Load frame " + frame.getSrc());
                this.processFrame(frame);
                continue;
            }
            System.out.println("Frame not loaded... not visible " + frame.getSrc());
        }
    }

    public ExtHTMLFrameImpl processFrame(ExtHTMLFrameImpl f) throws ExtBrowserException {
        if (f.getImpl() instanceof HTMLIFrameElementImpl && f.getSrc() != null) {
            try {
                ((FrameController)((HTMLIFrameElementImpl)f.getImpl()).getBrowserFrame()).submitForm("GET", new URL(this.comContext.getURL(f.getSrc())), null, null, null);
                return f;
            }
            catch (Exception e) {
                throw new ExtBrowserException(e);
            }
        }
        return null;
    }

    public Regex getRegex(String pattern) {
        return new Regex(this.htmlDocument.getInnerHTML(), pattern);
    }

    @Override
    public String getFrameBorder() {
        return null;
    }

    @Override
    public String getHeight() {
        return null;
    }

    @Override
    public FrameController getHtmlFrameController() {
        return this;
    }

    @Override
    public HTMLElementImpl getImpl() {
        return null;
    }

    @Override
    public String getMarginHeight() {
        return null;
    }

    @Override
    public String getMarginWidth() {
        return null;
    }

    @Override
    public String getScrolling() {
        return null;
    }

    @Override
    public String getSrc() {
        return this.htmlDocument.getDocumentURI();
    }

    @Override
    public String getWidth() {
        return null;
    }

    public Scriptable getScriptableScope() {
        return Window.getWindow(this).getWindowScope();
    }

    public String evalAndReturn(String script) throws ExtBrowserException {
        Scriptable scope = this.getScriptableScope();
        try {
            Context cx = Executor.createContext(new URL(this.getDocument().getURL()), this.extBrowser.getUserAgentContext());
            Object result = cx.evaluateString(scope, "function qwertfbkdsiebdfia432hjfd83j(){return " + script + ";} qwertfbkdsiebdfia432hjfd83j();", "<cmd>", 1, null);
            String ret = Context.toString((Object)result);
            Context.exit();
            return ret;
        }
        catch (MalformedURLException e) {
            throw new ExtBrowserException(e);
        }
    }

    public String getScriptableVariable(String string) {
        Scriptable scope = this.getScriptableScope();
        return (String)scope.get(string, scope);
    }

    @Override
    public void addEventListener(JSEventListener jsEventListener) {
        System.out.println("Listener " + jsEventListener);
        this.removeEventListener(jsEventListener);
        this.getListenerList(jsEventListener.getName()).add(jsEventListener);
    }

    @Override
    public void removeEventListener(JSEventListener jsEventListener) {
        ArrayList<JSEventListener> listener = this.getListenerList(jsEventListener.getName());
        Iterator<JSEventListener> it = listener.iterator();
        while (it.hasNext()) {
            JSEventListener l = it.next();
            if (!l.getName().equals(jsEventListener.getName()) || l.getCallback() != jsEventListener.getCallback() || l.getOwner() != jsEventListener.getOwner()) continue;
            it.remove();
            return;
        }
    }

    @Override
    public void removeEventListeners(String name) {
        this.getListenerList(name).clear();
    }

    @Override
    public boolean dispatch(BasicEvent basicEvent) {
        ArrayList listener = (ArrayList)this.getListenerList(basicEvent.getType()).clone();
        boolean ret = false;
        Iterator it = listener.iterator();
        while (it.hasNext()) {
            ret |= ((JSEventListener)it.next()).dispatch(basicEvent);
        }
        return ret;
    }

    @Override
    public Component getComponent() {
        return null;
    }

    @Override
    public Document getContentDocument() {
        return this.getDocument();
    }

    @Override
    public HtmlRendererContext getHtmlRendererContext() {
        return this;
    }

    @Override
    public void loadURL(final URL url) {
        if (this.getParent() != null && !((FrameController)this.getParent()).loaded) {
            System.out.println("NOT LOADED FRAME " + url + " not loaded yet. QUEUED");
            return;
        }
        System.out.println(this.frame.getImpl() + ".src=" + url);
        new Thread("URLLOADER"){

            public void run() {
                FrameController.this.submitForm("GET", url, null, null, null);
            }
        }.start();
    }

    @Override
    public void setDefaultMarginInsets(Insets insets) {
    }

    @Override
    public void setDefaultOverflowX(int overflowX) {
    }

    @Override
    public void setDefaultOverflowY(int overflowY) {
    }

    public FrameController createParentFrameController(ExtHTMLFrameImpl extHTMLFrameImpl) {
        FrameController rContext = new FrameController(this.extBrowser, extHTMLFrameImpl);
        rContext.parentFrameController = this;
        return rContext;
    }

    @Override
    public BrowserFrame createBrowserFrame() {
        return null;
    }

    @Override
    public String getID() {
        if (this.frame == null) {
            return null;
        }
        return this.frame.getID();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setCommContext(Browser commContext) {
        this.comContext = commContext;
    }
}

