/*
 * Decompiled with CFR 0.152.
 */
package jd.http.ext;

import java.util.ArrayList;
import jd.parser.Regex;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.style.AbstractCSS2Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RendererUtilities {
    public static boolean isVisible(HTMLElementImpl impl) {
        ArrayList<HTMLElementImpl> styles = RendererUtilities.getPath(impl);
        int x = 0;
        int y = 0;
        for (HTMLElementImpl p : styles) {
            AbstractCSS2Properties style = p.getComputedStyle(null);
            if ("none".equalsIgnoreCase(style.getDisplay())) {
                return false;
            }
            if ("absolute".equalsIgnoreCase(style.getPosition())) {
                y = 0;
                x = 0;
            }
            if (style.getTop() != null) {
                y += RendererUtilities.covertToPixel(style.getTop());
            }
            if (style.getLeft() == null) continue;
            x += RendererUtilities.covertToPixel(style.getLeft());
        }
        return y >= 0;
    }

    private static int covertToPixel(String top) {
        if (top == null) {
            return 0;
        }
        if (top.toLowerCase().trim().endsWith("px")) {
            return Integer.parseInt(top.substring(0, top.length() - 2));
        }
        String value = new Regex(top, "([\\-\\+]?\\s*\\d+)").getMatch(0);
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    private static ArrayList<HTMLElementImpl> getPath(HTMLElementImpl impl) {
        ArrayList<HTMLElementImpl> styles = new ArrayList<HTMLElementImpl>();
        HTMLElementImpl p = impl;
        while (p != null) {
            styles.add(0, p);
            p = p.getParent("*");
        }
        return styles;
    }
}

