/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.util.ArrayList;
import org.appwork.utils.formatter.HexFormatter;
import org.appwork.utils.logging.Log;

public class Files {
    public static String getExtension(String name) {
        int index = name.lastIndexOf(".");
        if (index < 0) {
            return null;
        }
        return name.substring(index + 1).toLowerCase();
    }

    public static String getMimeType(String name) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String ret = fileNameMap.getContentTypeFor(name);
        if (ret == null) {
            ret = "unknown/" + Files.getExtension(name);
        }
        return ret;
    }

    public static String getHash(File arg, String type) {
        if (arg == null || !arg.exists() || arg.isDirectory()) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance(type);
            byte[] b = new byte[4096];
            FileInputStream in = new FileInputStream(arg);
            int n = 0;
            while ((n = ((InputStream)in).read(b)) > -1) {
                md.update(b, 0, n);
            }
            ((InputStream)in).close();
            byte[] digest = md.digest();
            return HexFormatter.byteArrayToHex(digest);
        }
        catch (Exception e) {
            Log.exception(e);
            return null;
        }
    }

    public static String getMD5(File arg) {
        return Files.getHash(arg, "md5");
    }

    public static ArrayList<File> getFiles(boolean includeDirectories, boolean includeFiles, File ... files) {
        ArrayList<File> ret = new ArrayList<File>();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.exists()) {
                    if (f.isDirectory()) {
                        if (includeDirectories) {
                            ret.add(f);
                        }
                        ret.addAll(Files.getFiles(includeDirectories, includeFiles, f.listFiles()));
                    } else if (includeFiles) {
                        ret.add(f);
                    }
                }
                ++n2;
            }
        }
        return ret;
    }

    public static void deleteRecursiv(File ... files) throws IOException {
        File file;
        ArrayList<File> ret = Files.getFiles(true, true, files);
        int i = ret.size() - 1;
        while (i >= 0) {
            file = ret.get(i);
            if (!file.exists() || file.isFile()) {
                ret.remove(i);
            }
            if (file.exists() && file.isFile() && !file.delete()) {
                throw new IOException("could not delete " + file);
            }
            --i;
        }
        i = ret.size() - 1;
        while (i >= 0) {
            file = ret.get(i);
            if (file.isDirectory()) {
                ret.remove(i);
            }
            if (file.exists() && file.isDirectory() && !file.delete()) {
                throw new IOException("could not delete " + file);
            }
            --i;
        }
    }
}

