/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.channels.FileChannel;
import org.appwork.utils.os.CrossSystem;

public class IO {
    public static String readFileToString(File file) throws IOException {
        String line;
        BufferedReader f = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
        StringBuilder ret = new StringBuilder();
        String sep = System.getProperty("line.separator");
        while ((line = f.readLine()) != null) {
            ret.append(String.valueOf(line) + sep);
        }
        f.close();
        return ret.toString();
    }

    public static void writeStringToFile(File file, String string) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File is null.");
        }
        if (file.exists()) {
            throw new IllegalArgumentException("File already exists: " + file);
        }
        file.createNewFile();
        if (!file.isFile()) {
            throw new IllegalArgumentException("Is not a file: " + file);
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("Cannot write to file: " + file);
        }
        BufferedWriter output = new BufferedWriter(new FileWriter(file));
        try {
            output.write(string);
        }
        finally {
            ((Writer)output).close();
        }
    }

    public static void writeToFile(File file, byte[] data) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File is null.");
        }
        if (file.exists()) {
            throw new IllegalArgumentException("File already exists: " + file);
        }
        file.createNewFile();
        if (!file.isFile()) {
            throw new IllegalArgumentException("Is not a file: " + file);
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("Cannot write to file: " + file);
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            ((OutputStream)out).write(data);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    public static byte[] readFile(File ressource) throws IOException {
        FileInputStream in = new FileInputStream(ressource);
        byte[] bytes = null;
        try {
            bytes = new byte[(int)ressource.length()];
            ((InputStream)in).read(bytes);
        }
        finally {
            ((InputStream)in).close();
        }
        return bytes;
    }

    public static void copyFile(File in, File out) throws IOException {
        FileChannel inChannel = new FileInputStream(in).getChannel();
        FileChannel outChannel = new FileOutputStream(out).getChannel();
        try {
            if (CrossSystem.isWindows()) {
                int maxCount = 67076096;
                long size = inChannel.size();
                long position = 0L;
                while (position < size) {
                    position += inChannel.transferTo(position, maxCount, outChannel);
                }
            } else {
                inChannel.transferTo(0L, inChannel.size(), outChannel);
            }
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }
}

