/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Regex {
    private Matcher matcher;

    public Regex(Matcher matcher) {
        if (matcher != null) {
            this.matcher = matcher;
        }
    }

    public Regex(Object data, Pattern pattern) {
        this(data.toString(), pattern);
    }

    public Regex(Object data, String pattern) {
        this(data.toString(), pattern);
    }

    public Regex(Object data, String pattern, int flags) {
        this(data.toString(), pattern, flags);
    }

    public Regex(String data, Pattern pattern) {
        if (data != null && pattern != null) {
            this.matcher = pattern.matcher(data);
        }
    }

    public Regex(String data, String pattern) {
        if (data != null && pattern != null) {
            this.matcher = Pattern.compile(pattern, 34).matcher(data);
        }
    }

    public Regex(String data, String pattern, int flags) {
        if (data != null && pattern != null) {
            this.matcher = Pattern.compile(pattern, flags).matcher(data);
        }
    }

    public int count() {
        if (this.matcher == null) {
            return 0;
        }
        this.matcher.reset();
        int c = 0;
        Matcher matchertmp = this.matcher;
        while (matchertmp.find()) {
            ++c;
        }
        return c;
    }

    public String getMatch(int group) {
        if (this.matcher != null) {
            Matcher matcher = this.matcher;
            matcher.reset();
            if (matcher.find()) {
                return matcher.group(group + 1);
            }
        }
        return null;
    }

    public Matcher getMatcher() {
        if (this.matcher != null) {
            this.matcher.reset();
        }
        return this.matcher;
    }

    public String[][] getMatches() {
        if (this.matcher == null) {
            return null;
        }
        Matcher matcher = this.matcher;
        matcher.reset();
        ArrayList<String[]> ar = new ArrayList<String[]>();
        while (matcher.find()) {
            String[] group;
            int c = matcher.groupCount();
            int d = 1;
            if (c == 0) {
                group = new String[c + 1];
                d = 0;
            } else {
                group = new String[c];
            }
            int i = d;
            while (i <= c) {
                group[i - d] = matcher.group(i);
                ++i;
            }
            ar.add(group);
        }
        return ar.size() == 0 ? new String[][]{} : (String[][])ar.toArray((T[])new String[0][]);
    }

    public String[] getColumn(int x) {
        if (this.matcher == null) {
            return null;
        }
        ++x;
        Matcher matcher = this.matcher;
        matcher.reset();
        ArrayList<String> ar = new ArrayList<String>();
        while (matcher.find()) {
            ar.add(matcher.group(x));
        }
        return ar.toArray(new String[ar.size()]);
    }

    public boolean matches() {
        Matcher matcher = this.matcher;
        if (matcher == null) {
            return false;
        }
        matcher.reset();
        return matcher.find();
    }

    public void setMatcher(Matcher matcher) {
        this.matcher = matcher;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        String[][] matches = this.getMatches();
        int matchesLength = matches.length;
        int i = 0;
        while (i < matchesLength) {
            String[] match = matches[i];
            int matchLength = match.length;
            int j = 0;
            while (j < matchLength) {
                ret.append("match[");
                ret.append(i);
                ret.append("][");
                ret.append(j);
                ret.append("] = ");
                ret.append(match[j]);
                ret.append(System.getProperty("line.separator"));
                ++j;
            }
            ++i;
        }
        this.matcher.reset();
        return ret.toString();
    }

    public String getMatch(int entry, int group) {
        if (this.matcher != null) {
            Matcher matcher = this.matcher;
            matcher.reset();
            ++entry;
            int groupCount = 0;
            while (matcher.find()) {
                if (groupCount == group) {
                    return matcher.group(entry);
                }
                ++groupCount;
            }
        }
        return null;
    }

    public String[] getRow(int y) {
        if (this.matcher != null) {
            Matcher matcher = this.matcher;
            matcher.reset();
            int groupCount = 0;
            while (matcher.find()) {
                if (groupCount == y) {
                    int c = matcher.groupCount();
                    String[] group = new String[c];
                    int i = 1;
                    while (i <= c) {
                        group[i - 1] = matcher.group(i);
                        ++i;
                    }
                    return group;
                }
                ++groupCount;
            }
        }
        return null;
    }

    public static String escape(String pattern) {
        char[] specials = new char[]{'(', '[', '{', '\\', '^', '-', '$', '|', ']', '}', ')', '?', '*', '+', '.'};
        int patternLength = pattern.length();
        StringBuilder sb = new StringBuilder();
        sb.setLength(patternLength);
        int i = 0;
        while (i < patternLength) {
            char act = pattern.charAt(i);
            char[] cArray = specials;
            int n = specials.length;
            int n2 = 0;
            while (n2 < n) {
                char s = cArray[n2];
                if (act == s) {
                    sb.append('\\');
                    break;
                }
                ++n2;
            }
            sb.append(act);
            ++i;
        }
        return sb.toString().trim();
    }

    public static String[] getLines(String arg) {
        if (arg == null) {
            return new String[0];
        }
        String[] temp = arg.split("[\r\n]{1,2}");
        int tempLength = temp.length;
        String[] output = new String[tempLength];
        int i = 0;
        while (i < tempLength) {
            output[i] = temp[i].trim();
            ++i;
        }
        return output;
    }

    public static boolean matches(Object str, Pattern pat) {
        return new Regex(str, pat).matches();
    }

    public static boolean matches(Object page, String string) {
        return new Regex(page, string).matches();
    }
}

