/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.event.queue;

import java.util.ArrayList;
import java.util.HashMap;
import org.appwork.utils.event.queue.QueueItem;
import org.appwork.utils.logging.Log;

public abstract class Queue<E extends QueueItem>
extends Thread {
    protected HashMap<QueuePriority, ArrayList<E>> queue = new HashMap();
    protected final Object queueLock = new Object();
    protected boolean waitFlag = true;
    protected E item = null;
    protected Thread thread = null;
    protected QueuePriority[] prios;

    public boolean isQueueThread(E item) {
        if (Queue.currentThread() == this.thread) {
            return true;
        }
        QueueItem source = ((QueueItem)item).getSourceQueueItem();
        while (source != null) {
            if (source.gotStarted()) {
                return true;
            }
            source = source.getSourceQueueItem();
        }
        return false;
    }

    public Queue(String id) {
        super(id);
        QueuePriority[] queuePriorityArray = this.prios = QueuePriority.values();
        int n = this.prios.length;
        int n2 = 0;
        while (n2 < n) {
            QueuePriority prio = queuePriorityArray[n2];
            this.queue.put(prio, new ArrayList());
            ++n2;
        }
        this.start();
    }

    public boolean isWaiting() {
        return this.waitFlag;
    }

    public void add(E item) {
        if (this.isQueueThread(item)) {
            this.startItem(item);
        } else {
            this.internalAdd(item);
        }
    }

    public void enqueue(E item) {
        this.internalAdd(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalAdd(E item) {
        Object object = this.queueLock;
        synchronized (object) {
            this.queue.get((Object)((QueueItem)item).getQueuePrio()).add(item);
        }
        object = this;
        synchronized (object) {
            if (this.waitFlag) {
                this.waitFlag = false;
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addWait(E item) throws Exception {
        if (this.isQueueThread(item)) {
            this.startItem(item);
        } else {
            this.internalAdd(item);
            while (!((QueueItem)item).isFinished()) {
                E e = item;
                synchronized (e) {
                    item.wait(1000L);
                }
            }
        }
        if (((QueueItem)item).gotKilled()) {
            throw new Exception("Queue got killed!");
        }
        if (((QueueItem)item).getException() != null) {
            throw ((QueueItem)item).getException();
        }
        return ((QueueItem)item).getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEmpty() {
        Object object = this.queueLock;
        synchronized (object) {
            QueuePriority[] queuePriorityArray = this.prios;
            int n = this.prios.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                QueuePriority prio = queuePriorityArray[n2];
                if (!this.queue.get((Object)prio).isEmpty()) {
                    return false;
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killQueue() {
        Object object = this.queueLock;
        synchronized (object) {
            QueuePriority[] queuePriorityArray = this.prios;
            int n = this.prios.length;
            int n2 = 0;
            while (n2 < n) {
                QueuePriority prio = queuePriorityArray[n2];
                for (QueueItem item : this.queue.get((Object)prio)) {
                    item.kill();
                    QueueItem queueItem = item;
                    synchronized (queueItem) {
                        item.notify();
                    }
                }
                this.queue.get((Object)prio).clear();
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (this.thread != null) {
            return;
        }
        this.thread = this;
        while (true) {
            Object object = this;
            synchronized (object) {
                while (this.waitFlag) {
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        Log.exception(e);
                    }
                }
            }
            object = this.queueLock;
            synchronized (object) {
                this.item = null;
                QueuePriority[] queuePriorityArray = this.prios;
                int n = this.prios.length;
                int n2 = 0;
                while (n2 < n) {
                    QueuePriority prio = queuePriorityArray[n2];
                    if (this.queue.get((Object)prio).size() > 0) {
                        this.item = (QueueItem)this.queue.get((Object)prio).remove(0);
                        break;
                    }
                    ++n2;
                }
                if (this.item == null) {
                    this.waitFlag = true;
                }
            }
            if (this.item == null || this.waitFlag) continue;
            this.startItem(this.item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startItem(E item) {
        block16: {
            try {
                try {
                    ((QueueItem)item).start(this);
                }
                catch (Exception e) {
                    try {
                        ((QueueItem)item).exceptionHandler(e);
                    }
                    catch (Exception e2) {
                        Log.exception(e2);
                    }
                    E e2 = item;
                    synchronized (e2) {
                        item.notify();
                        break block16;
                    }
                }
            }
            catch (Throwable throwable) {
                E e = item;
                synchronized (e) {
                    item.notify();
                }
                throw throwable;
            }
            E e = item;
            synchronized (e) {
                item.notify();
            }
        }
    }

    public static enum QueuePriority {
        HIGH,
        NORM,
        LOW;

    }
}

