/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.locale;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.appwork.storage.ConfigInterface;
import org.appwork.storage.Storage;
import org.appwork.utils.Application;
import org.appwork.utils.logging.Log;

public class Loc {
    public static final Storage CFG = ConfigInterface.getStorage("Locale");
    public static final String PROPERTY_LOCALE = "PROPERTY_LOCALE2";
    public static final File LOCALIZATION_DIR = Application.getRessource("languages/");
    private static final String FALLBACK_LOCALE = "en_GB";
    private static final File DEFAULT_LOCALIZATION = new File(LOCALIZATION_DIR, String.valueOf(Loc.getDefaultLocale()) + ".loc");
    private static HashMap<Integer, String> data = null;
    private static String locale;
    private static String DEFAULT_LOCALE_CACHE;

    public static String L(String key, String def) {
        String loc;
        if (key == null || (key = key.trim()).length() == 0) {
            throw new IllegalArgumentException();
        }
        if (data == null) {
            Log.L.warning("No parsed localization found! Loading now from saved localization file!");
            try {
                Loc.setLocale(CFG.get(PROPERTY_LOCALE, FALLBACK_LOCALE));
            }
            catch (Exception e) {
                Log.L.severe("Error while loading the stored localization name!");
                Loc.setLocale(FALLBACK_LOCALE);
            }
            if (data == null) {
                return "Error in Loc! No loaded data!";
            }
        }
        if ((loc = data.get(key.toLowerCase().hashCode())) == null) {
            data.put(key.toLowerCase().hashCode(), def);
            return def;
        }
        return loc;
    }

    public static String LF(String key, String def, Object ... args) {
        try {
            return String.format(Loc.L(key, def), args);
        }
        catch (Exception e) {
            return "Error: " + key;
        }
    }

    public static void setLocale(String loc) {
        try {
            if (loc == null) {
                loc = CFG.get(PROPERTY_LOCALE, Loc.getDefaultLocale());
            }
            File file = new File(LOCALIZATION_DIR, String.valueOf(loc) + ".loc");
            locale = loc;
            if (file != null && file.exists()) {
                CFG.put(PROPERTY_LOCALE, loc);
                Loc.parseLocalization(file);
            } else {
                Log.L.info("The language " + loc + " isn't available! Parsing default (" + FALLBACK_LOCALE + ".loc) one!");
                locale = Loc.getDefaultLocale();
                Loc.parseLocalization(DEFAULT_LOCALIZATION);
            }
        }
        catch (Exception e) {
            Log.exception(e);
        }
    }

    private static String getDefaultLocale() {
        String l;
        int n;
        int n2;
        String[] stringArray;
        if (DEFAULT_LOCALE_CACHE != null) {
            return DEFAULT_LOCALE_CACHE;
        }
        String sys = System.getProperty("user.language").toLowerCase();
        String cou = System.getProperty("user.country").toUpperCase();
        String[] locs = Loc.getLocales();
        if (locs.length == 0) {
            DEFAULT_LOCALE_CACHE = FALLBACK_LOCALE;
        }
        if (DEFAULT_LOCALE_CACHE == null) {
            stringArray = locs;
            n2 = locs.length;
            n = 0;
            while (n < n2) {
                l = stringArray[n];
                if (l.equals(String.valueOf(sys) + "_" + cou)) {
                    DEFAULT_LOCALE_CACHE = l;
                    break;
                }
                ++n;
            }
        }
        if (DEFAULT_LOCALE_CACHE == null) {
            stringArray = locs;
            n2 = locs.length;
            n = 0;
            while (n < n2) {
                l = stringArray[n];
                if (l.equals(sys)) {
                    DEFAULT_LOCALE_CACHE = l;
                    break;
                }
                ++n;
            }
        }
        if (DEFAULT_LOCALE_CACHE == null) {
            stringArray = locs;
            n2 = locs.length;
            n = 0;
            while (n < n2) {
                l = stringArray[n];
                if (l.startsWith(String.valueOf(sys) + "_")) {
                    DEFAULT_LOCALE_CACHE = l;
                    break;
                }
                ++n;
            }
        }
        if (DEFAULT_LOCALE_CACHE == null) {
            stringArray = locs;
            n2 = locs.length;
            n = 0;
            while (n < n2) {
                l = stringArray[n];
                if (l.equals(FALLBACK_LOCALE)) {
                    DEFAULT_LOCALE_CACHE = l;
                    break;
                }
                ++n;
            }
        }
        if (DEFAULT_LOCALE_CACHE == null) {
            DEFAULT_LOCALE_CACHE = locs[0];
        }
        return DEFAULT_LOCALE_CACHE;
    }

    public static void parseLocalization(File file) throws IllegalArgumentException {
        block15: {
            if (file == null || !file.exists()) {
                throw new IllegalArgumentException();
            }
            if (data != null) {
                Log.L.finer("Previous HashMap will be overwritten!");
            }
            data = new HashMap();
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
                    while ((line = reader.readLine()) != null) {
                        int split;
                        if (line.startsWith("#") || (split = line.indexOf(61)) <= 0) continue;
                        String key = line.substring(0, split).toLowerCase().trim();
                        String value = line.substring(split + 1).trim();
                        value = value.replace("\\n", "\n").replace("\\r", "\r");
                        data.put(key.hashCode(), value);
                    }
                }
                catch (Exception e) {
                    Log.exception(e);
                    if (reader == null) break block15;
                    try {
                        reader.close();
                    }
                    catch (Exception e2) {
                        Log.exception(e2);
                    }
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        Log.exception(e);
                    }
                }
            }
        }
    }

    public static String getErrorRegex() {
        return Loc.L("system.error", ".*(error|failed).*");
    }

    public static String[] getLocales() {
        String[] files = LOCALIZATION_DIR.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".loc");
            }
        });
        int i = 0;
        while (i < files.length) {
            files[i] = files[i].replace(".loc", "");
            ++i;
        }
        return files;
    }

    public static String getLocale() {
        return locale;
    }
}

