/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging;

import java.text.DateFormat;
import java.util.Date;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.appwork.utils.Exceptions;

public class LogFormatter
extends SimpleFormatter {
    private final Date date = new Date();
    private final DateFormat longTimestamp = DateFormat.getDateTimeInstance(3, 2);
    private final StringBuilder sb = new StringBuilder();
    private int lastThreadID;

    @Override
    public synchronized String format(LogRecord record) {
        this.sb.delete(0, this.sb.capacity());
        this.date.setTime(record.getMillis());
        String message = this.formatMessage(record);
        int th = record.getThreadID();
        if (th != this.lastThreadID) {
            this.sb.append("\r\n THREAD: ");
            this.sb.append(th);
            this.sb.append("\r\n");
        }
        this.lastThreadID = th;
        this.sb.append(record.getThreadID());
        this.sb.append(' ');
        this.sb.append(this.longTimestamp.format(this.date));
        this.sb.append(" - ");
        this.sb.append(record.getLevel().getName());
        this.sb.append(" [");
        if (record.getSourceClassName() != null) {
            this.sb.append(record.getSourceClassName());
        } else {
            this.sb.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            this.sb.append('(');
            this.sb.append(record.getSourceMethodName());
            this.sb.append(')');
        }
        this.sb.append("] ");
        this.sb.append("-> ");
        this.sb.append(message);
        this.sb.append("\r\n");
        if (record.getThrown() != null) {
            this.sb.append(Exceptions.getStackTrace(record.getThrown()));
        }
        return this.sb.toString();
    }
}

