/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.appwork.utils.logging.Log;
import org.appwork.utils.os.mime.Mime;
import org.appwork.utils.os.mime.MimeDefault;
import org.appwork.utils.os.mime.MimeLinux;
import org.appwork.utils.os.mime.MimeWindows;

public class CrossSystem {
    public static final byte OS_LINUX_OTHER = 6;
    public static final byte OS_MAC_OTHER = 5;
    public static final byte OS_WINDOWS_OTHER = 4;
    public static final byte OS_WINDOWS_NT = 3;
    public static final byte OS_WINDOWS_2000 = 2;
    public static final byte OS_WINDOWS_XP = 0;
    public static final byte OS_WINDOWS_2003 = 7;
    public static final byte OS_WINDOWS_VISTA = 1;
    public static final byte OS_WINDOWS_7 = 8;
    private static final byte OS_ID;
    private static final Mime MIME;

    static {
        String OS2 = System.getProperty("os.name").toLowerCase();
        OS_ID = OS2.indexOf("windows 7") > -1 ? (byte)8 : (OS2.indexOf("windows xp") > -1 ? (byte)0 : (OS2.indexOf("windows vista") > -1 ? (byte)1 : (OS2.indexOf("windows 2000") > -1 ? (byte)2 : (OS2.indexOf("windows 2003") > -1 ? (byte)7 : (OS2.indexOf("nt") > -1 ? (byte)3 : (OS2.indexOf("windows") > -1 ? (byte)4 : (OS2.indexOf("mac") > -1 ? (byte)5 : (byte)6)))))));
        MIME = CrossSystem.isWindows() ? new MimeWindows() : (CrossSystem.isLinux() ? new MimeLinux() : new MimeDefault());
    }

    public static void openURL(URL url) {
        Desktop desktop;
        if (!Desktop.isDesktopSupported()) {
            Log.L.severe("Desktop is not supported (fatal)");
        }
        if (!(desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            Log.L.severe("Desktop doesn't support the browse action (fatal)");
        }
        try {
            desktop.browse(url.toURI());
        }
        catch (Exception e) {
            Log.exception(e);
        }
    }

    public static void openFile(File file) {
        Desktop desktop;
        if (CrossSystem.isWindows() && file.isFile()) {
            try {
                Runtime.getRuntime().exec("cmd /c \"" + file.getAbsolutePath() + "\"");
            }
            catch (IOException e) {
                Log.exception(e);
            }
            return;
        }
        if (!Desktop.isDesktopSupported()) {
            Log.L.severe("Desktop is not supported (fatal)");
        }
        if (!(desktop = Desktop.getDesktop()).isSupported(Desktop.Action.OPEN)) {
            Log.L.severe("Desktop doesn't support the OPEN action (fatal)");
        }
        try {
            URI uri = file.getCanonicalFile().toURI();
            desktop.open(new File(uri));
        }
        catch (IOException e) {
            Log.exception(e);
        }
    }

    public static boolean isLinux() {
        return OS_ID == 6;
    }

    public static boolean isMac() {
        return OS_ID == 5;
    }

    public static boolean isWindows() {
        switch (OS_ID) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static Mime getMime() {
        return MIME;
    }
}

