/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.parser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.appwork.utils.Regex;
import org.appwork.utils.logging.Log;

public class HTMLParser {
    public static ArrayList<String> findUrls(String source) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            String[] stringArray = new Regex(source, "((https?|ftp):((//)|(\\\\\\\\))+[\\w\\d:#@%/;$()~_?\\+-=\\\\\\.&]*)(\n|\r|$|<|\")").getColumn(0);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String link = stringArray[n2];
                try {
                    new URL(link);
                    if (!ret.contains(link)) {
                        ret.add(link);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Log.exception(e);
        }
        return HTMLParser.removeDuplicates(ret);
    }

    public static ArrayList<String> removeDuplicates(ArrayList<String> links) {
        ArrayList<String> tmplinks = new ArrayList<String>();
        if (links == null || links.size() == 0) {
            return tmplinks;
        }
        for (String link : links) {
            if (link.contains("...")) {
                String check = link.substring(0, link.indexOf("..."));
                String found = link;
                for (String link2 : links) {
                    if (!link2.startsWith(check) || link2.contains("...")) continue;
                    found = link2;
                    break;
                }
                if (tmplinks.contains(found)) continue;
                tmplinks.add(found);
                continue;
            }
            tmplinks.add(link);
        }
        return tmplinks;
    }
}

