/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.speedmeter;

import org.appwork.utils.speedmeter.SpeedMeterInterface;

public class AverageSpeedMeter
implements SpeedMeterInterface {
    private long[] bytes;
    private long[] times;
    private int size;
    private int index;
    private boolean changed = false;
    private long speed = 0L;
    private final Object LOCK = new Object();
    private long stalled = 0L;
    private long timeout = -1L;

    public AverageSpeedMeter() {
        this(5);
    }

    public void setStallTimeout(long timeout) {
        this.timeout = timeout <= 0L ? -1L : timeout;
    }

    public AverageSpeedMeter(int size) {
        this.size = size;
        this.bytes = new long[this.size];
        this.times = new long[this.size];
        this.index = 0;
        this.resetSpeedMeter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSpeedMeter() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.changed) {
                return this.speed;
            }
            long totalValue = 0L;
            long totalTime = this.stalled;
            int i = 0;
            while (i < this.size) {
                if (this.bytes[i] >= 0L) {
                    totalValue += this.bytes[i];
                    totalTime += this.times[i];
                }
                ++i;
            }
            if (totalTime >= 1000L) {
                this.speed = totalValue * 1000L / totalTime;
            }
            this.changed = false;
            return this.speed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putSpeedMeter(long x, long time) {
        Object object = this.LOCK;
        synchronized (object) {
            long put = Math.max(0L, x);
            if (put == 0L) {
                this.stalled += Math.max(0L, time);
                if (this.timeout > 0L && this.stalled > this.timeout) {
                    this.resetSpeedMeter();
                }
            } else {
                this.bytes[this.index] = put;
                this.times[this.index] = Math.max(0L, time) + this.stalled;
                this.stalled = 0L;
                ++this.index;
                if (this.index == this.size) {
                    this.index = 0;
                }
            }
            this.changed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetSpeedMeter() {
        Object object = this.LOCK;
        synchronized (object) {
            this.index = 0;
            while (this.index < this.size) {
                this.bytes[this.index] = -1L;
                this.times[this.index] = 0L;
                ++this.index;
            }
            this.index = 0;
            this.speed = 0L;
            this.changed = true;
        }
    }
}

