/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing;

import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.Timer;
import net.miginfocom.swing.MigLayout;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.logging.Log;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.SwingUtils;

public class LockPanel
extends JPanel {
    private static final long serialVersionUID = -2262534550090971819L;
    private JFrame frame;
    private Robot robot;
    private BufferedImage screen;
    private BufferedImage gray;
    private Timer fadeTimer;
    private int fadeCounter;
    private double steps;
    private JWindow waitingPanel;
    private JTextArea text;
    private static final HashMap<JFrame, LockPanel> CACHE = new HashMap();
    private float alpha = 0.1f;

    private LockPanel(JFrame frame) throws AWTException {
        this.frame = frame;
        this.robot = new Robot();
        this.waitingPanel = new JWindow();
        frame.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
                if (LockPanel.this.waitingPanel.isVisible()) {
                    LockPanel.this.waitingPanel.toFront();
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        JPanel p = new JPanel();
        this.waitingPanel.setContentPane(p);
        p.setLayout((LayoutManager)new MigLayout("ins 10", "[][fill,grow]", "[fill,grow]"));
        try {
            p.add(new JLabel(ImageProvider.getImageIcon("wait", 32, 32)));
        }
        catch (IOException e) {
            Log.exception(e);
        }
        this.text = new JTextArea();
        p.add((Component)this.text, "spanx,aligny center");
        p.setBorder(BorderFactory.createLineBorder(p.getBackground().darker().darker()));
        JProgressBar bar = new JProgressBar();
        p.add((Component)bar, "growx,pushx,spanx,newline");
        bar.setIndeterminate(true);
        this.text.setBorder(null);
        this.text.setBackground(null);
        this.addMouseListener(new MouseAdapter(){});
    }

    protected JTextArea getText() {
        return this.text;
    }

    public void lock(int time) {
        this.screen = this.createScreenShot();
        if (this.screen != null) {
            this.gray = ImageProvider.convertToGrayScale(this.screen);
            float[] data = new float[]{0.0625f, 0.125f, 0.0625f, 0.125f, 0.25f, 0.125f, 0.0625f, 0.125f, 0.0625f};
            Kernel kernel = new Kernel(3, 3, data);
            ConvolveOp convolve = new ConvolveOp(kernel, 1, null);
            BufferedImage dest = new BufferedImage(this.gray.getWidth(), this.gray.getHeight(), 10);
            this.gray = convolve.filter(this.gray, dest);
            this.frame.setGlassPane(this);
            this.frame.getGlassPane().setVisible(true);
            this.fadeIn(time);
        }
    }

    public void setWaitingPanelText(String wait) {
        if (wait == null) {
            this.waitingPanel.setVisible(false);
        } else {
            this.text.setText(wait);
            this.waitingPanel.pack();
            this.waitingPanel.setLocation(SwingUtils.getCenter(this.frame, this.waitingPanel));
            this.waitingPanel.setVisible(true);
        }
    }

    public synchronized void fadeOut(int time) {
        --this.fadeCounter;
        this.steps = 50.0 / (double)time;
        if (this.fadeCounter > 0) {
            return;
        }
        if (this.fadeTimer != null) {
            this.fadeTimer.stop();
            this.fadeTimer = null;
        }
        this.fadeTimer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LockPanel lockPanel = LockPanel.this;
                lockPanel.alpha = (float)((double)lockPanel.alpha - LockPanel.this.steps);
                if ((double)LockPanel.this.alpha <= 0.0) {
                    LockPanel.this.alpha = 0.0f;
                    if (LockPanel.this.fadeTimer != null) {
                        LockPanel.this.fadeTimer.stop();
                    }
                    LockPanel.this.fadeTimer = null;
                    LockPanel.this.setWaitingPanelText(null);
                    LockPanel.this.frame.getGlassPane().setVisible(false);
                }
                LockPanel.this.repaint();
            }
        });
        this.fadeTimer.setRepeats(true);
        this.fadeTimer.setInitialDelay(0);
        this.fadeTimer.start();
    }

    public synchronized void fadeIn(int time) {
        ++this.fadeCounter;
        this.steps = 50.0 / (double)time;
        if (this.fadeTimer != null) {
            this.fadeTimer.stop();
            this.fadeTimer = null;
        }
        this.fadeTimer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LockPanel lockPanel = LockPanel.this;
                lockPanel.alpha = (float)((double)lockPanel.alpha + LockPanel.this.steps);
                if ((double)LockPanel.this.alpha >= 1.0) {
                    LockPanel.this.alpha = 1.0f;
                    if (LockPanel.this.fadeTimer != null) {
                        LockPanel.this.fadeTimer.stop();
                    }
                }
                LockPanel.this.repaint();
            }
        });
        this.fadeTimer.setRepeats(true);
        this.fadeTimer.setInitialDelay(0);
        this.fadeTimer.start();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Composite comp = ((Graphics2D)g).getComposite();
        ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 1.0f));
        g.drawImage(this.screen, 0, 0, null);
        ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, this.alpha));
        g.drawImage(this.gray, 0, 0, null);
        ((Graphics2D)g).setComposite(comp);
    }

    private BufferedImage createScreenShot() {
        this.frame.toFront();
        boolean top = this.frame.isAlwaysOnTop();
        try {
            BufferedImage bufferedImage = (BufferedImage)new EDTHelper<BufferedImage>(){

                @Override
                public BufferedImage edtRun() {
                    if (LockPanel.this.frame.isShowing()) {
                        LockPanel.this.frame.setAlwaysOnTop(true);
                        Rectangle captureSize = new Rectangle(LockPanel.this.frame.getContentPane().getSize());
                        Point loc = LockPanel.this.frame.getContentPane().getLocationOnScreen();
                        captureSize.x = loc.x;
                        captureSize.y = loc.y;
                        return LockPanel.this.robot.createScreenCapture(captureSize);
                    }
                    return null;
                }
            }.getReturnValue();
            return bufferedImage;
        }
        finally {
            this.frame.setAlwaysOnTop(top);
        }
    }

    public static synchronized LockPanel create(JFrame parentOwner) throws AWTException {
        LockPanel ret = CACHE.get(parentOwner);
        if (ret == null) {
            ret = new LockPanel(parentOwner);
            CACHE.put(parentOwner, ret);
        }
        return ret;
    }

    public void unlock(int i) {
        this.fadeOut(i);
    }
}

