/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.ConfigInterface;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.locale.Tl8;
import org.appwork.utils.logging.Log;
import org.appwork.utils.swing.LockPanel;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.TimerDialog;

public abstract class AbstractDialog
extends TimerDialog
implements ActionListener,
WindowListener {
    private static final long serialVersionUID = 1831761858087385862L;
    protected JButton cancelButton;
    protected JButton okButton;
    protected JComponent panel;
    protected int flagMask;
    private int returnBitMask = 0;
    private ImageIcon icon;
    private String okOption;
    private String cancelOption;
    private JCheckBox dontshowagain;
    private JPanel defaultButtons;

    public AbstractDialog(int flag, String title, ImageIcon icon, String okOption, String cancelOption) {
        super(Dialog.getInstance().getParentOwner());
        this.flagMask = flag;
        this.setTitle(title);
        this.icon = BinaryLogic.containsAll(flag, 256) ? null : icon;
        this.okOption = okOption == null ? Tl8.ABSTRACTDIALOG_BUTTON_OK.toString() : okOption;
        this.cancelOption = cancelOption == null ? Tl8.ABSTRACTDIALOG_BUTTON_CANCEL.toString() : cancelOption;
    }

    public void init() {
        if (BinaryLogic.containsAll(this.flagMask, 32)) {
            try {
                int i = ConfigInterface.getStorage("Dialogs").get(this.getDontShowAgainKey(), -1);
                if (i >= 0) {
                    int ret = i & 6;
                    if (!(BinaryLogic.containsAll(this.flagMask, 512) && BinaryLogic.containsAll(ret |= 0x18, 4) || BinaryLogic.containsAll(this.flagMask, 1024) && BinaryLogic.containsAll(ret, 2))) {
                        this.returnBitMask = ret;
                        return;
                    }
                }
            }
            catch (Exception e) {
                Log.exception(e);
            }
        }
        try {
            if (Dialog.getInstance().getParentOwner() != null) {
                LockPanel.create(Dialog.getInstance().getParentOwner()).lock(500);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (Dialog.getInstance().getParentOwner() == null || !Dialog.getInstance().getParentOwner().isShowing()) {
            this.setAlwaysOnTop(true);
        }
        this.setModal(true);
        this.setLayout((LayoutManager)new MigLayout("ins 5", "[]", "[fill,grow][]"));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.defaultButtons = this.getDefaultButtonPanel();
        JButton focus = this.okButton = new JButton(this.okOption);
        this.cancelButton = new JButton(this.cancelOption);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        if (this.icon != null) {
            this.add((Component)new JLabel(this.icon), "split 2,alignx left,aligny center,shrinkx,gapright 10");
        }
        this.panel = this.layoutDialogContent();
        this.add((Component)this.panel, "pushx,growx,pushy,growy,spanx,aligny center,wrap");
        this.add((Component)this.timerLbl, "split 3,growx,hidemode 2");
        if (BinaryLogic.containsAll(this.flagMask, 32)) {
            this.dontshowagain = new JCheckBox(Tl8.ABSTRACTDIALOG_STYLE_SHOW_DO_NOT_DISPLAY_AGAIN.toString());
            this.dontshowagain.setHorizontalAlignment(11);
            this.dontshowagain.setHorizontalTextPosition(10);
            this.add((Component)this.dontshowagain, "growx,pushx,alignx right,gapleft 20");
        } else {
            this.add(Box.createHorizontalGlue(), "growx,pushx,alignx right,gapleft 20");
        }
        this.add((Component)this.defaultButtons, "alignx right,shrinkx");
        if ((this.flagMask & 8) == 0) {
            this.getRootPane().setDefaultButton(this.okButton);
            this.okButton.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    JButton defaultButton;
                    JRootPane root;
                    if ((e.getChangeFlags() & 1L) != 0L && (root = SwingUtilities.getRootPane(defaultButton = (JButton)e.getComponent())) != null) {
                        root.setDefaultButton(defaultButton);
                    }
                }
            });
            focus = this.okButton;
            this.defaultButtons.add((Component)this.okButton, "alignx right,tag ok,sizegroup confirms");
        }
        if (!BinaryLogic.containsAll(this.flagMask, 16)) {
            this.defaultButtons.add((Component)this.cancelButton, "alignx right,tag cancel,sizegroup confirms");
            if (BinaryLogic.containsAll(this.flagMask, 8)) {
                this.getRootPane().setDefaultButton(this.cancelButton);
                this.cancelButton.requestFocusInWindow();
                focus = this.cancelButton;
            }
        }
        this.addButtons(this.defaultButtons);
        if (BinaryLogic.containsAll(this.flagMask, 4)) {
            this.initTimer(Dialog.getInstance().getCoundownTime());
        } else {
            this.timerLbl.setVisible(false);
        }
        this.invalidate();
        this.pack();
        this.setResizable(true);
        this.toFront();
        this.setMinimumSize(this.getPreferredSize());
        if (this.getDesiredSize() != null) {
            this.setSize(this.getDesiredSize());
        }
        if (Dialog.getInstance().getParentOwner() == null || !Dialog.getInstance().getParentOwner().isDisplayable() || !Dialog.getInstance().getParentOwner().isVisible()) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(new Point((int)(screenSize.getWidth() - (double)this.getWidth()) / 2, (int)(screenSize.getHeight() - (double)this.getHeight()) / 2));
        } else if (Dialog.getInstance().getParentOwner().getExtendedState() == 1) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(new Point((int)(screenSize.getWidth() - (double)this.getWidth() - 20.0), (int)(screenSize.getHeight() - (double)this.getHeight() - 60.0)));
        } else {
            this.setLocation(SwingUtils.getCenter(Dialog.getInstance().getParentOwner(), this));
        }
        KeyStroke ks = KeyStroke.getKeyStroke("ESCAPE");
        focus.getInputMap().put(ks, "ESCAPE");
        focus.getInputMap(1).put(ks, "ESCAPE");
        focus.getInputMap(2).put(ks, "ESCAPE");
        focus.getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = -6666144330707394562L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDialog.this.dispose();
            }
        });
        focus.requestFocus();
        this.packed();
        this.setVisible(true);
        if (Dialog.getInstance().getParentOwner() != null) {
            Dialog.getInstance().getParentOwner().setAlwaysOnTop(true);
            Dialog.getInstance().getParentOwner().setAlwaysOnTop(false);
        }
    }

    protected JPanel getDefaultButtonPanel() {
        return new JPanel((LayoutManager)new MigLayout("ins 0", "[fill,grow]", "[fill,grow]"));
    }

    protected Dimension getDesiredSize() {
        return null;
    }

    protected void addButtons(JPanel buttonBar) {
    }

    protected String getDontShowAgainKey() {
        return "ABSTRACTDIALOG_DONT_SHOW_AGAIN_" + this.getClass().getSimpleName() + "_" + this.toString();
    }

    protected void packed() {
    }

    @Override
    public String toString() {
        return ("dialog-" + this.getTitle()).replaceAll("\\W", "_");
    }

    public abstract JComponent layoutDialogContent();

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.setReturnmask(true);
        } else if (e.getSource() == this.cancelButton) {
            this.setReturnmask(false);
        }
        this.dispose();
    }

    @Override
    public void dispose() {
        try {
            if (Dialog.getInstance().getParentOwner() != null) {
                LockPanel.create(Dialog.getInstance().getParentOwner()).unlock(300);
            }
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
        super.dispose();
    }

    @Override
    protected void onTimeout() {
        this.setReturnmask(false);
        this.returnBitMask |= 0x20;
        this.dispose();
    }

    protected void setReturnmask(boolean b) {
        int n = this.returnBitMask = b ? 2 : 4;
        if (BinaryLogic.containsAll(this.flagMask, 32) && this.dontshowagain.isSelected() && this.dontshowagain.isEnabled()) {
            this.returnBitMask |= 8;
            try {
                ConfigInterface.getStorage("Dialogs").put(this.getDontShowAgainKey(), this.returnBitMask);
            }
            catch (Exception e) {
                Log.exception(e);
            }
        }
    }

    public int getReturnmask() {
        return this.returnBitMask;
    }

    public static void resetDialogInformations() {
        try {
            ConfigInterface.getStorage("Dialogs").clear();
        }
        catch (Exception e) {
            Log.exception(e);
        }
    }

    public boolean closeAllowed() {
        return true;
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        if (this.closeAllowed()) {
            this.returnBitMask |= 0x40;
            this.dispose();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }
}

